/*
 * Decompiled with CFR 0.152.
 */
package marmot.morph.cmd;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import marmot.core.Sequence;
import marmot.morph.Word;
import marmot.morph.io.SentenceReader;

public class SoftEvaluator {
    void eval(Sequence gold_sentence, Sequence pred_sentence, Result result, int num_tokens) {
        assert (gold_sentence.size() == pred_sentence.size());
        for (int i = 0; i < gold_sentence.size(); ++i) {
            Word gold_token = (Word)gold_sentence.get(i);
            Word pred_token = (Word)pred_sentence.get(i);
            result.eval(gold_token, pred_token, 1.0 / (double)num_tokens);
        }
    }

    void eval(String pred_file, Result result) {
        SentenceReader gold_sentences = new SentenceReader("form-index=1,tag-index=4,morph-index=6," + pred_file);
        SentenceReader pred_sentences = new SentenceReader("form-index=1,tag-index=5,morph-index=7," + pred_file);
        this.eval(gold_sentences, pred_sentences, result);
    }

    void eval(Iterable<Sequence> gold_sentences, Iterable<Sequence> pred_sentences, Result result) {
        int num_tokens = 0;
        for (Sequence seq : gold_sentences) {
            num_tokens += seq.size();
        }
        Iterator<Sequence> gold_iter = gold_sentences.iterator();
        Iterator<Sequence> pred_iter = pred_sentences.iterator();
        while (gold_iter.hasNext()) {
            this.eval(gold_iter.next(), pred_iter.next(), result, num_tokens);
        }
        assert (!pred_iter.hasNext());
    }

    public static void main(String[] args) {
        SoftEvaluator evaluator;
        SoftEvaluator softEvaluator = evaluator = new SoftEvaluator();
        Objects.requireNonNull(softEvaluator);
        Result result = softEvaluator.new Result(Mode.Acc);
        evaluator.eval(args, result);
        System.out.print(result.report());
        SoftEvaluator softEvaluator2 = evaluator;
        Objects.requireNonNull(softEvaluator2);
        result = softEvaluator2.new Result(Mode.Jaccard);
        evaluator.eval(args, result);
        System.out.println(" " + result.report());
    }

    public void eval(String[] pred_files, Result result) {
        for (String pred_file : pred_files) {
            this.eval(pred_file, result);
        }
        result.sim /= (double)pred_files.length;
    }

    class Result {
        double sim = 0.0;
        private Mode _mode;

        public Result(Mode mode) {
            this._mode = mode;
        }

        protected Map<String, Double> toVector(String pos, String morph) {
            HashMap<String, Double> map2 = new HashMap<String, Double>();
            map2.put(pos, 1.0);
            if (morph != null && !morph.equals("_")) {
                for (String string : morph.split("\\|")) {
                    map2.put(string, 1.0);
                }
            }
            double norm = 0.0;
            Iterator<Object> iterator2 = map2.values().iterator();
            while (iterator2.hasNext()) {
                double d = (Double)iterator2.next();
                norm += d * d;
            }
            norm = Math.sqrt(norm);
            for (Map.Entry entry : map2.entrySet()) {
                entry.setValue((Double)entry.getValue() / norm);
            }
            return map2;
        }

        protected double calc_jaccard(String gold_pos, String gold_morph, String pred_pos, String pred_morph) {
            return this.jaccard(this.toSet(gold_pos, gold_morph), this.toSet(pred_pos, pred_morph));
        }

        protected double calc_fscore(String gold_pos, String gold_morph, String pred_pos, String pred_morph) {
            return this.fscore(this.toSet(gold_pos, gold_morph), this.toSet(pred_pos, pred_morph));
        }

        private double fscore(Set<String> set, Set<String> set2) {
            HashSet<String> intersection = new HashSet<String>(set);
            intersection.retainAll(set2);
            assert (intersection.size() <= set2.size());
            double p = (double)intersection.size() / (double)set2.size();
            double r = (double)intersection.size() / (double)set.size();
            assert (p <= 1.0);
            assert (r <= 1.0);
            if (p < 1.0E-10) {
                return 0.0;
            }
            if (r < 1.0E-10) {
                return 0.0;
            }
            double f = p * r * 2.0 / (p + r);
            assert (f <= 1.00001);
            return 100.0;
        }

        private double jaccard(Set<String> set, Set<String> set2) {
            HashSet<String> intersection = new HashSet<String>(set);
            intersection.retainAll(set2);
            HashSet<String> union = new HashSet<String>(set);
            union.addAll(set2);
            double score = (double)intersection.size() / (double)union.size();
            return score;
        }

        private Set<String> toSet(String pos, String morph) {
            HashSet<String> set = new HashSet<String>();
            set.add("POS=" + pos);
            if (morph != null && !morph.equals("_")) {
                for (String morpheme : morph.split("\\|")) {
                    set.add(morpheme);
                }
            }
            return set;
        }

        protected double cosineSim(Map<String, Double> vec, Map<String, Double> vec2) {
            double sim = 0.0;
            for (Map.Entry<String, Double> entry : vec.entrySet()) {
                Double d2 = vec2.get(entry.getKey());
                if (d2 == null) continue;
                sim += entry.getValue() * d2;
            }
            return sim * 100.0;
        }

        public void eval(Word gold_token, Word pred_token, double factor) {
            String gold_pos = gold_token.getPosTag();
            String pred_pos = pred_token.getPosTag();
            String gold_morph = gold_token.getMorphTag();
            String pred_morph = pred_token.getMorphTag();
            double pair_sim = 0.0;
            switch (this._mode) {
                case Acc: {
                    pair_sim = this.calc_acc(gold_pos, gold_morph, pred_pos, pred_morph);
                    break;
                }
                case Jaccard: {
                    pair_sim = this.calc_jaccard(gold_pos, gold_morph, pred_pos, pred_morph);
                    break;
                }
                case Cosine: {
                    pair_sim = this.calc_cosineSim(gold_pos, gold_morph, pred_pos, pred_morph);
                    break;
                }
                case Fscore: {
                    pair_sim = this.calc_fscore(gold_pos, gold_morph, pred_pos, pred_morph);
                    break;
                }
                default: {
                    System.err.println("What?");
                }
            }
            this.sim += pair_sim * factor;
        }

        private double calc_acc(String gold_pos, String gold_morph, String pred_pos, String pred_morph) {
            if (gold_pos.equals(pred_pos) && (gold_morph == pred_morph || gold_morph.equals(pred_morph))) {
                return 100.0;
            }
            return 0.0;
        }

        private double calc_cosineSim(String gold_pos, String gold_morph, String pred_pos, String pred_morph) {
            return this.cosineSim(this.toVector(gold_pos, gold_morph), this.toVector(pred_pos, pred_morph));
        }

        public String report() {
            return String.format("%s: %g", this._mode.toString(), this.sim);
        }
    }

    static enum Mode {
        Jaccard,
        Acc,
        Cosine,
        Fscore;

    }
}

