/*
 * Decompiled with CFR 0.152.
 */
package de.ids_mannheim.korap.query.spans;

import de.ids_mannheim.korap.query.SpanTermWithIdQuery;
import de.ids_mannheim.korap.query.spans.SimpleSpans;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermContext;
import org.apache.lucene.search.spans.TermSpans;
import org.apache.lucene.util.Bits;

public class TermSpansWithId
extends SimpleSpans {
    private TermSpans termSpans;

    public TermSpansWithId(SpanTermWithIdQuery spanTermWithIdQuery, LeafReaderContext context, Bits acceptDocs, Map<Term, TermContext> termContexts) throws IOException {
        super(spanTermWithIdQuery, context, acceptDocs, termContexts);
        this.termSpans = (TermSpans)this.firstSpans;
        this.hasMoreSpans = this.termSpans.next();
        this.hasSpanId = true;
    }

    @Override
    public boolean next() throws IOException {
        this.isStartEnumeration = false;
        return this.advance();
    }

    private boolean advance() throws IOException {
        if (this.hasMoreSpans) {
            this.readPayload();
            this.matchDocNumber = this.firstSpans.doc();
            this.matchStartPosition = this.firstSpans.start();
            this.matchEndPosition = this.firstSpans.end();
            this.hasMoreSpans = this.firstSpans.next();
            return true;
        }
        return false;
    }

    private void readPayload() throws IOException {
        List payload = (List)this.firstSpans.getPayload();
        ByteBuffer bb = ByteBuffer.allocate(((byte[])payload.get(0)).length);
        bb.put((byte[])payload.get(0));
        this.setSpanId(bb.getShort(0));
    }

    @Override
    public boolean skipTo(int target) throws IOException {
        if (this.hasMoreSpans && this.firstSpans.doc() < target && !this.firstSpans.skipTo(target)) {
            return false;
        }
        this.matchPayload.clear();
        this.isStartEnumeration = false;
        return this.advance();
    }

    @Override
    public long cost() {
        return this.firstSpans.cost();
    }
}

