/*
 * Decompiled with CFR 0.152.
 */
package marmot.morph.mapper.czech;

import marmot.morph.mapper.MorphTag;

public class PdtMorphTag
implements MorphTag {
    public Pos pos_;
    public Tense tense_;
    public Person person_;
    public Number number_;
    public Type type_;
    public Gender gender_;
    public Case case_;
    public Degree degree_;
    public Negation negation_;
    public Voice voice_;

    public PdtMorphTag() {
        this.reset();
    }

    void reset() {
        this.pos_ = Pos._x;
        this.type_ = Type.X;
        this.tense_ = Tense._x;
        this.person_ = Person._x;
        this.number_ = Number._x;
        this.gender_ = Gender._x;
        this.case_ = Case._x;
        this.degree_ = Degree._x;
        this.negation_ = Negation._x;
        this.voice_ = Voice._x;
    }

    @Override
    public String toHumanMorphString() {
        return this.pos_.toString() + this.type_ + this.gender_ + this.number_ + this.case_ + this.person_ + this.tense_ + this.degree_ + this.negation_ + this.voice_;
    }

    @Override
    public String toPosString() {
        return this.pos_.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.case_ == null ? 0 : this.case_.hashCode());
        result = 31 * result + (this.degree_ == null ? 0 : this.degree_.hashCode());
        result = 31 * result + (this.gender_ == null ? 0 : this.gender_.hashCode());
        result = 31 * result + (this.negation_ == null ? 0 : this.negation_.hashCode());
        result = 31 * result + (this.number_ == null ? 0 : this.number_.hashCode());
        result = 31 * result + (this.person_ == null ? 0 : this.person_.hashCode());
        result = 31 * result + (this.pos_ == null ? 0 : this.pos_.hashCode());
        result = 31 * result + (this.tense_ == null ? 0 : this.tense_.hashCode());
        result = 31 * result + (this.type_ == null ? 0 : this.type_.hashCode());
        result = 31 * result + (this.voice_ == null ? 0 : this.voice_.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PdtMorphTag other = (PdtMorphTag)obj;
        if (this.case_ != other.case_) {
            return false;
        }
        if (this.degree_ != other.degree_) {
            return false;
        }
        if (this.gender_ != other.gender_) {
            return false;
        }
        if (this.negation_ != other.negation_) {
            return false;
        }
        if (this.number_ != other.number_) {
            return false;
        }
        if (this.person_ != other.person_) {
            return false;
        }
        if (this.pos_ != other.pos_) {
            return false;
        }
        if (this.tense_ != other.tense_) {
            return false;
        }
        if (this.type_ != other.type_) {
            return false;
        }
        return this.voice_ == other.voice_;
    }

    static enum Pos {
        a,
        c,
        d,
        i,
        j,
        n,
        p,
        v,
        r,
        t,
        z,
        x,
        _x;

    }

    static enum Type {
        Dash,
        Percent,
        Asterisk,
        Comma,
        Bracket,
        Colon,
        Equals,
        Questionmark,
        At,
        Zircumflex,
        One,
        Two,
        Three,
        Four,
        Five,
        Six,
        Seven,
        Eight,
        Nine,
        A,
        B,
        C,
        D,
        E,
        F,
        G,
        H,
        I,
        J,
        K,
        L,
        M,
        N,
        O,
        P,
        Q,
        R,
        S,
        T,
        U,
        V,
        W,
        X,
        Y,
        Z,
        a,
        b,
        c,
        d,
        e,
        f,
        g,
        h,
        i,
        j,
        k,
        l,
        m,
        n,
        o,
        p,
        q,
        r,
        s,
        t,
        u,
        v,
        w,
        y,
        z,
        x;

    }

    static enum Tense {
        f,
        h,
        p,
        r,
        _x;

    }

    static enum Person {
        fst,
        snd,
        thd,
        _x;

    }

    static enum Number {
        d,
        p,
        s,
        w,
        _x;

    }

    static enum Gender {
        f,
        h,
        i,
        m,
        n,
        q,
        t,
        y,
        z,
        _x;

    }

    static enum Case {
        nom,
        gen,
        dat,
        acc,
        voc,
        loc,
        ins,
        _x;

    }

    static enum Degree {
        pos,
        comp,
        sup,
        _x;

    }

    static enum Negation {
        a,
        n,
        _x;

    }

    static enum Voice {
        a,
        p,
        _x;

    }
}

