/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.option.jdom2;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.transform.Source;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.Transform;
import net.sf.saxon.option.jdom2.JDOM2DocumentWrapper;
import net.sf.saxon.trans.XPathException;
import org.jdom2.Document;
import org.jdom2.JDOMException;
import org.jdom2.input.SAXBuilder;
import org.xml.sax.InputSource;

public class JDOM2Transform
extends Transform {
    @Override
    public List<Source> preprocess(List<Source> sources) throws XPathException {
        try {
            ArrayList<Source> jdomSources = new ArrayList<Source>(sources.size());
            for (Source src : sources) {
                InputSource is;
                Source ss;
                if (src instanceof SAXSource) {
                    ss = (SAXSource)src;
                    is = ((SAXSource)ss).getInputSource();
                } else if (src instanceof StreamSource) {
                    ss = (StreamSource)src;
                    is = ((StreamSource)ss).getInputStream() != null ? new InputSource(((StreamSource)ss).getInputStream()) : (((StreamSource)ss).getReader() != null ? new InputSource(((StreamSource)ss).getReader()) : new InputSource(((StreamSource)ss).getSystemId()));
                } else {
                    throw new IllegalArgumentException("Unknown kind of source");
                }
                is.setSystemId(src.getSystemId());
                SAXBuilder builder = new SAXBuilder();
                Document doc = builder.build(is);
                doc.setBaseURI(is.getSystemId());
                JDOM2DocumentWrapper jdom = new JDOM2DocumentWrapper(doc, this.getConfiguration());
                jdomSources.add(jdom.getRootNode().asActiveSource());
            }
            return jdomSources;
        }
        catch (IOException | JDOMException e) {
            throw new XPathException(e);
        }
    }

    public static void main(String[] args) {
        new JDOM2Transform().doTransform(args);
    }
}

