/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.trans;

import com.saxonica.ee.stream.Streamability;
import com.saxonica.ee.stream.Sweep;
import com.saxonica.ee.trans.TemplateRuleEE;
import java.util.ArrayList;
import net.sf.saxon.expr.ErrorExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.style.Compilation;
import net.sf.saxon.style.ComponentDeclaration;
import net.sf.saxon.style.XSLTemplate;
import net.sf.saxon.trans.Mode;
import net.sf.saxon.trans.SimpleMode;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.trans.XmlProcessingException;
import net.sf.saxon.trans.rules.RuleManager;

public class TemplateRuleInitializer {
    private final Compilation compilation;
    private final XSLTemplate xslTemplate;
    private final ComponentDeclaration decl;
    private final StructuredQName modeName;
    private final TemplateRuleEE templateRule;
    private boolean firstTime = true;

    TemplateRuleInitializer(Compilation comp, ComponentDeclaration decl, TemplateRuleEE templateRule) {
        this.compilation = comp;
        this.decl = decl;
        this.templateRule = templateRule;
        this.modeName = templateRule.getMode().getModeName();
        this.xslTemplate = (XSLTemplate)decl.getSourceElement();
    }

    public synchronized void init() throws XPathException {
        if (this.firstTime) {
            try {
                this.xslTemplate.jitCompile(this.compilation, this.decl);
                ExpressionVisitor visitor = new ExpressionVisitor(this.compilation.getConfiguration());
                visitor.setStaticContext(this.xslTemplate.getStaticContext());
                ContextItemStaticInfo cisi = new ContextItemStaticInfo(this.xslTemplate.getContextItemTypeForTemplateRule(), false);
                RuleManager mgr = this.compilation.getPrincipalStylesheetModule().getRuleManager();
                Mode m = mgr.obtainMode(this.modeName, false);
                visitor.setOptimizeForStreaming(m.isDeclaredStreamable());
                Expression body = this.templateRule.getBody().typeCheck(visitor, cisi);
                this.templateRule.setBody(ExpressionTool.optimizeComponentBody(body, this.compilation, visitor, cisi, false));
                SimpleMode.allocateBindingSlotsRecursive(this.xslTemplate.getPackageData(), m, this.templateRule.getBody(), m.getDeclaringComponent().getComponentBindings());
                if (this.compilation.getCompilerInfo().getCodeInjector() != null) {
                    this.compilation.getCompilerInfo().getCodeInjector().process(this.templateRule);
                }
                ExpressionTool.allocateSlots(this.templateRule.getBody(), this.templateRule.getStackFrameMap().getNumberOfVariables(), this.templateRule.getStackFrameMap());
                if (m.isDeclaredStreamable()) {
                    ArrayList<String> reasons = new ArrayList<String>();
                    if (!this.templateRule.isActuallyStreamable(reasons)) {
                        StringBuilder message = new StringBuilder("Template rule is not streamable");
                        for (String reason : reasons) {
                            message.append("\n  * ").append(reason);
                        }
                        throw new XPathException(message.toString(), "XTSE3430", this.templateRule);
                    }
                    if (Streamability.getSweep(this.templateRule.getBody()) == Sweep.CONSUMING) {
                        this.templateRule.makeInversion();
                    }
                }
            }
            catch (XPathException e) {
                this.templateRule.setBody(new ErrorExpression(new XmlProcessingException(e)));
                this.firstTime = false;
                throw e;
            }
            this.firstTime = false;
        }
    }
}

