/*
 * Decompiled with CFR 0.152.
 */
package lemming.lemma;

import java.util.Map;
import lemming.lemma.LemmaCandidateSet;
import lemming.lemma.LemmaInstance;
import lemming.lemma.LemmatizerGenerator;
import lemming.lemma.SimpleLemmatizerTrainer;
import marmot.util.Counter;

public class SimpleLemmatizer
implements LemmatizerGenerator {
    private static final long serialVersionUID = 1L;
    private static final String SEPARATOR = "\t";
    private Map<String, Counter<String>> map_;
    private SimpleLemmatizerTrainer.SimpleLemmatizerTrainerOptions options_;

    public SimpleLemmatizer(SimpleLemmatizerTrainer.SimpleLemmatizerTrainerOptions options, Map<String, Counter<String>> map2) {
        this.map_ = map2;
        this.options_ = options;
    }

    public static String toKey(LemmaInstance instance) {
        String pos_tag = instance.getPosTag();
        if (pos_tag == null) {
            return null;
        }
        String form = instance.getForm();
        return String.format("%s%s%s", form, SEPARATOR, pos_tag);
    }

    @Override
    public String lemmatize(LemmaInstance instance) {
        Counter<String> lemmas = null;
        String key = null;
        if (this.options_.getUsePos() && (key = SimpleLemmatizer.toKey(instance)) != null && (lemmas = this.map_.get(key)) != null && (!this.options_.getAbstainIfAmbigous() || lemmas.size() == 1)) {
            return lemmas.max();
        }
        if (this.options_.getUseBackup() && (key = SimpleLemmatizer.toSimpleKey(instance)) != null && (lemmas = this.map_.get(key)) != null && (!this.options_.getAbstainIfAmbigous() || lemmas.size() == 1)) {
            return lemmas.max();
        }
        if (this.options_.getHandleUnseen()) {
            return instance.getForm();
        }
        return null;
    }

    public static String toSimpleKey(LemmaInstance instance) {
        return instance.getForm();
    }

    private void addCandidates(Counter<String> lemmas, LemmaCandidateSet set) {
        if (lemmas != null) {
            for (Map.Entry<String, Double> lemma : lemmas.entrySet()) {
                set.getCandidate(lemma.getKey());
            }
        }
    }

    @Override
    public void addCandidates(LemmaInstance instance, LemmaCandidateSet set) {
        Counter<String> lemmas;
        String key = SimpleLemmatizer.toKey(instance);
        if (key != null) {
            lemmas = this.map_.get(key);
            this.addCandidates(lemmas, set);
        }
        if ((key = SimpleLemmatizer.toSimpleKey(instance)) != null) {
            lemmas = this.map_.get(key);
            this.addCandidates(lemmas, set);
        }
    }

    @Override
    public boolean isOOV(LemmaInstance instance) {
        return this.map_.get(SimpleLemmatizer.toSimpleKey(instance)) == null;
    }
}

