/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.schema;

import com.saxonica.ee.schema.Assertion;
import com.saxonica.ee.schema.Facet;
import com.saxonica.ee.schema.SchemaCompiler;
import com.saxonica.ee.schema.SchemaModelSerializer;
import com.saxonica.ee.schema.UserSimpleType;
import net.sf.saxon.expr.Callable;
import net.sf.saxon.expr.CallableDelegate;
import net.sf.saxon.functions.CallableFunction;
import net.sf.saxon.lib.ConversionRules;
import net.sf.saxon.om.AtomicSequence;
import net.sf.saxon.om.FunctionItem;
import net.sf.saxon.str.StringView;
import net.sf.saxon.str.UnicodeString;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.SimpleType;
import net.sf.saxon.type.SpecificFunctionType;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.ObjectValue;
import net.sf.saxon.value.StringValue;

public class AssertionFacet
extends Facet {
    Assertion assertion;

    public AssertionFacet(Assertion assertion) {
        this.assertion = assertion;
    }

    @Override
    public String getName() {
        return "assertion";
    }

    @Override
    public String getConstraintName() {
        return "cvc-assertions-valid";
    }

    @Override
    public UnicodeString getValue() {
        return StringView.tidy(this.assertion.getConditionText());
    }

    @Override
    public void checkFacetRestriction(UserSimpleType type, SimpleType base, SchemaCompiler compiler) {
    }

    @Override
    public boolean testAtomicValue(AtomicValue value) {
        throw new UnsupportedOperationException("Validation context required");
    }

    public boolean testAtomicValue(AtomicValue value, ConversionRules validationContext) {
        return this.assertion.testSimple(value, validationContext);
    }

    @Override
    public boolean testListValue(AtomicSequence value) {
        throw new UnsupportedOperationException("Validation context required");
    }

    public boolean testListValue(AtomicSequence value, ConversionRules rules) {
        return this.assertion.testSimple(value, rules);
    }

    @Override
    public void serializeFacet(SchemaModelSerializer serializer) throws XPathException {
        serializer.startElement("assert");
        if (this.isFixed()) {
            serializer.emitAttribute("fixed", "true");
        }
        this.assertion.serialize(serializer);
        serializer.endElement();
    }

    @Override
    public FunctionItem getFacetAsFunctionItem() {
        AssertionFacet facet = this;
        CallableDelegate callable = new CallableDelegate((context, arguments) -> {
            String key;
            switch (key = arguments[0].head().getStringValue()) {
                case "class": {
                    return new StringValue(this.getName());
                }
                case "implementation": {
                    return new ObjectValue<AssertionFacet>(facet);
                }
                case "value": {
                    return this.assertion.getComponentAsFunction();
                }
            }
            return EmptySequence.getInstance();
        });
        return new CallableFunction(1, (Callable)callable, SpecificFunctionType.COMPONENT_FUNCTION_TYPE);
    }
}

