/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.stream.feed;

import com.saxonica.ee.stream.feed.ItemFeed;
import net.sf.saxon.event.Builder;
import net.sf.saxon.event.ComplexContentOutputter;
import net.sf.saxon.event.Outputter;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.AttributeMap;
import net.sf.saxon.om.NamespaceMap;
import net.sf.saxon.om.NamespaceUri;
import net.sf.saxon.om.NoNamespaceName;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.s9api.Location;
import net.sf.saxon.str.StringView;
import net.sf.saxon.str.UnicodeString;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.tiny.TinyBuilder;
import net.sf.saxon.tree.util.Orphan;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.SimpleType;

public abstract class GroundedItemFeed
extends ItemFeed {
    private int level;
    private Builder builder;
    private Outputter buildingOutputter;

    public GroundedItemFeed(ItemFeed result, XPathContext context) {
        super(result, context);
    }

    public GroundedItemFeed(Expression exp, ItemFeed result, XPathContext context) {
        super(exp, result, context);
    }

    private void makeBuilder() throws XPathException {
        this.builder = new TinyBuilder(this.getPipelineConfiguration());
        this.buildingOutputter = new ComplexContentOutputter(this.builder);
        this.buildingOutputter.open();
    }

    @Override
    public void startDocument(int properties) throws XPathException {
        if (this.buildingOutputter == null) {
            this.level = 0;
            this.makeBuilder();
        } else {
            ++this.level;
        }
        this.buildingOutputter.startDocument(0);
    }

    @Override
    public void endDocument() throws XPathException {
        --this.level;
        this.buildingOutputter.endDocument();
        if (this.level == 0) {
            this.buildingOutputter.close();
            NodeInfo node = this.builder.getCurrentRoot();
            this.append(node);
            this.builder = null;
            this.buildingOutputter = null;
        }
    }

    @Override
    public void setUnparsedEntity(String name, String systemID, String publicID) throws XPathException {
        if (this.buildingOutputter != null) {
            this.buildingOutputter.setUnparsedEntity(name, systemID, publicID);
        }
    }

    @Override
    public void startElement(NodeName elemName, SchemaType type, AttributeMap attributes, NamespaceMap namespaces, Location location, int properties) throws XPathException {
        if (this.builder == null) {
            this.level = 0;
            this.makeBuilder();
        }
        ++this.level;
        this.buildingOutputter.startElement(elemName, type, attributes, namespaces, location, properties);
    }

    @Override
    public void startElement(NodeName elemName, SchemaType typeCode, Location location, int properties) throws XPathException {
        if (this.builder == null) {
            this.level = 0;
            this.makeBuilder();
        }
        ++this.level;
        this.buildingOutputter.startElement(elemName, typeCode, location, properties);
    }

    @Override
    public void namespace(String prefix, NamespaceUri namespaceUri, int properties) throws XPathException {
        if (this.buildingOutputter == null) {
            Orphan orphan = new Orphan(this.getConfiguration());
            orphan.setNodeKind((short)13);
            orphan.setNodeName(new NoNamespaceName(prefix));
            orphan.setStringValue(namespaceUri.toUnicodeString());
            this.append(orphan);
        } else {
            this.buildingOutputter.namespace(prefix, namespaceUri, properties);
        }
    }

    @Override
    public void attribute(NodeName attName, SimpleType typeCode, String value, Location location, int properties) throws XPathException {
        if (this.buildingOutputter == null) {
            Orphan orphan = new Orphan(this.getConfiguration());
            orphan.setNodeKind((short)2);
            orphan.setTypeAnnotation(typeCode);
            orphan.setNodeName(attName);
            orphan.setStringValue(StringView.tidy(value));
            this.append(orphan);
        } else {
            this.buildingOutputter.attribute(attName, typeCode, value, location, properties);
        }
    }

    @Override
    public void startContent() throws XPathException {
        if (this.buildingOutputter != null) {
            this.buildingOutputter.startContent();
        }
    }

    @Override
    public void endElement() throws XPathException {
        --this.level;
        if (this.buildingOutputter != null) {
            this.buildingOutputter.endElement();
            if (this.level == 0) {
                this.buildingOutputter.close();
                NodeInfo node = this.builder.getCurrentRoot();
                this.append(node);
                this.builder = null;
                this.buildingOutputter = null;
            }
        }
    }

    @Override
    public void characters(UnicodeString chars, Location location, int properties) throws XPathException {
        if (this.buildingOutputter == null) {
            Orphan orphan = new Orphan(this.getConfiguration());
            orphan.setNodeKind((short)3);
            orphan.setStringValue(chars.tidy());
            this.append(orphan);
        } else {
            this.buildingOutputter.characters(chars, location, properties);
        }
    }

    @Override
    public void processingInstruction(String name, UnicodeString data, Location location, int properties) throws XPathException {
        if (this.buildingOutputter == null) {
            Orphan orphan = new Orphan(this.getConfiguration());
            orphan.setNodeKind((short)7);
            orphan.setNodeName(new NoNamespaceName(name));
            orphan.setStringValue(data.tidy());
            this.append(orphan);
        } else {
            this.buildingOutputter.processingInstruction(name, data, location, properties);
        }
    }

    @Override
    public void comment(UnicodeString content, Location location, int properties) throws XPathException {
        if (this.buildingOutputter == null) {
            Orphan orphan = new Orphan(this.getConfiguration());
            orphan.setNodeKind((short)8);
            orphan.setStringValue(content.tidy());
            this.append(orphan);
        } else {
            this.buildingOutputter.comment(content, location, properties);
        }
    }
}

