/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.xsltextn.style;

import net.sf.saxon.expr.Component;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.instruct.GlobalVariable;
import net.sf.saxon.expr.instruct.UserFunction;
import net.sf.saxon.om.AttributeInfo;
import net.sf.saxon.om.NamespaceUri;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.query.QueryLibrary;
import net.sf.saxon.query.QueryModule;
import net.sf.saxon.query.StaticQueryContext;
import net.sf.saxon.query.XQueryExpression;
import net.sf.saxon.query.XQueryFunction;
import net.sf.saxon.style.Compilation;
import net.sf.saxon.style.ComponentDeclaration;
import net.sf.saxon.style.PrincipalStylesheetModule;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.style.StylesheetPackage;
import net.sf.saxon.trans.CompilerInfo;
import net.sf.saxon.trans.Visibility;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.Whitespace;

public class SaxonImportQuery
extends StyleElement {
    private String href;
    private NamespaceUri moduleURI;

    @Override
    public boolean isInXsltNamespace() {
        return false;
    }

    @Override
    protected void prepareAttributes() {
        if (this.href != null || this.moduleURI != null) {
            return;
        }
        for (AttributeInfo att : this.attributes()) {
            NodeName attName = att.getNodeName();
            String f = attName.getDisplayName();
            String value = att.getValue();
            if (f.equals("href")) {
                this.href = Whitespace.trim(value);
                continue;
            }
            if (f.equals("namespace")) {
                this.moduleURI = NamespaceUri.of(Whitespace.trim(value));
                continue;
            }
            this.checkUnknownAttribute(attName);
            this.moduleURI = NamespaceUri.NULL;
        }
        if (this.moduleURI == null) {
            this.reportAbsence("namespace");
        }
    }

    @Override
    public void index(ComponentDeclaration decl, PrincipalStylesheetModule top) throws XPathException {
        this.prepareAttributes();
        if (this.moduleURI == null) {
            return;
        }
        try {
            PrincipalStylesheetModule top1 = this.getPrincipalStylesheetModule();
            top1.getStylesheetPackage().markNonExportable("Uses saxon:import-query", "SXST0069");
            QueryModule importedModule = this.getQueryLibrary(this.moduleURI);
            if (importedModule == null) {
                if (this.href == null) {
                    this.compileError("Cannot locate query module for namespace " + this.moduleURI, "XQST0059");
                    return;
                }
                importedModule = this.loadModule();
            }
            for (GlobalVariable queryVar : importedModule.getPackageData().getGlobalVariableList()) {
                if (!queryVar.isPrivate() && top1.getGlobalVariableBinding(queryVar.getVariableQName()) != null) {
                    throw new XPathException("Duplicate global variable declaration " + queryVar.getVariableQName().getDisplayName(), "XQST0049");
                }
                top1.addGlobalVariable(queryVar, queryVar.isPrivate() ? Visibility.HIDDEN : Visibility.PRIVATE);
            }
            for (XQueryFunction def : importedModule.getGlobalFunctionLibrary().getFunctionDefinitions()) {
                if (!def.getFunctionName().hasURI(this.moduleURI) || def.isPrivate()) continue;
                top1.declareXQueryFunction(def);
                UserFunction fn = def.getUserFunction();
                StylesheetPackage pack = top1.getStylesheetPackage();
                Component component = fn.makeDeclaringComponent(Visibility.PRIVATE, pack);
                if (fn.getPackageData() == null) {
                    fn.setPackageData(pack);
                }
                pack.getComponentIndex().put(def.getIdentificationKey(), component);
            }
        }
        catch (XPathException err) {
            this.compileError(err);
        }
    }

    @Override
    public void validate(ComponentDeclaration decl) throws XPathException {
        this.checkEmpty();
        this.checkTopLevel("XTSE0010", false);
        this.getConfiguration().checkLicensedFeature(8, "saxon:import-query", this.getPackageData().getLocalLicenseId());
    }

    private QueryLibrary getQueryLibrary(NamespaceUri namespace) {
        CompilerInfo info = this.getCompilation().getCompilerInfo();
        Iterable<QueryLibrary> libs = info.getQueryLibraries();
        if (libs != null) {
            for (QueryLibrary lib : libs) {
                if (!lib.getModuleNamespace().equals(namespace)) continue;
                return lib;
            }
        }
        return null;
    }

    private QueryModule loadModule() throws XPathException {
        StaticQueryContext sqc = this.getConfiguration().newStaticQueryContext();
        sqc.setBaseURI(this.getBaseURI());
        sqc.setErrorReporter(this.getCompilation().getCompilerInfo().getErrorReporter());
        String mainModule = "import module namespace m = \"" + this.moduleURI + "\" at \"" + this.href + "\"; ()";
        XQueryExpression exp = sqc.compileQuery(mainModule);
        return exp.getMainModule();
    }

    @Override
    public Expression compile(Compilation exec, ComponentDeclaration decl) throws XPathException {
        return null;
    }
}

