/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.bytecode;

import com.saxonica.ee.bytecode.ExpressionCompiler;
import com.saxonica.ee.bytecode.ToIteratorCompiler;
import com.saxonica.ee.bytecode.map.CompiledItemMappingFunction;
import com.saxonica.ee.bytecode.util.CannotCompileException;
import com.saxonica.ee.bytecode.util.CompilerService;
import com.saxonica.ee.bytecode.util.GeneratedMethodInfo;
import com.saxonica.ee.bytecode.util.Generator;
import com.saxonica.ee.bytecode.util.LabelInfo;
import com.saxonica.ee.bytecode.util.MessageFromStack;
import com.saxonica.functions.hof.CoercedFunction;
import com.saxonica.functions.hof.FunctionSequenceCoercer;
import com.saxonica.objectweb.asm.ClassVisitor;
import com.saxonica.objectweb.asm.ClassWriter;
import com.saxonica.objectweb.asm.Type;
import com.saxonica.objectweb.asm.commons.Method;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ItemMappingFunction;
import net.sf.saxon.expr.ItemMappingIterator;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.RoleDiagnostic;
import net.sf.saxon.om.Function;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.SpecificFunctionType;
import net.sf.saxon.type.UType;

public class FunctionSequenceCoercerCompiler
extends ToIteratorCompiler {
    @Override
    public void compileToIterator(CompilerService compiler, Expression expression) throws CannotCompileException {
        Generator ga = compiler.getCurrentGenerator();
        FunctionSequenceCoercer functionCoercer = (FunctionSequenceCoercer)expression;
        Expression operand = functionCoercer.getBaseExpression();
        Class<? extends CompiledItemMappingFunction> itemMappingFunction = compiler.getCompiledClass(expression);
        if (itemMappingFunction == null) {
            itemMappingFunction = this.generateMappingFunction(compiler, functionCoercer);
            compiler.setCompiledClass(expression, itemMappingFunction);
        }
        ga.newInstance(ItemMappingIterator.class);
        ga.dup();
        compiler.compileToIterator(operand);
        ExpressionCompiler.allocateStatic(compiler, itemMappingFunction);
        ga.invokeInstanceMethod(Class.class, "newInstance", new Class[0]);
        ga.checkCast(Type.getType(CompiledItemMappingFunction.class));
        ga.push(true);
        ga.invokeConstructor(ItemMappingIterator.class, SequenceIterator.class, ItemMappingFunction.class, Boolean.TYPE);
    }

    @Override
    public void compileToItem(CompilerService compiler, Expression expression) throws CannotCompileException {
        Generator ga = compiler.getCurrentGenerator();
        GeneratedMethodInfo mi = compiler.getCurrentMethod();
        LabelInfo end = mi.newLabel("endCoercer");
        FunctionSequenceCoercer functionCoercer = (FunctionSequenceCoercer)expression;
        Expression operand = functionCoercer.getBaseExpression();
        compiler.compileToItem(operand);
        ga.dup();
        ga.ifNull(end.label());
        ga.dup();
        LabelInfo isFunctionLab = mi.newLabel("isFunctionLab");
        ga.ifInstance(Function.class, isFunctionLab);
        FunctionSequenceCoercerCompiler.allocateStatic(compiler, functionCoercer.getRole());
        ga.swap();
        FunctionSequenceCoercerCompiler.allocateStatic(compiler, functionCoercer.getItemType());
        ga.swap();
        ga.invokeStaticMethod(UType.class, "getUType", Item.class);
        ga.invokeInstanceMethod(RoleDiagnostic.class, "composeErrorMessage", ItemType.class, UType.class);
        compiler.generateParameterizedDynamicError(MessageFromStack.getInstance(), "XPTY0004", expression.getLocation(), true);
        ga.goTo(end);
        mi.placeLabel(isFunctionLab);
        ga.checkClass(Function.class);
        ga.newInstance(CoercedFunction.class);
        ga.dupX1();
        ga.swap();
        FunctionSequenceCoercerCompiler.allocateStatic(compiler, functionCoercer.getItemType());
        ga.invokeConstructor(CoercedFunction.class, Function.class, SpecificFunctionType.class);
        mi.placeLabel(end);
    }

    private Class<? extends CompiledItemMappingFunction> generateMappingFunction(CompilerService compiler, Expression expression) throws CannotCompileException {
        compiler.checkMaxClassesLimit();
        ClassWriter cw = new ClassWriter(compiler.getFlags());
        ClassVisitor cv = cw;
        String className = "gen_CompiledItemMappingFunction_" + CompilerService.getUniqueNumber();
        cv = compiler.makeAnnotatedTraceClassVisitor(cv, className);
        cv.visitSource(expression.getLocation().getSystemId(), null);
        cv.visit(49, 1, className, null, "com/saxonica/ee/bytecode/map/CompiledItemMappingFunction", new String[0]);
        compiler.pushNewClassInfo(className, CompiledItemMappingFunction.class, cw);
        Method m = Method.getMethod("void <init> ()");
        Generator ga = new Generator(1, m, false, cv);
        ga.loadThis();
        ga.invokeConstructor(Type.getType(CompiledItemMappingFunction.class), m);
        ga.returnValue();
        ga.endMethod();
        m = Method.getMethod("net.sf.saxon.om.Item mapItem(net.sf.saxon.om.Item)");
        ga = new Generator(1, m, true, cv);
        int contextVar = ga.newLocal(XPathContext.class);
        compiler.pushNewMethodInfo(ga, false, contextVar);
        FunctionSequenceCoercer expr = (FunctionSequenceCoercer)expression;
        FunctionSequenceCoercerCompiler.visitLineNumber(compiler, ga, expr);
        ga.loadArg(0);
        ga.checkCast(Type.getType(Function.class));
        FunctionSequenceCoercerCompiler.allocateStatic(compiler, expr.getItemType());
        FunctionSequenceCoercerCompiler.allocateStatic(compiler, expr.getRole());
        ga.invokeStaticMethod(CoercedFunction.class, "coerce", Function.class, SpecificFunctionType.class, RoleDiagnostic.class);
        ga.returnValue();
        ga.endMethod();
        compiler.popCurrentMethodInfo();
        cv.visitEnd();
        FunctionSequenceCoercerCompiler.verify(cw, "FunctionSequenceCoercer " + expr.getLocation().getLineNumber(), compiler.isDebugByteCode());
        return compiler.makeClass(cw, className);
    }
}

