/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.functions.extfn;

import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.MalformedInputException;
import java.nio.charset.UnmappableCharacterException;
import java.util.ArrayList;
import java.util.Arrays;
import net.sf.saxon.om.One;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.om.ZeroOrMore;
import net.sf.saxon.om.ZeroOrOne;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ValidationException;
import net.sf.saxon.value.Base64BinaryValue;
import net.sf.saxon.value.BigDecimalValue;
import net.sf.saxon.value.BigIntegerValue;
import net.sf.saxon.value.DoubleValue;
import net.sf.saxon.value.FloatValue;
import net.sf.saxon.value.Int64Value;
import net.sf.saxon.value.IntegerValue;
import net.sf.saxon.value.StringValue;

public class EXPathBinary {
    public static final double VERSION = 1.0;
    public static final String NAMESPACE = "http://expath.org/ns/binary";
    public static final String PREFIX = "bin";
    public static final String ERROR_NAMESPACE = "http://expath.org/ns/binary";
    public static final String ERROR_PREFIX = "bin";
    private static final String defaultEndianness = "BE";
    private static final String ERROR_DIFFERENT_LENGTH_ARGUMENTS = "differing-length-arguments";
    private static final String ERROR_INDEX_BEFORE_START = "index-out-of-range";
    private static final String ERROR_INDEX_AFTER_END = "index-out-of-range";
    private static final String ERROR_NEGATIVE_SIZE = "negative-size";
    private static final String ERROR_EMPTY_SEARCH_ITEM = "empty-search-item";
    private static final String ERROR_OCTET_RANGE = "octet-out-of-range";
    private static final String ERROR_NON_NUMERIC_CHAR = "non-numeric-character";
    private static final String ERROR_UNKNOWN_ENCODING = "unknown-encoding";
    private static final String ERROR_CONVERSION = "conversion-error";
    private static final String ERROR_SIGNIFICANCE_ORDER = "unknown-significance-order";

    private static void error(String message, String code) throws XPathException {
        XPathException e = new XPathException(message);
        e.setErrorCodeQName(new StructuredQName("bin", "http://expath.org/ns/binary", code));
        throw e;
    }

    private static One<Base64BinaryValue> one(byte[] result) {
        return new One<Base64BinaryValue>(new Base64BinaryValue(result));
    }

    private static void checkIndex(Base64BinaryValue value, int offset, int length) throws XPathException {
        if (offset < 0) {
            EXPathBinary.error("Attempting to retrieve data before the start of a binary data type", "index-out-of-range");
        }
        int len = value.getLengthInOctets();
        if (length < 0) {
            EXPathBinary.error("Requested length of binary section is negative", ERROR_NEGATIVE_SIZE);
        }
        if (offset >= len) {
            EXPathBinary.error("Attempting to retrieve data beyond the end of a binary data type; index:" + offset + " data:" + len, "index-out-of-range");
        }
        if (offset + length > len) {
            EXPathBinary.error("Attempting to retrieve data beyond the end of a binary data type; index:" + (offset + length) + " data:" + len, "index-out-of-range");
        }
    }

    private static void checkIndexInclusive(Base64BinaryValue value, int offset, int length) throws XPathException {
        if (offset < 0) {
            EXPathBinary.error("Attempting to retrieve data before the start of a binary data type", "index-out-of-range");
        }
        int len = value.getLengthInOctets();
        if (length < 0) {
            EXPathBinary.error("Requested length of binary section is negative", ERROR_NEGATIVE_SIZE);
        }
        if (offset > len) {
            EXPathBinary.error("Attempting to retrieve data beyond the end of a binary data type; index:" + offset + " data:" + len, "index-out-of-range");
        }
        if (offset + length > len) {
            EXPathBinary.error("Attempting to retrieve data beyond the end of a binary data type; index:" + (offset + length) + " data:" + len, "index-out-of-range");
        }
    }

    private static void checkSameLength(ZeroOrOne<Base64BinaryValue> value1, ZeroOrOne<Base64BinaryValue> value2) throws XPathException {
        if (value1.head() == null || value2.head() == null) {
            return;
        }
        if (value1.head().getLengthInOctets() != value2.head().getLengthInOctets()) {
            EXPathBinary.error("The arguments to a bitwise operation are differing lengths", ERROR_DIFFERENT_LENGTH_ARGUMENTS);
        }
    }

    private static boolean endianness(One<StringValue> value) throws XPathException {
        String s = value.getStringValue();
        if (s.equalsIgnoreCase(defaultEndianness) || s.equalsIgnoreCase("most-significant-first") || s.equalsIgnoreCase("big-endian")) {
            return true;
        }
        if (s.equalsIgnoreCase("LE") || s.equalsIgnoreCase("least-significant-first") || s.equalsIgnoreCase("little-endian")) {
            return false;
        }
        EXPathBinary.error("Unrecognized octet-order request:" + s, ERROR_SIGNIFICANCE_ORDER);
        return false;
    }

    private static One<Base64BinaryValue> inputNumber(String s, int base, int bitLength) throws XPathException {
        int bits = s.length() * bitLength;
        int charsPerOctet = 8 / bitLength;
        int octetLength = (bits + 7) / 8;
        int padLength = bits % 8;
        byte[] result = new byte[octetLength];
        int offset = 0;
        int end = padLength == 0 ? charsPerOctet : padLength / bitLength;
        int b = 0;
        try {
            while (offset < s.length()) {
                result[b++] = (byte)(Integer.parseInt(s.substring(offset, end), base) & 0xFF);
                offset = end;
                end = offset + charsPerOctet;
            }
        }
        catch (NumberFormatException e) {
            EXPathBinary.error("Wrong character in base " + base + " binary constructor string:" + s, ERROR_NON_NUMERIC_CHAR);
        }
        return EXPathBinary.one(result);
    }

    public static One<BigDecimalValue> version() {
        try {
            return new One<BigDecimalValue>(new BigDecimalValue(1.0));
        }
        catch (ValidationException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static ZeroOrOne<Base64BinaryValue> hex(ZeroOrOne<StringValue> s) throws XPathException {
        if (s.head() == null) {
            return ZeroOrOne.empty();
        }
        return EXPathBinary.inputNumber(s.getStringValue(), 16, 4);
    }

    public static ZeroOrOne<Base64BinaryValue> bin(ZeroOrOne<StringValue> s) throws XPathException {
        if (s.head() == null) {
            return ZeroOrOne.empty();
        }
        return EXPathBinary.inputNumber(s.getStringValue(), 2, 1);
    }

    public static ZeroOrOne<Base64BinaryValue> octal(ZeroOrOne<StringValue> s) throws XPathException {
        if (s.head() == null) {
            return ZeroOrOne.empty();
        }
        String binary = "";
        for (char c : s.getStringValue().toCharArray()) {
            if (c < '0' || c > '7') {
                EXPathBinary.error("Wrong character in base 8 binary constructor string:" + c, ERROR_NON_NUMERIC_CHAR);
            }
            binary = binary + ((c & 4) == 0 ? "0" : "1");
            binary = binary + ((c & 2) == 0 ? "0" : "1");
            binary = binary + ((c & '\u0001') == 0 ? "0" : "1");
        }
        return EXPathBinary.inputNumber(binary, 2, 1);
    }

    public static One<IntegerValue> length(One<Base64BinaryValue> value) {
        return One.integer(((Base64BinaryValue)value.head()).getLengthInOctets());
    }

    public static ZeroOrMore<IntegerValue> toOctets(One<Base64BinaryValue> value) {
        ArrayList<Int64Value> result = new ArrayList<Int64Value>();
        for (byte b : ((Base64BinaryValue)value.head()).getBinaryValue()) {
            result.add(new Int64Value(b & 0xFF));
        }
        return new ZeroOrMore<IntegerValue>(result);
    }

    public static One<Base64BinaryValue> fromOctets(ZeroOrMore<IntegerValue> value) throws XPathException {
        if (value.head() == null) {
            return EXPathBinary.one(new byte[0]);
        }
        ArrayList<Byte> ba = new ArrayList<Byte>();
        for (IntegerValue iv : value) {
            long v = iv.longValue();
            if (0L <= v && v <= 255L) {
                ba.add((byte)v);
                continue;
            }
            EXPathBinary.error("Integer outside octet range in binary constructor:" + v, ERROR_OCTET_RANGE);
        }
        byte[] br = new byte[ba.size()];
        int i = 0;
        for (Byte b : ba) {
            br[i++] = b;
        }
        return EXPathBinary.one(br);
    }

    public static One<Base64BinaryValue> join(ZeroOrMore<Base64BinaryValue> value) throws XPathException {
        Base64BinaryValue bv;
        int len = 0;
        SequenceIterator si = value.iterate();
        while ((bv = (Base64BinaryValue)si.next()) != null) {
            len += bv.getLengthInOctets();
        }
        byte[] result = new byte[len];
        int i = 0;
        si = value.iterate();
        while ((bv = (Base64BinaryValue)si.next()) != null) {
            int lb = bv.getLengthInOctets();
            System.arraycopy(bv.getBinaryValue(), 0, result, i, lb);
            i += lb;
        }
        return EXPathBinary.one(result);
    }

    public static ZeroOrOne<Base64BinaryValue> insertBefore(ZeroOrOne<Base64BinaryValue> value, One<IntegerValue> offset, ZeroOrOne<Base64BinaryValue> extra) throws XPathException {
        if (value.head() == null) {
            return ZeroOrOne.empty();
        }
        int valLen = value.head().getLengthInOctets();
        int off = (int)((IntegerValue)offset.head()).longValue();
        if (extra.head() == null) {
            return value;
        }
        EXPathBinary.checkIndexInclusive(value.head(), off, 0);
        int extraLen = extra.head().getLengthInOctets();
        byte[] result = new byte[valLen + extraLen];
        System.arraycopy(value.head().getBinaryValue(), 0, result, 0, off);
        System.arraycopy(extra.head().getBinaryValue(), 0, result, off, extraLen);
        System.arraycopy(value.head().getBinaryValue(), off, result, off + extraLen, valLen - off);
        return EXPathBinary.one(result);
    }

    public static ZeroOrOne<Base64BinaryValue> part(ZeroOrOne<Base64BinaryValue> value, One<IntegerValue> offset) throws XPathException {
        if (value.head() == null) {
            return ZeroOrOne.empty();
        }
        int len = Math.max(0, (int)((long)value.head().getLengthInOctets() - ((IntegerValue)offset.head()).longValue()));
        return EXPathBinary.part(value, offset, One.integer(len));
    }

    public static ZeroOrOne<Base64BinaryValue> part(ZeroOrOne<Base64BinaryValue> value, One<IntegerValue> offset, One<IntegerValue> length) throws XPathException {
        if (value.head() == null) {
            return ZeroOrOne.empty();
        }
        int off = (int)((IntegerValue)offset.head()).longValue();
        int len = (int)((IntegerValue)length.head()).longValue();
        EXPathBinary.checkIndexInclusive(value.head(), off, len);
        if (off == 0 && len == value.head().getLengthInOctets()) {
            return value;
        }
        byte[] result = new byte[len];
        System.arraycopy(value.head().getBinaryValue(), off, result, 0, len);
        return EXPathBinary.one(result);
    }

    public static ZeroOrOne<IntegerValue> find(ZeroOrOne<Base64BinaryValue> value, One<Base64BinaryValue> search) throws XPathException {
        return EXPathBinary.find(value, One.integer(0L), search);
    }

    public static ZeroOrOne<IntegerValue> find(ZeroOrOne<Base64BinaryValue> value, One<IntegerValue> offset, One<Base64BinaryValue> search) throws XPathException {
        if (value.head() == null) {
            return ZeroOrOne.empty();
        }
        byte[] in = value.head().getBinaryValue();
        int off = (int)((IntegerValue)offset.head()).longValue();
        if (((Base64BinaryValue)search.head()).getLengthInOctets() == 0) {
            return offset;
        }
        EXPathBinary.checkIndex(value.head(), off, 0);
        byte[] s = ((Base64BinaryValue)search.head()).getBinaryValue();
        int i = EXPathBinary.find(in, s, off);
        if (i == -1) {
            return ZeroOrOne.empty();
        }
        return One.integer(i);
    }

    private static int find(byte[] data, byte[] pattern, int offset) {
        int[] failure = EXPathBinary.computeFailure(pattern);
        int j = 0;
        if (data.length == 0) {
            return -1;
        }
        for (int i = offset; i < data.length; ++i) {
            while (j > 0 && pattern[j] != data[i]) {
                j = failure[j - 1];
            }
            if (pattern[j] == data[i]) {
                ++j;
            }
            if (j != pattern.length) continue;
            return i - pattern.length + 1;
        }
        return -1;
    }

    private static int[] computeFailure(byte[] pattern) {
        int[] failure = new int[pattern.length];
        int j = 0;
        for (int i = 1; i < pattern.length; ++i) {
            while (j > 0 && pattern[j] != pattern[i]) {
                j = failure[j - 1];
            }
            if (pattern[j] == pattern[i]) {
                // empty if block
            }
            failure[i] = ++j;
        }
        return failure;
    }

    private static void checkEncoding(One<StringValue> encoding) throws XPathException {
        String se = encoding.getStringValue().toUpperCase();
        if (se.equals("UTF-8") || se.equals("UTF-16") || se.equals("US-ASCII") || se.equals("ASCII") || se.equals("ISO-8859-1")) {
            return;
        }
        EXPathBinary.error("Unsupported encoding in binary encode/decode:" + encoding.getStringValue(), ERROR_UNKNOWN_ENCODING);
    }

    public static ZeroOrOne<StringValue> decodeString(ZeroOrOne<Base64BinaryValue> value) throws XPathException, UnsupportedEncodingException {
        return EXPathBinary.decodeString(value, One.string("UTF-8"), One.integer(0L));
    }

    public static ZeroOrOne<StringValue> decodeString(ZeroOrOne<Base64BinaryValue> value, One<StringValue> encoding) throws XPathException, UnsupportedEncodingException {
        return EXPathBinary.decodeString(value, encoding, One.integer(0L));
    }

    public static ZeroOrOne<StringValue> decodeString(ZeroOrOne<Base64BinaryValue> value, One<StringValue> encoding, One<IntegerValue> offset) throws UnsupportedEncodingException, XPathException {
        if (value.head() == null) {
            return ZeroOrOne.empty();
        }
        int len = (int)((long)value.head().getLengthInOctets() - ((IntegerValue)offset.head()).longValue());
        return EXPathBinary.decodeString(value, encoding, offset, One.integer(len));
    }

    public static ZeroOrOne<StringValue> decodeString(ZeroOrOne<Base64BinaryValue> value, One<StringValue> encoding, One<IntegerValue> offset, One<IntegerValue> size) throws UnsupportedEncodingException, XPathException {
        if (value.head() == null) {
            return ZeroOrOne.empty();
        }
        EXPathBinary.checkEncoding(encoding);
        int off = (int)((IntegerValue)offset.head()).longValue();
        int len = (int)((IntegerValue)size.head()).longValue();
        EXPathBinary.checkIndexInclusive(value.head(), off, len);
        if (len == 0) {
            return One.string("");
        }
        CharsetDecoder decoder = Charset.forName(encoding.getStringValue()).newDecoder();
        decoder.onMalformedInput(CodingErrorAction.REPORT);
        ByteBuffer in = ByteBuffer.wrap(value.head().getBinaryValue(), off, len);
        char[] outChars = new char[len];
        CharBuffer out = CharBuffer.wrap(outChars);
        CoderResult res = decoder.decode(in, out, true);
        if (res.isError()) {
            if (res.isMalformed()) {
                EXPathBinary.error("Malformed input in decoding", ERROR_CONVERSION);
            }
            if (res.isUnmappable()) {
                EXPathBinary.error("Unmappable input in decoding", ERROR_CONVERSION);
            }
            EXPathBinary.error("Other error in decoding", ERROR_CONVERSION);
        }
        char[] resChars = new char[out.position()];
        System.arraycopy(outChars, 0, resChars, 0, out.position());
        return One.string(new String(resChars));
    }

    public static ZeroOrOne<Base64BinaryValue> encodeString(ZeroOrOne<StringValue> value) throws XPathException, UnsupportedEncodingException {
        return EXPathBinary.encodeString(value, One.string("UTF-8"));
    }

    public static ZeroOrOne<Base64BinaryValue> encodeString(ZeroOrOne<StringValue> value, One<StringValue> encoding) throws XPathException, UnsupportedEncodingException {
        if (value.head() == null) {
            return ZeroOrOne.empty();
        }
        EXPathBinary.checkEncoding(encoding);
        CharsetEncoder encoder = Charset.forName(encoding.getStringValue()).newEncoder();
        encoder.onMalformedInput(CodingErrorAction.REPORT);
        String s = value.head().getStringValue();
        CharBuffer in = CharBuffer.wrap(s);
        ByteBuffer out = null;
        try {
            out = encoder.encode(in);
        }
        catch (MalformedInputException e) {
            EXPathBinary.error("Malformed input in encoding:" + e, ERROR_CONVERSION);
        }
        catch (UnmappableCharacterException e) {
            EXPathBinary.error("Unmappable input in encoding:" + e, ERROR_CONVERSION);
        }
        catch (CharacterCodingException e) {
            EXPathBinary.error("Character code problem in encoding:" + e, ERROR_CONVERSION);
        }
        byte[] data = new byte[out.limit()];
        System.arraycopy(out.array(), 0, data, 0, out.limit());
        return EXPathBinary.one(data);
    }

    private static One<Base64BinaryValue> pack(long in, int length, boolean big) {
        byte[] result = new byte[length];
        if (big) {
            while (length > 0) {
                result[--length] = (byte)(in & 0xFFL);
                in >>= 8;
            }
        } else {
            int i = 0;
            while (length-- > 0) {
                result[i++] = (byte)(in & 0xFFL);
                in >>= 8;
            }
        }
        return EXPathBinary.one(result);
    }

    private static One<Base64BinaryValue> packBytes(byte[] in, int length, boolean big) {
        return EXPathBinary.packBytes(in, length, big, false);
    }

    private static One<Base64BinaryValue> packBytes(byte[] in, int length, boolean big, boolean negative) {
        byte[] result;
        block6: {
            int len;
            block5: {
                result = new byte[length];
                len = in.length;
                if (!big) break block5;
                int i = len;
                while (length > 0 && i > 0) {
                    result[--length] = in[--i];
                }
                if (!negative) break block6;
                while (length > 0) {
                    result[--length] = -1;
                }
                break block6;
            }
            int i = 0;
            while (length-- > 0 && len > 0) {
                result[i++] = in[--len];
            }
            if (negative) {
                while (length > 0) {
                    result[i++] = -1;
                }
            }
        }
        return EXPathBinary.one(result);
    }

    private static long unpack(byte[] in, int offset, int length, boolean big) {
        long result = 0L;
        if (big) {
            while (length-- > 0) {
                result = (result << 8) + (long)(in[offset++] & 0xFF);
            }
        } else {
            int off = offset + length;
            while (length-- > 0) {
                result = (result << 8) + (long)(in[--off] & 0xFF);
            }
        }
        return result;
    }

    private static byte[] unpackBytes(byte[] in, int offset, int length, boolean big, boolean unsigned) {
        int i;
        byte[] out = new byte[length + (unsigned ? 1 : 0)];
        int n = i = unsigned ? 1 : 0;
        if (big) {
            while (length-- > 0) {
                out[i++] = in[offset++];
            }
        } else {
            int off = offset + length;
            while (length-- > 0) {
                out[i++] = in[--off];
            }
        }
        return out;
    }

    public static One<DoubleValue> unpackDouble(One<Base64BinaryValue> value, One<IntegerValue> offset) throws XPathException {
        return EXPathBinary.unpackDouble(value, offset, One.string(defaultEndianness));
    }

    public static One<DoubleValue> unpackDouble(One<Base64BinaryValue> value, One<IntegerValue> offset, One<StringValue> endian) throws XPathException {
        int off = (int)((IntegerValue)offset.head()).longValue();
        byte[] in = ((Base64BinaryValue)value.head()).getBinaryValue();
        int len = 8;
        EXPathBinary.checkIndex((Base64BinaryValue)value.head(), off, len);
        long bits = EXPathBinary.unpack(in, off, len, EXPathBinary.endianness(endian));
        Double d = Double.longBitsToDouble(bits);
        return new One<DoubleValue>(new DoubleValue(d.isNaN() ? Double.NaN : d));
    }

    public static One<FloatValue> unpackFloat(One<Base64BinaryValue> value, One<IntegerValue> offset) throws XPathException {
        return EXPathBinary.unpackFloat(value, offset, One.string(defaultEndianness));
    }

    public static One<FloatValue> unpackFloat(One<Base64BinaryValue> value, One<IntegerValue> offset, One<StringValue> endian) throws XPathException {
        int off = (int)((IntegerValue)offset.head()).longValue();
        byte[] in = ((Base64BinaryValue)value.head()).getBinaryValue();
        int len = 4;
        EXPathBinary.checkIndex((Base64BinaryValue)value.head(), off, len);
        long bits = EXPathBinary.unpack(in, off, len, EXPathBinary.endianness(endian));
        Float f = Float.valueOf(Float.intBitsToFloat((int)bits));
        return new One<FloatValue>(new FloatValue(f.isNaN() ? Float.NaN : f.floatValue()));
    }

    public static One<IntegerValue> unpackUnsignedInteger(One<Base64BinaryValue> value, One<IntegerValue> offset, One<IntegerValue> length) throws XPathException {
        return EXPathBinary.unpackUnsignedInteger(value, offset, length, One.string(defaultEndianness));
    }

    public static One<IntegerValue> unpackUnsignedInteger(One<Base64BinaryValue> value, One<IntegerValue> offset, One<IntegerValue> length, One<StringValue> endian) throws XPathException {
        boolean bigEnd = EXPathBinary.endianness(endian);
        int off = (int)((IntegerValue)offset.head()).longValue();
        int len = (int)((IntegerValue)length.head()).longValue();
        byte[] in = ((Base64BinaryValue)value.head()).getBinaryValue();
        EXPathBinary.checkIndex((Base64BinaryValue)value.head(), off, len);
        if (len == 0) {
            return One.integer(0L);
        }
        if (len > 7) {
            BigInteger big = new BigInteger(EXPathBinary.unpackBytes(in, off, len, bigEnd, true));
            return new One<IntegerValue>(new BigIntegerValue(big));
        }
        long result = EXPathBinary.unpack(in, off, len, bigEnd);
        return One.integer(result);
    }

    public static One<IntegerValue> unpackInteger(One<Base64BinaryValue> value, One<IntegerValue> offset, One<IntegerValue> length) throws XPathException {
        return EXPathBinary.unpackInteger(value, offset, length, One.string(defaultEndianness));
    }

    public static One<IntegerValue> unpackInteger(One<Base64BinaryValue> value, One<IntegerValue> offset, One<IntegerValue> length, One<StringValue> endian) throws XPathException {
        boolean negative;
        boolean bigEnd = EXPathBinary.endianness(endian);
        int off = (int)((IntegerValue)offset.head()).longValue();
        int len = (int)((IntegerValue)length.head()).longValue();
        byte[] in = ((Base64BinaryValue)value.head()).getBinaryValue();
        EXPathBinary.checkIndex((Base64BinaryValue)value.head(), off, len);
        if (len == 0) {
            return One.integer(0L);
        }
        boolean bl = negative = (in[off] & 0x80) != 0;
        if (len > 7) {
            BigInteger big = new BigInteger(EXPathBinary.unpackBytes(in, off, len, bigEnd, false));
            return new One<IntegerValue>(new BigIntegerValue(big));
        }
        long signExt = negative ? (1L << 8 * len) - 1L ^ 0xFFFFFFFFFFFFFFFFL : 0L;
        long result = EXPathBinary.unpack(in, off, len, bigEnd);
        return One.integer(result | signExt);
    }

    public static One<Base64BinaryValue> packDouble(One<DoubleValue> value) throws XPathException {
        return EXPathBinary.packDouble(value, One.string(defaultEndianness));
    }

    public static One<Base64BinaryValue> packDouble(One<DoubleValue> value, One<StringValue> endian) throws XPathException {
        return EXPathBinary.pack(Double.doubleToRawLongBits(((DoubleValue)value.head()).getDoubleValue()), 8, EXPathBinary.endianness(endian));
    }

    public static One<Base64BinaryValue> packFloat(One<FloatValue> value) throws XPathException {
        return EXPathBinary.packFloat(value, One.string(defaultEndianness));
    }

    public static One<Base64BinaryValue> packFloat(One<FloatValue> value, One<StringValue> endian) throws XPathException {
        return EXPathBinary.pack(Float.floatToRawIntBits(((FloatValue)value.head()).getFloatValue()), 4, EXPathBinary.endianness(endian));
    }

    public static One<Base64BinaryValue> packInteger(One<IntegerValue> value, One<IntegerValue> length) throws XPathException {
        return EXPathBinary.packInteger(value, length, One.string(defaultEndianness));
    }

    public static One<Base64BinaryValue> packInteger(One<IntegerValue> value, One<IntegerValue> length, One<StringValue> endian) throws XPathException {
        if (((IntegerValue)length.head()).signum() == -1) {
            EXPathBinary.error("Requested length of integer packing is negative", ERROR_NEGATIVE_SIZE);
        }
        return EXPathBinary.packBytes(((IntegerValue)value.head()).asBigInteger().toByteArray(), (int)((IntegerValue)length.head()).longValue(), EXPathBinary.endianness(endian), ((IntegerValue)value.head()).asBigInteger().signum() == -1);
    }

    public static ZeroOrOne<Base64BinaryValue> padLeft(ZeroOrOne<Base64BinaryValue> value, IntegerValue size) throws XPathException {
        return EXPathBinary.padLeft(value, size, Int64Value.ZERO);
    }

    public static ZeroOrOne<Base64BinaryValue> padLeft(ZeroOrOne<Base64BinaryValue> value, IntegerValue sizeIV, IntegerValue octet) throws XPathException {
        if (value.head() == null) {
            return ZeroOrOne.empty();
        }
        int size = (int)sizeIV.longValue();
        int oct = (int)octet.longValue();
        if (size < 0) {
            EXPathBinary.error("Pad size is negative", ERROR_NEGATIVE_SIZE);
            return null;
        }
        if (oct < 0 || 255 < oct) {
            EXPathBinary.error("Integer outside octet range in padding:" + oct, ERROR_OCTET_RANGE);
            return null;
        }
        if (size == 0) {
            return value;
        }
        int len = value.head().getLengthInOctets();
        byte[] in = value.head().getBinaryValue();
        byte[] result = new byte[len + size];
        if (oct != 0) {
            Arrays.fill(result, 0, size, (byte)oct);
        }
        System.arraycopy(in, 0, result, size, len);
        return EXPathBinary.one(result);
    }

    public static ZeroOrOne<Base64BinaryValue> padRight(ZeroOrOne<Base64BinaryValue> value, One<IntegerValue> size) throws XPathException {
        return EXPathBinary.padRight(value, size, One.integer(0L));
    }

    public static ZeroOrOne<Base64BinaryValue> padRight(ZeroOrOne<Base64BinaryValue> value, One<IntegerValue> sizeIV, One<IntegerValue> octet) throws XPathException {
        if (value.head() == null) {
            return ZeroOrOne.empty();
        }
        int size = (int)((IntegerValue)sizeIV.head()).longValue();
        int oct = (int)((IntegerValue)octet.head()).longValue();
        if (size < 0) {
            EXPathBinary.error("Pad size is negative", ERROR_NEGATIVE_SIZE);
            return null;
        }
        if (oct < 0 || 255 < oct) {
            EXPathBinary.error("Integer outside octet range in padding:" + oct, ERROR_OCTET_RANGE);
            return null;
        }
        if (size == 0) {
            return value;
        }
        int len = value.head().getLengthInOctets();
        byte[] in = value.head().getBinaryValue();
        byte[] result = new byte[len + size];
        System.arraycopy(in, 0, result, 0, len);
        if (oct != 0) {
            Arrays.fill(result, len, len + size, (byte)oct);
        }
        return EXPathBinary.one(result);
    }

    public static ZeroOrOne<Base64BinaryValue> shift(ZeroOrOne<Base64BinaryValue> value, One<IntegerValue> bitsIV) throws XPathException {
        if (value.head() == null) {
            return ZeroOrOne.empty();
        }
        int bits = (int)((IntegerValue)bitsIV.head()).longValue();
        if (bits == 0) {
            return value;
        }
        int len = value.head().getLengthInOctets();
        byte[] in = value.head().getBinaryValue();
        byte[] result = new byte[len];
        int shift = Math.abs(bits);
        int byteShift = shift / 8;
        int bitShift = shift % 8;
        int i = 0;
        int offset = 0;
        byte part = 0;
        if (bits > 0) {
            int partShift = 8 - bitShift;
            if (bitShift == 0) {
                while (offset < len) {
                    result[i++] = in[offset++];
                }
            } else {
                for (offset = byteShift; offset < len; ++offset) {
                    part = (byte)(offset == len - 1 ? 0 : in[offset + 1] >>> partShift);
                    result[i] = (byte)(in[offset] << bitShift | part);
                    ++i;
                }
            }
        } else {
            i = byteShift;
            int partShift = 8 - bitShift;
            while (i < len) {
                result[i] = (byte)((in[offset] & 0xFF) >>> bitShift | part);
                part = (byte)((in[offset] & 0xFF) << partShift);
                ++i;
                ++offset;
            }
        }
        return EXPathBinary.one(result);
    }

    public static ZeroOrOne<Base64BinaryValue> not(ZeroOrOne<Base64BinaryValue> value) {
        if (value.head() == null) {
            return ZeroOrOne.empty();
        }
        int len = value.head().getLengthInOctets();
        byte[] in = value.head().getBinaryValue();
        byte[] result = new byte[len];
        int i = 0;
        while (i < len) {
            result[i] = ~in[i++];
        }
        return EXPathBinary.one(result);
    }

    public static ZeroOrOne<Base64BinaryValue> or(ZeroOrOne<Base64BinaryValue> value1, ZeroOrOne<Base64BinaryValue> value2) throws XPathException {
        EXPathBinary.checkSameLength(value1, value2);
        if (value1.head() == null || value2.head() == null) {
            return ZeroOrOne.empty();
        }
        int len = value1.head().getLengthInOctets();
        byte[] in1 = value1.head().getBinaryValue();
        byte[] in2 = value2.head().getBinaryValue();
        byte[] result = new byte[len];
        for (int i = 0; i < len; ++i) {
            result[i] = (byte)(in1[i] | in2[i]);
        }
        return EXPathBinary.one(result);
    }

    public static ZeroOrOne<Base64BinaryValue> and(ZeroOrOne<Base64BinaryValue> value1, ZeroOrOne<Base64BinaryValue> value2) throws XPathException {
        EXPathBinary.checkSameLength(value1, value2);
        if (value1.head() == null || value2.head() == null) {
            return ZeroOrOne.empty();
        }
        int len = value1.head().getLengthInOctets();
        byte[] in1 = value1.head().getBinaryValue();
        byte[] in2 = value2.head().getBinaryValue();
        byte[] result = new byte[len];
        for (int i = 0; i < len; ++i) {
            result[i] = (byte)(in1[i] & in2[i]);
        }
        return EXPathBinary.one(result);
    }

    public static ZeroOrOne<Base64BinaryValue> xor(ZeroOrOne<Base64BinaryValue> value1, ZeroOrOne<Base64BinaryValue> value2) throws XPathException {
        EXPathBinary.checkSameLength(value1, value2);
        if (value1.head() == null || value2.head() == null) {
            return ZeroOrOne.empty();
        }
        int len = value1.head().getLengthInOctets();
        byte[] in1 = value1.head().getBinaryValue();
        byte[] in2 = value2.head().getBinaryValue();
        byte[] result = new byte[len];
        for (int i = 0; i < len; ++i) {
            result[i] = (byte)(in1[i] ^ in2[i]);
        }
        return EXPathBinary.one(result);
    }
}

