/*
 * Decompiled with CFR 0.152.
 */
package marmot.thirdparty.aramorph;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import marmot.thirdparty.aramorph.DictionaryEntry;

class DictionaryHandler {
    private Map<String, List<DictionaryEntry>> prefixes = this.loadDictionary("dictPrefixes", this.getClass().getResourceAsStream("dictionaries/dictPrefixes"));
    private Map<String, List<DictionaryEntry>> stems = this.loadDictionary("dictStems", this.getClass().getResourceAsStream("dictionaries/dictStems"));
    private Map<String, List<DictionaryEntry>> suffixes = this.loadDictionary("dictSuffixes", this.getClass().getResourceAsStream("dictionaries/dictSuffixes"));
    private Set<String> hash_AB = this.loadCompatibilityTable("tableAB", this.getClass().getResourceAsStream("dictionaries/tableAB"));
    private Set<String> hash_AC = this.loadCompatibilityTable("tableAC", this.getClass().getResourceAsStream("dictionaries/tableAC"));
    private Set<String> hash_BC = this.loadCompatibilityTable("tableBC", this.getClass().getResourceAsStream("dictionaries/tableBC"));

    protected Collection<DictionaryEntry> getPrefixIterator(String translitered) {
        return this.prefixes.get(translitered);
    }

    protected Collection<DictionaryEntry> getStemIterator(String translitered) {
        return this.stems.get(translitered);
    }

    protected Collection<DictionaryEntry> getSuffixIterator(String translitered) {
        return this.suffixes.get(translitered);
    }

    protected boolean hasAB(String A2, String B) {
        return this.hash_AB.contains(A2 + " " + B);
    }

    protected boolean hasAC(String A2, String C2) {
        return this.hash_AC.contains(A2 + " " + C2);
    }

    protected boolean hasBC(String B, String C2) {
        return this.hash_BC.contains(B + " " + C2);
    }

    private Map<String, List<DictionaryEntry>> loadDictionary(String name, InputStream is) throws RuntimeException {
        HashMap<String, List<DictionaryEntry>> set = new HashMap<String, List<DictionaryEntry>>();
        HashSet<String> lemmas = new HashSet<String>();
        String lemmaID = "";
        try {
            LineNumberReader IN = new LineNumberReader(new InputStreamReader(is, "ISO8859_1"));
            String line = null;
            while ((line = IN.readLine()) != null) {
                String gloss;
                Object POS;
                if (line.startsWith(";; ")) {
                    lemmaID = line.substring(3);
                    if (lemmas.contains(lemmaID)) {
                        throw new RuntimeException("Lemma " + lemmaID + "in " + name + " (line " + IN.getLineNumber() + ") isn't unique");
                    }
                    lemmas.add(lemmaID);
                    continue;
                }
                if (line.startsWith(";")) continue;
                String[] split = line.split("\t", -1);
                if (split.length != 4) {
                    throw new RuntimeException("Entry in " + name + " (line " + IN.getLineNumber() + ") doesn't have 4 fields (3 tabs)");
                }
                String entry = split[0];
                String vocalization = split[1];
                String morphology = split[2];
                String glossPOS = split[3];
                Pattern p = Pattern.compile(".*<pos>(.+?)</pos>.*");
                Matcher m4 = p.matcher(glossPOS);
                if (m4.matches()) {
                    POS = m4.group(1);
                    gloss = glossPOS;
                } else {
                    gloss = glossPOS;
                    if (morphology.matches("^(Pref-0|Suff-0)$")) {
                        POS = "";
                    } else if (morphology.matches("^F.*")) {
                        POS = vocalization + "/FUNC_WORD";
                    } else if (morphology.matches("^IV.*")) {
                        POS = vocalization + "/VERB_IMPERFECT";
                    } else if (morphology.matches("^PV.*")) {
                        POS = vocalization + "/VERB_PERFECT";
                    } else if (morphology.matches("^CV.*")) {
                        POS = vocalization + "/VERB_IMPERATIVE";
                    } else if (morphology.matches("^N.*")) {
                        POS = gloss.matches("^[A-Z].*") ? vocalization + "/NOUN_PROP" : (vocalization.matches(".*iy~$") ? vocalization + "/NOUN" : vocalization + "/NOUN");
                    } else {
                        throw new RuntimeException("No POS can be deduced in " + name + " (line " + IN.getLineNumber() + ")");
                    }
                }
                gloss = gloss.replaceFirst("<pos>.+?</pos>", "");
                gloss = gloss.trim();
                gloss = gloss.replaceAll(";", "/");
                gloss = gloss.replaceAll("\ufffd", "A");
                gloss = gloss.replaceAll("\ufffd", "A");
                gloss = gloss.replaceAll("\ufffd", "A");
                gloss = gloss.replaceAll("\ufffd", "A");
                gloss = gloss.replaceAll("\ufffd", "A");
                gloss = gloss.replaceAll("\ufffd", "A");
                gloss = gloss.replaceAll("\ufffd", "C");
                gloss = gloss.replaceAll("\ufffd", "E");
                gloss = gloss.replaceAll("\ufffd", "E");
                gloss = gloss.replaceAll("\ufffd", "E");
                gloss = gloss.replaceAll("\ufffd", "E");
                gloss = gloss.replaceAll("\ufffd", "I");
                gloss = gloss.replaceAll("\ufffd", "I");
                gloss = gloss.replaceAll("\ufffd", "I");
                gloss = gloss.replaceAll("\ufffd", "I");
                gloss = gloss.replaceAll("\ufffd", "N");
                gloss = gloss.replaceAll("\ufffd", "O");
                gloss = gloss.replaceAll("\ufffd", "O");
                gloss = gloss.replaceAll("\ufffd", "O");
                gloss = gloss.replaceAll("\ufffd", "O");
                gloss = gloss.replaceAll("\ufffd", "O");
                gloss = gloss.replaceAll("\ufffd", "U");
                gloss = gloss.replaceAll("\ufffd", "U");
                gloss = gloss.replaceAll("\ufffd", "U");
                gloss = gloss.replaceAll("\ufffd", "U");
                gloss = gloss.replaceAll("\ufffd", "a");
                gloss = gloss.replaceAll("\ufffd", "a");
                gloss = gloss.replaceAll("\ufffd", "a");
                gloss = gloss.replaceAll("\ufffd", "a");
                gloss = gloss.replaceAll("\ufffd", "a");
                gloss = gloss.replaceAll("\ufffd", "a");
                gloss = gloss.replaceAll("\ufffd", "c");
                gloss = gloss.replaceAll("\ufffd", "e");
                gloss = gloss.replaceAll("\ufffd", "e");
                gloss = gloss.replaceAll("\ufffd", "e");
                gloss = gloss.replaceAll("\ufffd", "e");
                gloss = gloss.replaceAll("\ufffd", "i");
                gloss = gloss.replaceAll("\ufffd", "i");
                gloss = gloss.replaceAll("\ufffd", "i");
                gloss = gloss.replaceAll("\ufffd", "i");
                gloss = gloss.replaceAll("\ufffd", "n");
                gloss = gloss.replaceAll("\ufffd", "o");
                gloss = gloss.replaceAll("\ufffd", "o");
                gloss = gloss.replaceAll("\ufffd", "o");
                gloss = gloss.replaceAll("\ufffd", "o");
                gloss = gloss.replaceAll("\ufffd", "o");
                gloss = gloss.replaceAll("\ufffd", "u");
                gloss = gloss.replaceAll("\ufffd", "u");
                gloss = gloss.replaceAll("\ufffd", "u");
                gloss = gloss.replaceAll("\ufffd", "u");
                gloss = gloss.replaceAll("\ufffd", "AE");
                gloss = gloss.replaceAll("\ufffd", "Sh");
                gloss = gloss.replaceAll("\ufffd", "Zh");
                gloss = gloss.replaceAll("\ufffd", "ss");
                gloss = gloss.replaceAll("\ufffd", "ae");
                gloss = gloss.replaceAll("\ufffd", "sh");
                gloss = gloss.replaceAll("\ufffd", "zh");
                DictionaryEntry de = new DictionaryEntry(entry, lemmaID, vocalization, morphology, gloss, (String)POS);
                List list = set.computeIfAbsent(entry, k -> new LinkedList());
                list.add(de);
            }
            IN.close();
        }
        catch (IOException e) {
            throw new RuntimeException("Can not open : " + name);
        }
        return set;
    }

    private Set<String> loadCompatibilityTable(String name, InputStream is) throws RuntimeException {
        HashSet<String> set = new HashSet<String>();
        try {
            LineNumberReader IN = new LineNumberReader(new InputStreamReader(is, "ISO8859_1"));
            String line = null;
            while ((line = IN.readLine()) != null) {
                if (line.startsWith(";")) continue;
                line = line.trim();
                line = line.replaceAll("\\s+", " ");
                set.add(line);
            }
            IN.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return set;
    }
}

