/*
 * Decompiled with CFR 0.152.
 */
package de.ids_mannheim.korap.util;

import java.time.LocalDate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class KrillDate {
    public int year = 0;
    public int month = 0;
    public int day = 0;
    private static final Pattern datePattern = Pattern.compile("\\s*(\\d\\d\\d\\d)(?:\\s*[-/]?\\s*(\\d\\d)(?:\\s*[-/]?\\s*(\\d\\d))?)?\\s*");
    public static final int BEGINNING = 0;
    public static final int END = 99999999;

    public KrillDate() {
    }

    public KrillDate(String date) {
        if (date == null || date.isEmpty()) {
            return;
        }
        Matcher m = datePattern.matcher(date);
        if (m.matches()) {
            this.year = Integer.parseInt(m.group(1));
            if (m.group(2) != null) {
                this.month = Integer.parseInt(m.group(2));
            }
            if (m.group(3) != null) {
                this.day = Integer.parseInt(m.group(3));
            }
        }
    }

    public KrillDate(LocalDate date) {
        if (date == null) {
            return;
        }
        this.year = date.getYear();
        this.month = date.getMonthValue();
        this.day = date.getDayOfMonth();
    }

    public int ceil() {
        return KrillDate.ceil((byte)4, this.year) * 10000 + KrillDate.ceil((byte)2, this.month) * 100 + KrillDate.ceil((byte)2, this.day);
    }

    public int floor() {
        int floor = 0;
        if (this.year == 0) {
            return 0;
        }
        floor = this.year * 10000;
        if (this.month == 0) {
            return floor;
        }
        floor += this.month * 100;
        if (this.day == 0) {
            return floor;
        }
        return floor + this.day;
    }

    public String toString() {
        StringBuilder sb = this.toStringBuilder();
        if (sb.length() < 4) {
            return null;
        }
        if (sb.length() < 8) {
            sb.append("00");
            if (sb.length() < 8) {
                sb.append("00");
            }
        }
        return sb.toString();
    }

    public int toInteger() throws NumberFormatException {
        return Integer.parseInt(this.toString());
    }

    public String toCeilString() {
        StringBuilder sb = new StringBuilder();
        return sb.append(this.ceil()).toString();
    }

    public String toFloorString() {
        StringBuilder sb = new StringBuilder();
        return sb.append(this.floor()).toString();
    }

    public String toDisplay() {
        StringBuilder sb = this.toStringBuilder();
        if (sb.length() == 8) {
            sb.insert(6, '-');
        }
        if (sb.length() > 4) {
            sb.insert(4, '-');
        }
        return sb.toString();
    }

    private StringBuilder toStringBuilder() {
        StringBuilder sb = new StringBuilder();
        if (this.year != 0) {
            if (this.year < 100) {
                sb.append("20");
            }
            sb.append(this.year);
            if (this.month != 0) {
                if (this.month < 10) {
                    sb.append('0');
                }
                sb.append(this.month);
                if (this.day != 0) {
                    if (this.day < 10) {
                        sb.append('0');
                    }
                    sb.append(this.day);
                }
            }
        }
        return sb;
    }

    private static int ceil(byte padding, int nr) {
        if (nr == 0) {
            if (padding == 4) {
                return 9999;
            }
            if (padding == 2) {
                return 99;
            }
        }
        return nr;
    }
}

