/*
 * Decompiled with CFR 0.152.
 */
package de.ids_mannheim.korap.query.spans;

import de.ids_mannheim.korap.query.SpanDistanceQuery;
import de.ids_mannheim.korap.query.spans.CandidateSpan;
import de.ids_mannheim.korap.query.spans.UnorderedDistanceSpans;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermContext;
import org.apache.lucene.search.spans.Spans;
import org.apache.lucene.util.Bits;

public class UnorderedTokenDistanceSpans
extends UnorderedDistanceSpans {
    public UnorderedTokenDistanceSpans(SpanDistanceQuery query, LeafReaderContext context, Bits acceptDocs, Map<Term, TermContext> termContexts) throws IOException {
        super(query, context, acceptDocs, termContexts);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected boolean prepareLists() throws IOException {
        if (this.firstSpanList.isEmpty() && this.secondSpanList.isEmpty()) {
            if (this.hasMoreFirstSpans && this.hasMoreSecondSpans && this.ensureSameDoc(this.firstSpans, this.secondSpans)) {
                this.firstSpanList.add(new CandidateSpan(this.firstSpans));
                this.secondSpanList.add(new CandidateSpan(this.secondSpans));
                this.currentDocNum = this.firstSpans.doc();
                this.hasMoreFirstSpans = this.firstSpans.next();
                this.hasMoreSecondSpans = this.secondSpans.next();
                return true;
            }
            this.hasMoreSpans = false;
            return false;
        }
        if (this.firstSpanList.isEmpty() && this.hasMoreFirstSpans && this.firstSpans.doc() == this.currentDocNum) {
            this.firstSpanList.add(new CandidateSpan(this.firstSpans));
            this.hasMoreFirstSpans = this.firstSpans.next();
            return true;
        }
        if (!this.secondSpanList.isEmpty()) return true;
        if (!this.hasMoreSecondSpans) return true;
        if (this.secondSpans.doc() != this.currentDocNum) return true;
        this.secondSpanList.add(new CandidateSpan(this.secondSpans));
        this.hasMoreSecondSpans = this.secondSpans.next();
        return true;
    }

    @Override
    protected boolean setCandidateList(List<CandidateSpan> candidateList, Spans candidate, boolean hasMoreCandidates, List<CandidateSpan> targetList) throws IOException {
        if (!targetList.isEmpty()) {
            CandidateSpan target = targetList.get(0);
            while (hasMoreCandidates && candidate.doc() == target.getDoc() && this.isWithinMaxDistance(target, candidate)) {
                candidateList.add(new CandidateSpan(candidate));
                hasMoreCandidates = candidate.next();
            }
        }
        return hasMoreCandidates;
    }

    protected boolean isWithinMaxDistance(CandidateSpan target, Spans candidate) {
        if (candidate.end() < target.getStart() && candidate.end() + this.maxDistance <= target.getStart()) {
            return false;
        }
        return candidate.start() <= target.getEnd() || target.getEnd() + this.maxDistance > candidate.start();
    }

    @Override
    protected List<CandidateSpan> findMatches(CandidateSpan target, List<CandidateSpan> candidateList, boolean isTargetFirstSpan) {
        ArrayList<CandidateSpan> matches = new ArrayList<CandidateSpan>();
        for (CandidateSpan cs : candidateList) {
            CandidateSpan match;
            if (this.minDistance == 0 && target.getStart() < cs.getEnd() && cs.getStart() < target.getEnd()) {
                match = this.createMatchCandidate(target, cs, true, isTargetFirstSpan);
                matches.add(match);
                continue;
            }
            int actualDistance = cs.getEnd() < target.getStart() ? target.getStart() - cs.getEnd() + 1 : cs.getStart() - target.getEnd() + 1;
            if (this.minDistance > actualDistance || actualDistance > this.maxDistance) continue;
            match = this.createMatchCandidate(target, cs, false, isTargetFirstSpan);
            matches.add(match);
        }
        return matches;
    }

    @Override
    protected void updateList(List<CandidateSpan> candidateList) {
        candidateList.remove(0);
    }
}

