/*
 * Decompiled with CFR 0.152.
 */
package marmot.morph.mapper.czech;

import marmot.morph.mapper.MorphTag;

public class MsdTag
implements MorphTag {
    public Pos pos_;
    public Type type_;
    public Tense tense_;
    public Person person_;
    public Number number_;
    public Mood mood_;
    public Gender gender_;
    public Voice voice_;
    public Degree degree_;
    public Case case_;

    public MsdTag() {
        this.reset();
    }

    void reset() {
        this.pos_ = Pos._x;
        this.type_ = Type._x;
        this.mood_ = Mood._x;
        this.tense_ = Tense._x;
        this.person_ = Person._x;
        this.number_ = Number._x;
        this.gender_ = Gender._x;
        this.voice_ = Voice._x;
        this.degree_ = Degree._x;
        this.case_ = Case._x;
    }

    @Override
    public String toHumanMorphString() {
        StringBuilder sb = new StringBuilder();
        this.addFeature(sb, "ten", this.tense_ == Tense._x, this.tense_.toString());
        this.addFeature(sb, "per", this.person_ == Person._x, this.person_.toString());
        this.addFeature(sb, "num", this.number_ == Number._x, this.number_.toString());
        this.addFeature(sb, "gen", this.gender_ == Gender._x, this.gender_.toString());
        this.addFeature(sb, "voc", this.voice_ == Voice._x, this.voice_.toString());
        this.addFeature(sb, "deg", this.degree_ == Degree._x, this.degree_.toString());
        this.addFeature(sb, "cas", this.case_ == Case._x, this.case_.toString());
        if (sb.length() == 0) {
            return "_";
        }
        return sb.toString();
    }

    private void addFeature(StringBuilder sb, String category, boolean b, String value) {
        if (!b) {
            if (sb.length() > 0) {
                sb.append('|');
            }
            sb.append(category);
            sb.append('=');
            sb.append(value);
        }
    }

    public String toHumanString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.toPosString());
        String morph = this.toHumanMorphString();
        if (!morph.equals("_")) {
            sb.append('|');
            sb.append(morph);
        }
        return sb.toString();
    }

    @Override
    public String toPosString() {
        return this.pos_.toString();
    }

    static enum Pos {
        v,
        a,
        c,
        n,
        m,
        s,
        r,
        q,
        p,
        x,
        y,
        i,
        z,
        _x;

    }

    static enum Type {
        m,
        a,
        o,
        c,
        f,
        s,
        p,
        g,
        d,
        i,
        q,
        r,
        x,
        z,
        _x;

    }

    static enum Mood {
        i,
        m,
        c,
        n,
        p,
        t,
        _x;

    }

    static enum Tense {
        p,
        f,
        s,
        _x;

    }

    static enum Person {
        fst,
        snd,
        thd,
        _x;

    }

    static enum Number {
        s,
        p,
        d,
        _x;

    }

    static enum Gender {
        m,
        f,
        n,
        _x;

    }

    static enum Voice {
        a,
        p,
        _x;

    }

    static enum Degree {
        p,
        c,
        s,
        _x;

    }

    static enum Case {
        n,
        g,
        d,
        a,
        v,
        l,
        i,
        _x;

    }
}

