/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.optim;

import com.saxonica.ee.optim.OptimizerEE;
import com.saxonica.ee.stream.StreamInstr;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.LetExpression;
import net.sf.saxon.expr.LocalBinding;
import net.sf.saxon.expr.LocalVariableReference;
import net.sf.saxon.expr.Operand;
import net.sf.saxon.expr.instruct.Block;
import net.sf.saxon.expr.instruct.LocalParam;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.type.UType;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.SequenceType;

public class CommonSubexpressionPromoter {
    private OptimizerEE optimizer;

    public CommonSubexpressionPromoter(OptimizerEE opt) {
        this.optimizer = opt;
    }

    public Expression promoteCommonSubexpressions(Expression in) {
        HashMap<Expression, List<Operand>> eligibles = new HashMap<Expression, List<Operand>>();
        this.gatherEligibles(in, eligibles);
        double topCost = 0.0;
        Expression topCandidate = null;
        for (Map.Entry<Expression, List<Operand>> entry : eligibles.entrySet()) {
            double cost;
            int count = entry.getValue().size();
            if (count <= 1 || !((cost = (double)count * entry.getKey().getCost()) > topCost)) continue;
            topCost = cost;
            topCandidate = entry.getKey();
        }
        if (topCost > 10.0) {
            List<Operand> equivalents = eligibles.get(topCandidate);
            this.optimizer.trace("Identified commmon subexpression", topCandidate);
            int cardinality = 0;
            UType itemType = UType.VOID;
            for (Operand o : equivalents) {
                Expression e = o.getChildExpression();
                cardinality = Cardinality.union(cardinality, e.getCardinality());
                itemType = itemType.union(e.getItemType().getUType());
            }
            SequenceType type = SequenceType.makeSequenceType(itemType.toItemType(), cardinality);
            LetExpression let = new LetExpression();
            let.setSequence(topCandidate);
            let.setVariableQName(new StructuredQName("vv", "http://saxon.sf.net/generated-variable", "cc" + topCandidate.hashCode()));
            let.setRequiredType(type);
            let.setNeedsLazyEvaluation(true);
            let.setEvaluationMode(Cardinality.allowsMany(topCandidate.getCardinality()) ? 4 : 13);
            for (Operand o : equivalents) {
                o.setChildExpression(new LocalVariableReference(let));
            }
            let.setAction(in);
            ExpressionTool.resetPropertiesWithinSubtree(in);
            let.rebuildReferenceList(true);
            return let;
        }
        return in;
    }

    private static boolean containsExact(List<Expression> list, Expression exp) {
        for (Expression e : list) {
            if (e != exp) continue;
            return true;
        }
        return false;
    }

    private void gatherEligibles(Expression in, Map<Expression, List<Operand>> eligibles) {
        if (in.getCost() < 2.0) {
            return;
        }
        if (!(in instanceof StreamInstr) && in.isLiftable(false)) {
            if (!in.allowExtractingCommonSubexpressions() || in instanceof LocalBinding || CommonSubexpressionPromoter.isBlockWithLocalParams(in)) {
                this.processChildren(in);
            } else {
                for (Operand o : in.operands()) {
                    Expression child = o.getChildExpression();
                    if (o.hasSameFocus() && !o.getOperandRole().isConstrainedClass()) {
                        if (eligibles.containsKey(child)) {
                            eligibles.get(child).add(o);
                        } else {
                            ArrayList<Operand> equivalents = new ArrayList<Operand>(2);
                            equivalents.add(o);
                            eligibles.put(child, equivalents);
                        }
                        this.gatherEligibles(child, eligibles);
                        continue;
                    }
                    o.setChildExpression(this.promoteCommonSubexpressions(child));
                }
            }
        }
    }

    private static boolean isBlockWithLocalParams(Expression in) {
        if (in instanceof Block) {
            Operand[] operands = ((Block)in).getOperanda();
            return operands.length > 0 && operands[0].getChildExpression() instanceof LocalParam;
        }
        return false;
    }

    private void processChildren(Expression in) {
        for (Operand o : in.operands()) {
            Expression child = o.getChildExpression();
            o.setChildExpression(this.promoteCommonSubexpressions(child));
        }
    }
}

