/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.schema;

import com.saxonica.config.EnterpriseConfiguration;
import com.saxonica.ee.schema.SchemaCompiler;
import com.saxonica.ee.schema.SchemaModelSerializer;
import com.saxonica.ee.schema.SchemaStructure;
import com.saxonica.ee.schema.SerializableSchemaComponent;
import com.saxonica.ee.schema.UserSchemaComponent;
import javax.xml.transform.SourceLocator;
import net.sf.saxon.expr.Callable;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.CallableFunction;
import net.sf.saxon.om.Function;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.SchemaComponent;
import net.sf.saxon.value.AnyURIValue;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.ObjectValue;
import net.sf.saxon.value.StringValue;

public class Notation
extends SchemaStructure
implements UserSchemaComponent,
SerializableSchemaComponent {
    private String notationSystemId;
    private StructuredQName notationName;
    private String notationPublicId;

    public Notation(EnterpriseConfiguration config, SourceLocator locator) {
        this.setConfiguration(config);
        this.setLocator(locator);
    }

    public void setNotationName(StructuredQName nameCode) {
        this.notationName = nameCode;
    }

    public StructuredQName getNotationName() {
        return this.notationName;
    }

    public void setNotationSystemId(String systemId) {
        this.notationSystemId = systemId;
    }

    public void setNotationPublicId(String publicId) {
        this.notationPublicId = publicId;
    }

    public String getNotationSystemId() {
        return this.notationSystemId;
    }

    public String getNotationPublicId() {
        return this.notationPublicId;
    }

    public String getName() {
        return this.notationName.getLocalPart();
    }

    public String getTargetNamespace() {
        return this.notationName.getURI();
    }

    @Override
    public boolean validate(SchemaCompiler compiler) {
        return true;
    }

    @Override
    public boolean fixup(SchemaCompiler compiler) {
        this.setFixupStatus(SchemaComponent.ValidationStatus.VALIDATED);
        return true;
    }

    public boolean isSameDeclaration(Notation other) {
        return this == other || this.getNotationName().equals(other.getNotationName()) && this.hasSameLocation(other);
    }

    @Override
    public void elaborate(SchemaCompiler compiler) {
    }

    @Override
    public void serialize(SchemaModelSerializer serializer) throws XPathException {
        String id = serializer.getId(this, true);
        serializer.startElement("notation");
        serializer.emitAttribute("id", id);
        serializer.emitAttribute("name", this.getName());
        if (this.getTargetNamespace() != null && !this.getTargetNamespace().isEmpty()) {
            serializer.emitAttribute("targetNamespace", this.getTargetNamespace());
        }
        if (this.notationPublicId != null) {
            serializer.emitAttribute("publicId", this.notationPublicId);
        }
        if (this.notationSystemId != null) {
            serializer.emitAttribute("systemId", this.notationSystemId);
        }
        serializer.endElement();
    }

    @Override
    public Function getComponentAsFunction() {
        Callable callable = new Callable(){

            public Sequence<?> call(XPathContext context, Sequence[] arguments) throws XPathException {
                String key;
                switch (key = arguments[0].head().getStringValue()) {
                    case "class": {
                        return new StringValue("Notation Declaration");
                    }
                    case "implementation": {
                        return new ObjectValue<Notation>(Notation.this);
                    }
                    case "name": {
                        return new StringValue(Notation.this.getName(), BuiltInAtomicType.NCNAME);
                    }
                    case "target namespace": {
                        return new AnyURIValue(Notation.this.getTargetNamespace());
                    }
                    case "system identifier": {
                        if (Notation.this.getNotationSystemId() == null) {
                            return EmptySequence.getInstance();
                        }
                        return new AnyURIValue(Notation.this.getNotationSystemId());
                    }
                    case "public identifier": {
                        if (Notation.this.getNotationPublicId() == null) {
                            return EmptySequence.getInstance();
                        }
                        return new AnyURIValue(Notation.this.getNotationSystemId());
                    }
                }
                return EmptySequence.getInstance();
            }
        };
        return new CallableFunction(1, callable, COMPONENT_FUNCTION_TYPE);
    }
}

