/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.stream.adjunct;

import com.saxonica.ee.stream.ComponentInversion;
import com.saxonica.ee.stream.Posture;
import com.saxonica.ee.stream.PostureAndSweep;
import com.saxonica.ee.stream.Streamability;
import com.saxonica.ee.stream.StreamableUserFunction;
import com.saxonica.ee.stream.StreamingPatternMaker;
import com.saxonica.ee.stream.Sweep;
import com.saxonica.ee.stream.adjunct.TransmissionAdjunct;
import com.saxonica.ee.stream.feed.Feed;
import com.saxonica.ee.stream.feed.ItemFeed;
import com.saxonica.ee.stream.om.FleetingParentNode;
import com.saxonica.ee.stream.watch.Terminator;
import com.saxonica.ee.stream.watch.Trigger;
import com.saxonica.ee.stream.watch.Watch;
import com.saxonica.ee.stream.watch.WatchMaker;
import com.saxonica.ee.stream.watch.WatchManager;
import com.saxonica.ee.trans.ContextItemStaticInfoEE;
import java.util.ArrayList;
import java.util.List;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.expr.Component;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Operand;
import net.sf.saxon.expr.OperandUsage;
import net.sf.saxon.expr.UserFunctionCall;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMajor;
import net.sf.saxon.expr.instruct.UserFunction;
import net.sf.saxon.expr.parser.Location;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.pattern.Pattern;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.TypeHierarchy;

public class DeepDescentFunctionCallAdjunct
extends TransmissionAdjunct {
    @Override
    public PostureAndSweep computeStreamability(ContextItemStaticInfoEE contextInfo, List<String> reasons) {
        boolean suppliedTypeAllowsParentNodes;
        ItemType declared;
        if (reasons == null) {
            reasons = new ArrayList<String>();
        }
        UserFunctionCall exp = (UserFunctionCall)this.getExpression();
        UserFunction target = exp.getFunction();
        Operand[] operanda = exp.getOperanda().copy();
        operanda[0].setUsage(OperandUsage.TRANSMISSION);
        for (int i = 1; i < operanda.length; ++i) {
            operanda[i].setUsage(Operand.typeDeterminedUsage(target.getArgumentType(i).getPrimaryType()));
        }
        PostureAndSweep ps0 = Streamability.getStreamability(exp.getArg(0), contextInfo, reasons);
        Posture p0 = ps0.getPosture();
        if (p0 != Posture.STRIDING && p0 != Posture.GROUNDED) {
            reasons.add("Posture of first argument to a deep-descent function must be striding or grounded");
            return PostureAndSweep.ROAMING_AND_FREE_RANGING;
        }
        for (int a = 1; a < exp.getArity(); ++a) {
            Expression arg = exp.getArg(a);
            if (Streamability.getStreamability(arg, contextInfo, reasons) == PostureAndSweep.GROUNDED_AND_MOTIONLESS) continue;
            reasons.add("Posture of the second and subsequent arguments to a deep-descent function must (for now) be grounded and motionless");
            return PostureAndSweep.ROAMING_AND_FREE_RANGING;
        }
        if (p0 == Posture.GROUNDED) {
            return new PostureAndSweep(Posture.GROUNDED, ps0.getSweep());
        }
        PostureAndSweep bodyPS = Streamability.getStreamability(target.getBody(), contextInfo, reasons);
        if (bodyPS.getPosture() != Posture.CRAWLING) {
            reasons.add("The body of the deep-descent function must have crawling posture");
            return PostureAndSweep.ROAMING_AND_FREE_RANGING;
        }
        if (bodyPS.getSweep() == Sweep.FREE_RANGING) {
            reasons.add("The body of the deep-descent function must have motionless or consuming sweep");
            return PostureAndSweep.ROAMING_AND_FREE_RANGING;
        }
        TypeHierarchy th = this.getConfiguration().getTypeHierarchy();
        boolean declaredTypeAllowsParentNodes = th.relationship(declared = target.getArgumentType(0).getPrimaryType(), NodeKindTest.DOCUMENT) != 4 || th.relationship(declared, NodeKindTest.ELEMENT) != 4;
        ItemType supplied = exp.getArg(0).getItemType();
        boolean bl = suppliedTypeAllowsParentNodes = th.relationship(supplied, NodeKindTest.DOCUMENT) != 4 || th.relationship(supplied, NodeKindTest.ELEMENT) != 4;
        if (declaredTypeAllowsParentNodes && suppliedTypeAllowsParentNodes) {
            return new PostureAndSweep(p0, Sweep.CONSUMING);
        }
        return ps0;
    }

    @Override
    public WatchMaker getWatchMaker(boolean forGrouping) throws XPathException {
        UserFunctionCall instruction = (UserFunctionCall)this.getExpression();
        Expression select = instruction.getArg(0);
        final Pattern selection = StreamingPatternMaker.makeStreamingPattern(select, this.getConfiguration(), null);
        if (selection != null) {
            return new WatchMaker(){

                @Override
                public Trigger makeWatch(WatchManager watchManager, Feed out, XPathContext context) throws XPathException {
                    DeepDescentFunctionCallAction action = new DeepDescentFunctionCallAction(DeepDescentFunctionCallAdjunct.this.getExpression(), out, context);
                    action.setWatchManager(watchManager);
                    return new Trigger(selection, action, context);
                }
            };
        }
        return null;
    }

    @Override
    public Feed makeItemFeed(WatchManager watchManager, Feed out, XPathContext context) throws XPathException {
        DeepDescentFunctionCallAction action = new DeepDescentFunctionCallAction(this.getExpression(), out, context);
        action.setWatchManager(watchManager);
        return action;
    }

    private static class DeepDescentFunctionCallAction
    extends ItemFeed {
        private XPathContextMajor localContext;
        private WatchManager watchManager;
        private StreamableUserFunction targetFunction;
        private Watch innerWatch;
        private boolean started;

        public DeepDescentFunctionCallAction(Expression functionCall, Feed out, XPathContext context) {
            super(functionCall, out, context);
        }

        @Override
        public void open(Terminator terminator) throws XPathException {
            super.open(terminator);
            UserFunctionCall exp = (UserFunctionCall)this.getExpression();
            Component target = exp.getTargetComponent(this.getContext());
            this.targetFunction = (StreamableUserFunction)target.getActor();
            this.targetFunction.makeInversion();
            this.localContext = this.getContext().newContext();
            this.localContext.setCurrentComponent(target);
            Sequence[] args = exp.evaluateArguments(this.getContext(), true);
            this.localContext.setStackFrame(this.targetFunction.getStackFrameMap(), args);
            this.started = false;
        }

        public void setWatchManager(WatchManager watchManager) {
            this.watchManager = watchManager;
        }

        @Override
        public Receiver startSelectedParentNode(FleetingParentNode node, Location locationId) throws XPathException {
            XPathContextMajor context = this.localContext;
            context.setLocalVariable(0, node);
            this.start();
            this.innerWatch.setAnchorNode(node);
            this.watchManager.addWatch(this.innerWatch, false);
            return null;
        }

        private void start() throws XPathException {
            if (!this.started) {
                this.started = true;
                ComponentInversion inversion = this.targetFunction.getInversion();
                this.innerWatch = inversion.getWatch(this.watchManager, this.getResult(), this.localContext);
                this.innerWatch.open(new Terminator());
            }
        }

        @Override
        public void processItem(Item<?> item) throws XPathException {
            if (!this.hasFailed()) {
                XPathContextMajor context = this.localContext;
                context.setLocalVariable(0, item);
                this.start();
                ((Trigger)this.innerWatch).getAction().processItem(item);
            }
        }

        @Override
        public void endSelectedParentNode(Location locationId) throws XPathException {
            this.watchManager.removeWatch(this.innerWatch);
        }

        @Override
        public void close() throws XPathException {
            this.start();
            this.innerWatch.close();
            super.close();
        }
    }
}

