/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.stream.feed;

import com.saxonica.ee.stream.adjunct.TryCatchAdjunct;
import com.saxonica.ee.stream.feed.Feed;
import com.saxonica.ee.stream.om.FleetingParentNode;
import com.saxonica.ee.stream.watch.Terminator;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.ProxyReceiver;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.Location;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trans.QuitParsingException;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ValidationException;

public abstract class ItemFeed
implements Feed {
    private Terminator terminator;
    private Expression expression;
    private Feed result;
    private XPathContext context;
    private PipelineConfiguration pipe;
    private boolean failed = false;

    public ItemFeed(Feed result, XPathContext context) {
        this.result = result;
        this.context = context;
        if (result == null) {
            throw new NullPointerException();
        }
        this.pipe = result.getPipelineConfiguration();
    }

    public ItemFeed(Expression exp, Feed result, XPathContext context) {
        this.expression = exp;
        this.result = result;
        this.context = context;
        if (result == null) {
            throw new NullPointerException();
        }
        this.pipe = result.getPipelineConfiguration();
    }

    public static void processItems(SequenceIterator<?> iter, Feed result) throws XPathException {
        try {
            iter.forEachOrFail(result::processItem);
        }
        catch (QuitParsingException quit) {
            throw quit;
        }
        catch (XPathException e) {
            if (result instanceof ItemFeed) {
                ((ItemFeed)result).dynamicError(e);
            }
            throw e;
        }
    }

    public void setExpression(Expression exp) {
        this.expression = exp;
    }

    public Expression getExpression() {
        return this.expression;
    }

    public void setTerminator(Terminator terminator) {
        this.terminator = terminator;
    }

    public void setHasFailed() {
        this.failed = true;
    }

    public Terminator getTerminator() {
        return this.terminator;
    }

    public Feed getResult() {
        return this.result;
    }

    public void setPipelineConfiguration(PipelineConfiguration pipe) {
        this.pipe = pipe;
    }

    @Override
    public PipelineConfiguration getPipelineConfiguration() {
        return this.pipe;
    }

    public XPathContext getContext() {
        return this.context;
    }

    @Override
    public void open(Terminator terminator) throws XPathException {
        this.terminator = terminator;
        this.result.open(terminator);
    }

    @Override
    public Receiver startSelectedParentNode(FleetingParentNode node, Location locationId) throws XPathException {
        this.processItem(node);
        return null;
    }

    @Override
    public abstract void processItem(Item<?> var1) throws XPathException;

    @Override
    public void endSelectedParentNode(Location locationId) throws XPathException {
    }

    @Override
    public void close() throws XPathException {
        if (!this.hasFailed()) {
            try {
                this.result.close();
            }
            catch (XPathException e) {
                if (this.expression != null) {
                    e.maybeSetLocation(this.expression.getLocation());
                }
                throw e;
            }
        }
    }

    @Override
    public Receiver getReceiver() {
        Receiver next = this.getResult().getReceiver();
        return new ProxyReceiver(next){

            @Override
            public void append(Item item, Location locationId, int copyNamespaces) throws XPathException {
                ItemFeed.this.processItem(item);
            }
        };
    }

    public void dynamicError(XPathException error) throws XPathException {
        this.setHasFailed();
        if (this.expression != null) {
            error.maybeSetLocation(this.expression.getLocation());
        }
        Feed next = this.getResult();
        while (true) {
            if (next instanceof TryCatchAdjunct.TryCatchFeed) {
                ((TryCatchAdjunct.TryCatchFeed)next).dynamicError(error);
                return;
            }
            if (!(next instanceof ItemFeed)) break;
            ((ItemFeed)next).setHasFailed();
            next = ((ItemFeed)next).getResult();
        }
        if (error instanceof ValidationException) {
            XPathException xe = new XPathException(error);
            xe.setErrorCodeQName(error.getErrorCodeQName());
            throw xe;
        }
        throw error;
    }

    public boolean hasFailed() {
        return this.failed;
    }
}

