/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.stream.feed;

import com.saxonica.ee.stream.feed.AbsorptionFeed;
import com.saxonica.ee.stream.feed.Feed;
import com.saxonica.ee.stream.feed.StringValueGatherer;
import com.saxonica.ee.stream.om.FleetingParentNode;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.value.StringValue;

public class StringValueFeed
extends AbsorptionFeed {
    public StringValueFeed(Feed result, XPathContext context) {
        super(result, context);
    }

    @Override
    protected AbsorptionFeed.PendingItem makePendingItem(int sequenceNr, FleetingParentNode node) {
        return new PendingStringValue(this.valuesReadyToBeOutput.size(), node);
    }

    @Override
    protected Sequence<?> processGroundedItem(Item item) throws XPathException {
        return StringValue.makeStringValue(item.getStringValueCS());
    }

    @Override
    public void close() throws XPathException {
        if (!this.hasFailed()) {
            this.getResult().close();
        }
    }

    private class PendingStringValue
    extends AbsorptionFeed.PendingItem {
        public FastStringBuffer buffer;
        public FleetingParentNode node;

        public PendingStringValue(int sequence, FleetingParentNode node) {
            super(sequence);
            this.buffer = new FastStringBuffer(100);
            this.node = node;
        }

        @Override
        public Receiver getGatherer() {
            return new StringValueGatherer(this.buffer);
        }

        public Sequence deliver() throws XPathException {
            return StringValue.makeStringValue(this.buffer);
        }

        @Override
        public void rollback() {
            this.buffer.setLength(0);
        }
    }
}

