/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.validate;

import net.sf.saxon.event.ProxyReceiver;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.lib.ErrorReporter;
import net.sf.saxon.om.AttributeMap;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamespaceMap;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.s9api.Location;
import net.sf.saxon.str.UnicodeString;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.trans.XmlProcessingException;
import net.sf.saxon.type.SchemaType;

public class CatchingReceiver
extends ProxyReceiver {
    private final ErrorReporter listener;
    private boolean failed = false;

    public CatchingReceiver(Receiver next, ErrorReporter listener) {
        super(next);
        this.listener = listener;
    }

    @Override
    public void open() {
        if (!this.failed) {
            try {
                super.open();
            }
            catch (XPathException err) {
                this.failed = true;
                this.listener.report(new XmlProcessingException(err));
            }
        }
    }

    @Override
    public void close() {
        if (!this.failed) {
            try {
                super.close();
            }
            catch (XPathException err) {
                this.failed = true;
                this.listener.report(new XmlProcessingException(err));
            }
        }
    }

    @Override
    public void startDocument(int properties) {
        if (!this.failed) {
            try {
                super.startDocument(properties);
            }
            catch (XPathException err) {
                this.failed = true;
                this.listener.report(new XmlProcessingException(err));
            }
        }
    }

    @Override
    public void endDocument() {
        if (!this.failed) {
            try {
                super.endDocument();
            }
            catch (XPathException err) {
                this.failed = true;
                this.listener.report(new XmlProcessingException(err));
            }
        }
    }

    @Override
    public void startElement(NodeName elemName, SchemaType type, AttributeMap attributes, NamespaceMap namespaces, Location location, int properties) {
        if (!this.failed) {
            try {
                super.startElement(elemName, type, attributes, namespaces, location, properties);
            }
            catch (XPathException err) {
                this.failed = true;
                this.listener.report(new XmlProcessingException(err));
            }
        }
    }

    @Override
    public void endElement() {
        if (!this.failed) {
            try {
                super.endElement();
            }
            catch (XPathException err) {
                this.failed = true;
                this.listener.report(new XmlProcessingException(err));
            }
        }
    }

    @Override
    public void characters(UnicodeString chars, Location locationId, int properties) {
        if (!this.failed) {
            try {
                super.characters(chars, locationId, properties);
            }
            catch (XPathException err) {
                this.failed = true;
                this.listener.report(new XmlProcessingException(err));
            }
        }
    }

    @Override
    public void processingInstruction(String target, UnicodeString data, Location locationId, int properties) {
        if (!this.failed) {
            try {
                super.processingInstruction(target, data, locationId, properties);
            }
            catch (XPathException err) {
                this.failed = true;
                this.listener.report(new XmlProcessingException(err));
            }
        }
    }

    @Override
    public void comment(UnicodeString chars, Location locationId, int properties) {
        if (!this.failed) {
            try {
                super.comment(chars, locationId, properties);
            }
            catch (XPathException err) {
                this.failed = true;
                this.listener.report(new XmlProcessingException(err));
            }
        }
    }

    @Override
    public void append(Item item, Location locationId, int copyNamespaces) {
        if (!this.failed) {
            try {
                super.append(item, locationId, copyNamespaces);
            }
            catch (XPathException err) {
                this.failed = true;
                this.listener.report(new XmlProcessingException(err));
            }
        }
    }
}

