/*
 * Decompiled with CFR 0.152.
 */
package chipmunk.segmenter;

import chipmunk.segmenter.SegmentationInstance;
import java.util.List;

public class SegmentationResult {
    private List<Integer> tags_;
    private List<Integer> input_indexes_;
    private double score_;

    public String toString() {
        return "[" + this.tags_ + " " + this.input_indexes_ + "]";
    }

    public SegmentationResult(List<Integer> tags, List<Integer> inputs, double score) {
        this.input_indexes_ = inputs;
        this.tags_ = tags;
        this.score_ = score;
    }

    public SegmentationResult(List<Integer> tags, List<Integer> inputs) {
        this(tags, inputs, Double.NEGATIVE_INFINITY);
    }

    public List<Integer> getTags() {
        return this.tags_;
    }

    public List<Integer> getInputIndexes() {
        return this.input_indexes_;
    }

    public boolean isCorrect(SegmentationInstance instance) {
        for (SegmentationResult result : instance.getResults()) {
            if (!this.tags_.equals(result.getTags()) || !this.input_indexes_.equals(result.getInputIndexes())) continue;
            return true;
        }
        return false;
    }

    public boolean isSegmentationCorrect(SegmentationInstance instance) {
        for (SegmentationResult result : instance.getResults()) {
            if (!this.input_indexes_.equals(result.getInputIndexes())) continue;
            return true;
        }
        return false;
    }

    public double getScore() {
        return this.score_;
    }
}

