/*
 * Decompiled with CFR 0.152.
 */
package experimental.analyzer;

import experimental.analyzer.Analyzer;
import experimental.analyzer.AnalyzerInstance;
import experimental.analyzer.AnalyzerReading;
import java.util.Collection;
import java.util.HashSet;
import java.util.logging.Logger;

public class TreebankAnalyzerResult {
    private static final Logger logger_ = Logger.getLogger(TreebankAnalyzerResult.class.getName());
    int num_tokens_;
    int num_types_;
    int type_ambiguity_;
    int token_ambiguity_;
    double type_coverage_;
    int token_coverage_;

    public static void logResult(Analyzer analyzer, String filename) {
        TreebankAnalyzerResult.logResult(analyzer, filename, 100);
    }

    public static TreebankAnalyzerResult test(Analyzer analyzer, String filename) {
        return TreebankAnalyzerResult.test(analyzer, AnalyzerInstance.getTreebankInstances(filename));
    }

    public static TreebankAnalyzerResult test(Analyzer analyzer, Collection<AnalyzerInstance> instances) {
        TreebankAnalyzerResult result = new TreebankAnalyzerResult();
        for (AnalyzerInstance instance : instances) {
            result.test(analyzer, instance);
        }
        return result;
    }

    public void test(Analyzer analyzer, AnalyzerInstance instance) {
        if (analyzer.isUnknown(instance)) {
            HashSet<AnalyzerReading> actual = new HashSet<AnalyzerReading>(analyzer.analyze(instance));
            Collection<AnalyzerReading> expected = instance.getReadings();
            int instance_count = 0;
            for (AnalyzerReading reading : expected) {
                instance_count += reading.getCount();
                if (!actual.contains(reading)) continue;
                this.type_coverage_ += 1.0 / (double)expected.size();
                this.token_coverage_ += reading.getCount();
            }
            this.num_tokens_ += instance_count;
            ++this.num_types_;
            this.type_ambiguity_ += actual.size();
            this.token_ambiguity_ += actual.size() * instance_count;
        }
    }

    public static void logResult(Analyzer analyzer, String filename, int num_errors) {
        TreebankAnalyzerResult result = TreebankAnalyzerResult.test(analyzer, filename);
        result.logToken();
        result.logType();
    }

    public void logType() {
        this.logTypeCoverage();
        this.logTypeAmbiguity();
    }

    private void logTypeAmbiguity() {
        logger_.info(String.format("Type Amb: %d / %d = %g", this.type_ambiguity_, this.num_types_, (double)this.type_ambiguity_ / (double)this.num_types_));
    }

    private void logTypeCoverage() {
        logger_.info(String.format("Type Cov: %g / %d = %g", this.type_coverage_, this.num_types_, this.type_coverage_ / (double)this.num_types_));
    }

    public void logToken() {
        this.logTokenCoverage();
        this.logTokenAmbiguity();
    }

    private void logTokenAmbiguity() {
        logger_.info(String.format("Token Amb: %d / %d = %g", this.token_ambiguity_, this.num_tokens_, (double)this.token_ambiguity_ / (double)this.num_tokens_));
    }

    private void logTokenCoverage() {
        logger_.info(String.format("Token Cov: %d / %d = %g", this.token_coverage_, this.num_tokens_, (double)this.token_coverage_ / (double)this.num_tokens_));
    }
}

