/*
 * Decompiled with CFR 0.152.
 */
package marmot.core;

import java.util.List;
import lemming.lemma.ranker.RankerCandidate;
import marmot.core.FeatureVector;
import marmot.core.Transition;
import marmot.core.WeightVector;
import marmot.util.Check;
import marmot.util.Numerics;

public class State {
    private FeatureVector vector_;
    private double score_;
    protected double estimated_count_;
    private Transition[] transitions_;
    private int index_;
    private State sub_level_state_;
    private List<RankerCandidate> candidates_;
    private double candidate_score_sum_;

    public State() {
        this.index_ = -1;
        this.candidate_score_sum_ = Double.NEGATIVE_INFINITY;
    }

    public State(int index) {
        assert (index >= 0);
        this.index_ = index;
    }

    public State(int index, State sub_level_state) {
        this(index);
        this.sub_level_state_ = sub_level_state;
    }

    public void setVector(FeatureVector vector) {
        this.vector_ = vector;
    }

    public void setScore(double score) {
        this.score_ = score;
    }

    public FeatureVector getVector() {
        return this.vector_;
    }

    public double getScore() {
        if (this.candidates_ != null) {
            return this.candidate_score_sum_;
        }
        return this.score_;
    }

    public void setTransitions(Transition[] transitions) {
        this.transitions_ = transitions;
    }

    public int getIndex() {
        return this.index_;
    }

    public State getZeroOrderState() {
        return this;
    }

    public Transition getTransition(int previous_state_index) {
        return this.transitions_[previous_state_index];
    }

    public int getOrder() {
        return 1;
    }

    public boolean canTransitionTo(State other) {
        if (other.getOrder() != 1) assert (this.getIndex() == 0);
        return true;
    }

    public Transition[] getTransitions() {
        return this.transitions_;
    }

    public void incrementEstimatedCounts(double d) {
        this.estimated_count_ += d;
    }

    public void updateWeights(WeightVector weights) {
        if (this.estimated_count_ != 0.0) {
            weights.updateWeights(this, this.estimated_count_, true);
            this.estimated_count_ = 0.0;
        }
        if (this.candidates_ != null) {
            for (RankerCandidate candidate : this.candidates_) {
                candidate.updateWeights(this, weights);
            }
        }
    }

    public int getLevel() {
        if (this.sub_level_state_ == null) {
            return 0;
        }
        return this.sub_level_state_.getLevel() + 1;
    }

    public State getSubLevel(int depth) {
        assert (depth >= 0);
        if (depth == 0) {
            return this;
        }
        if (this.sub_level_state_ == null) {
            if (depth == 1) {
                return null;
            }
            throw new RuntimeException("Can't reach depth!");
        }
        return this.sub_level_state_.getSubLevel(depth - 1);
    }

    public State getSubLevelState() {
        return this.sub_level_state_;
    }

    public void setSubLevelState(State sub_level_state) {
        this.sub_level_state_ = sub_level_state;
    }

    public boolean equalIndexes(State other) {
        if (this.index_ != other.getIndex()) {
            return false;
        }
        assert (other.getLevel() == this.getLevel());
        if (other.getSubLevelState() != null) {
            return other.getSubLevelState().equalIndexes(this.getSubLevelState());
        }
        return true;
    }

    public State getSubOrderState() {
        return null;
    }

    public State getPreviousSubOrderState() {
        return null;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        if (this.sub_level_state_ != null) {
            sb.append(this.sub_level_state_);
        }
        sb.append(' ');
        sb.append(this.index_);
        sb.append(']');
        return sb.toString();
    }

    public boolean check() {
        return this.transitions_ == null;
    }

    public State copy(State state) {
        state.vector_ = this.vector_;
        state.score_ = this.score_;
        state.transitions_ = this.transitions_;
        state.index_ = this.index_;
        state.sub_level_state_ = this.sub_level_state_;
        state.estimated_count_ = this.estimated_count_;
        state.candidate_score_sum_ = this.candidate_score_sum_;
        state.candidates_ = this.candidates_;
        return state;
    }

    public State copy() {
        State state = this.copy(new State());
        assert (state.index_ >= 0);
        return state;
    }

    public void setLemmaCandidates(List<RankerCandidate> candidates) {
        assert (this.getOrder() == 1);
        this.candidates_ = candidates;
    }

    public List<RankerCandidate> getLemmaCandidates() {
        assert (this.getOrder() == 1);
        return this.candidates_;
    }

    public void setLemmaScoreSum() {
        assert (this.getOrder() == 1);
        assert (this.getLemmaCandidates() != null);
        assert (Check.isNormal(this.score_));
        this.candidate_score_sum_ = Double.NEGATIVE_INFINITY;
        for (RankerCandidate candidate : this.getLemmaCandidates()) {
            double candidate_score = candidate.getScore() + this.score_;
            assert (Check.isNormal(candidate_score));
            this.candidate_score_sum_ = Numerics.sumLogProb(this.candidate_score_sum_, candidate_score);
        }
        assert (this.candidate_score_sum_ != Double.NEGATIVE_INFINITY);
        assert (Check.isNormal(this.candidate_score_sum_));
    }

    public double getRealScore() {
        assert (this.getOrder() == 1);
        return this.score_;
    }
}

