/*
 * Decompiled with CFR 0.152.
 */
package marmot.test.core;

import marmot.core.ConcatFloatFeatureVector;
import marmot.core.DenseArrayFloatFeatureVector;
import marmot.core.FloatFeatureVector;
import marmot.core.FloatWeights;
import marmot.core.ZeroFloatFeatureVector;
import org.junit.Assert;
import org.junit.Test;

public class FloatVectorTest {
    public void sumHelper(double[] expected, TestWeights fw, FloatFeatureVector vc, double update) {
        Assert.assertArrayEquals((double[])expected, (double[])fw.weights_, (double)1.0E-5);
        double expected_sum = 0.0;
        for (double f : expected) {
            expected_sum += f * f / update;
        }
        double actual_sum = vc.getDotProduct(fw, 0, 0);
        Assert.assertEquals((double)expected_sum, (double)actual_sum, (double)1.0E-5);
    }

    @Test
    public void test() {
        TestWeights fw = new TestWeights(1, 6);
        double[] w = new double[]{1.0, 0.5, 0.3};
        DenseArrayFloatFeatureVector v = new DenseArrayFloatFeatureVector(w);
        double[] w2 = new double[]{-1.0, -0.5, -0.3};
        DenseArrayFloatFeatureVector v2 = new DenseArrayFloatFeatureVector(w2);
        ConcatFloatFeatureVector v3 = new ConcatFloatFeatureVector(v, v2);
        v3.updateFloatWeight(fw, 0, 0, 1.0);
        double[] expected = new double[]{1.0, 0.5, 0.3, -1.0, -0.5, -0.3};
        this.sumHelper(expected, fw, v3, 1.0);
        fw = new TestWeights(1, 9);
        w = new double[]{1.0, 0.5, 0.3};
        v = new DenseArrayFloatFeatureVector(w);
        w2 = new double[]{-1.0, -0.5, -0.3};
        v2 = new DenseArrayFloatFeatureVector(w2);
        double[] w3 = new double[]{-2.0, -0.7, -0.2};
        DenseArrayFloatFeatureVector v32 = new DenseArrayFloatFeatureVector(w3);
        ConcatFloatFeatureVector vc = new ConcatFloatFeatureVector(v, new ConcatFloatFeatureVector(v2, v32));
        vc.updateFloatWeight(fw, 0, 0, 1.0);
        double[] expected2 = new double[]{1.0, 0.5, 0.3, -1.0, -0.5, -0.3, -2.0, -0.7, -0.2};
        this.sumHelper(expected2, fw, vc, 1.0);
    }

    @Test
    public void zero() {
        TestWeights fw = new TestWeights(1, 6);
        ZeroFloatFeatureVector v = new ZeroFloatFeatureVector(3);
        double[] w2 = new double[]{-1.0, -0.5, -0.3};
        FloatFeatureVector v2 = new DenseArrayFloatFeatureVector(w2);
        ConcatFloatFeatureVector v3 = new ConcatFloatFeatureVector(v, v2);
        v3.updateFloatWeight(fw, 0, 0, 1.0);
        double[] expected = new double[]{0.0, 0.0, 0.0, -1.0, -0.5, -0.3};
        this.sumHelper(expected, fw, v3, 1.0);
        fw = new TestWeights(1, 6);
        double[] w = new double[]{1.0, 0.5, 0.3};
        DenseArrayFloatFeatureVector v4 = new DenseArrayFloatFeatureVector(w);
        v2 = new ZeroFloatFeatureVector(3);
        v3 = new ConcatFloatFeatureVector(v4, v2);
        v3.updateFloatWeight(fw, 0, 0, 0.1);
        expected = new double[]{0.1, 0.05, 0.03, 0.0, 0.0, 0.0};
        this.sumHelper(expected, fw, v3, 0.1);
    }

    class TestWeights
    implements FloatWeights {
        public int num_tags_;
        public double[] weights_;

        public TestWeights(int num_tags, int dim) {
            this.num_tags_ = num_tags;
            this.weights_ = new double[dim * num_tags];
        }

        @Override
        public int getFloatIndex(int feature, int tag_index) {
            return feature * this.num_tags_ + tag_index;
        }

        @Override
        public double getFloatWeight(int index) {
            return this.weights_[index];
        }

        @Override
        public void updateFloatWeight(int index, double value) {
            int n = index;
            this.weights_[n] = this.weights_[n] + value;
        }
    }
}

