/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.cmdline.tokenizer;

import java.io.File;
import java.io.IOException;
import opennlp.tools.cmdline.BasicCmdLineTool;
import opennlp.tools.cmdline.CmdLineUtil;
import opennlp.tools.cmdline.PerformanceMonitor;
import opennlp.tools.cmdline.SystemInputStreamFactory;
import opennlp.tools.cmdline.tokenizer.DetokenizationDictionaryLoader;
import opennlp.tools.tokenize.DetokenizationDictionary;
import opennlp.tools.tokenize.DictionaryDetokenizer;
import opennlp.tools.tokenize.WhitespaceTokenizer;
import opennlp.tools.util.InputStreamFactory;
import opennlp.tools.util.PlainTextByLineStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DictionaryDetokenizerTool
extends BasicCmdLineTool {
    private static final Logger logger = LoggerFactory.getLogger(DictionaryDetokenizerTool.class);

    @Override
    public String getShortDescription() {
        return "Normalizes tokenized text according to rules defined in a detokenizer dictionary";
    }

    @Override
    public String getHelp() {
        return "Usage: opennlp " + this.getName() + " detokenizerDictionary";
    }

    @Override
    public void run(String[] args2) {
        if (args2.length != 1) {
            logger.info(this.getHelp());
        } else {
            try {
                DictionaryDetokenizer detokenizer = new DictionaryDetokenizer((DetokenizationDictionary)new DetokenizationDictionaryLoader().load(new File(args2[0])));
                try (PlainTextByLineStream tokenizedLineStream = new PlainTextByLineStream((InputStreamFactory)new SystemInputStreamFactory(), SystemInputStreamFactory.encoding());){
                    String tokenizedLine;
                    PerformanceMonitor perfMon = new PerformanceMonitor("sent");
                    perfMon.start();
                    while ((tokenizedLine = (String)tokenizedLineStream.read()) != null) {
                        String[] tokens = WhitespaceTokenizer.INSTANCE.tokenize(tokenizedLine);
                        logger.info(detokenizer.detokenize(tokens, null));
                        perfMon.incrementCounter();
                    }
                    perfMon.stopAndPrintFinalResult();
                }
            }
            catch (IOException e) {
                CmdLineUtil.handleStdinIoError(e);
            }
        }
    }
}

