/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.extfn.js;

import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Operand;
import net.sf.saxon.expr.OperandRole;
import net.sf.saxon.expr.instruct.Instruction;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.RebindingMap;
import net.sf.saxon.om.AttributeInfo;
import net.sf.saxon.om.AttributeMap;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.style.Compilation;
import net.sf.saxon.style.ComponentDeclaration;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;

public class IXSLPromise
extends StyleElement {
    private Expression select;
    private Expression onCompletion;
    private Expression onFailure;

    @Override
    public boolean isInstruction() {
        return true;
    }

    @Override
    protected boolean mayContainSequenceConstructor() {
        return false;
    }

    @Override
    protected void prepareAttributes() {
        AttributeMap atts = this.attributes();
        for (AttributeInfo att : atts) {
            NodeName attName = att.getNodeName();
            String f = attName.getDisplayName();
            if (f.equals("select")) {
                String selectAtt = att.getValue();
                this.select = this.makeExpression(selectAtt, att);
                continue;
            }
            if (f.equals("on-completion")) {
                String completionAtt = att.getValue();
                this.onCompletion = this.makeExpression(completionAtt, att);
                continue;
            }
            if (f.equals("on-failure")) {
                String failureAtt = att.getValue();
                this.onFailure = this.makeExpression(failureAtt, att);
                continue;
            }
            this.checkUnknownAttribute(attName);
        }
        if (this.select == null) {
            this.reportAbsence("select");
        }
    }

    @Override
    public void validate(ComponentDeclaration decl) throws XPathException {
        this.checkEmpty();
        this.select = this.typeCheck("select", this.select);
        this.onCompletion = this.typeCheck("on-completion", this.onCompletion);
        this.onFailure = this.typeCheck("on-failure", this.onFailure);
    }

    @Override
    public Expression compile(Compilation exec, ComponentDeclaration decl) throws XPathException {
        if (!"JS3".equals(exec.getCompilerInfo().getTargetEdition())) {
            this.compileError("ixsl:promise is available only if the target edition is JS3");
        }
        return new PromiseInstr(this.select, this.onCompletion, this.onFailure);
    }

    private static class PromiseInstr
    extends Instruction {
        private final Operand selectOp;
        private Operand onCompletionOp;
        private Operand onFailureOp;

        public PromiseInstr(Expression select, Expression onCompletion, Expression onFailure) {
            this.selectOp = new Operand(this, select, OperandRole.SINGLE_ATOMIC);
            if (onCompletion != null) {
                this.onCompletionOp = new Operand(this, onCompletion, OperandRole.SINGLE_ATOMIC);
            }
            if (onFailure != null) {
                this.onFailureOp = new Operand(this, onFailure, OperandRole.SINGLE_ATOMIC);
            }
        }

        public Expression getSelect() {
            return this.selectOp.getChildExpression();
        }

        public Expression getOnCompletion() {
            return this.onCompletionOp == null ? null : this.onCompletionOp.getChildExpression();
        }

        public Expression getOnFailure() {
            return this.onFailureOp == null ? null : this.onFailureOp.getChildExpression();
        }

        @Override
        public int getImplementationMethod() {
            return 4;
        }

        @Override
        public Iterable<Operand> operands() {
            return this.operandSparseList(this.selectOp, this.onCompletionOp, this.onFailureOp);
        }

        @Override
        public String getExpressionName() {
            return "schedule";
        }

        @Override
        public String toString() {
            return "promise";
        }

        @Override
        public void export(ExpressionPresenter out) throws XPathException {
            out.startElement("schedule", this);
            out.setChildRole("select");
            this.selectOp.getChildExpression().export(out);
            if (this.onCompletionOp != null) {
                out.setChildRole("on-completion");
                this.onCompletionOp.getChildExpression().export(out);
            }
            if (this.onFailureOp != null) {
                out.setChildRole("on-failure");
                this.onFailureOp.getChildExpression().export(out);
            }
            out.endElement();
        }

        @Override
        public Expression copy(RebindingMap rm) {
            PromiseInstr p2 = new PromiseInstr(this.copy(this.getSelect(), rm), this.copy(this.getOnCompletion(), rm), this.copy(this.getOnFailure(), rm));
            ExpressionTool.copyLocationInfo(this, p2);
            return p2;
        }

        private Expression copy(Expression exp, RebindingMap rebindings) {
            return exp == null ? null : exp.copy(rebindings);
        }
    }
}

