/*
 * Decompiled with CFR 0.152.
 */
package marmot.test.tokenizer.opennlp;

import java.util.LinkedList;
import java.util.List;
import marmot.tokenize.openlp.Aligner;
import marmot.tokenize.openlp.LevenshteinAligner;
import org.junit.Assert;
import org.junit.Test;

public class LevenshteinAlignerTest {
    public void bothWayTest(String tok, String untok, List<Aligner.Pair> expected, long time) {
        LevenshteinAligner a = new LevenshteinAligner();
        Aligner.Result actual = a.align(untok, tok);
        Assert.assertEquals(expected, actual.pairs);
        LinkedList<Aligner.Pair> expected_reversed = new LinkedList<Aligner.Pair>();
        for (Aligner.Pair pair : expected) {
            expected_reversed.add(new Aligner.Pair(pair.b, pair.a));
        }
        actual = a.align(tok, untok);
        Assert.assertEquals(expected_reversed, actual.pairs);
    }

    public void bothWayTest(String tok, String untok, List<Aligner.Pair> expected) {
        this.bothWayTest(tok, untok, expected, 1000L);
    }

    @Test
    public void toyExampleAlignTest() {
        String tok = "A -LRB- B";
        String untok = "A (B";
        LinkedList<Aligner.Pair> expected = new LinkedList<Aligner.Pair>();
        expected.add(new Aligner.Pair(0, 0));
        expected.add(new Aligner.Pair(1, 1));
        expected.add(new Aligner.Pair(2, 2));
        expected.add(new Aligner.Pair(2, 3));
        expected.add(new Aligner.Pair(2, 4));
        expected.add(new Aligner.Pair(2, 5));
        expected.add(new Aligner.Pair(2, 6));
        expected.add(new Aligner.Pair(-1, 7));
        expected.add(new Aligner.Pair(3, 8));
        this.bothWayTest(tok, untok, expected);
        tok = "A -- C -- B";
        untok = "A (C) B";
        expected = new LinkedList();
        expected.add(new Aligner.Pair(0, 0));
        expected.add(new Aligner.Pair(1, 1));
        expected.add(new Aligner.Pair(2, 2));
        expected.add(new Aligner.Pair(2, 3));
        expected.add(new Aligner.Pair(-1, 4));
        expected.add(new Aligner.Pair(3, 5));
        expected.add(new Aligner.Pair(-1, 6));
        expected.add(new Aligner.Pair(4, 7));
        expected.add(new Aligner.Pair(4, 8));
        expected.add(new Aligner.Pair(5, 9));
        expected.add(new Aligner.Pair(6, 10));
        this.bothWayTest(tok, untok, expected);
        tok = "A L B";
        untok = "A (B";
        expected = new LinkedList();
        expected.add(new Aligner.Pair(0, 0));
        expected.add(new Aligner.Pair(1, 1));
        expected.add(new Aligner.Pair(2, 2));
        expected.add(new Aligner.Pair(-1, 3));
        expected.add(new Aligner.Pair(3, 4));
        this.bothWayTest(tok, untok, expected);
    }

    @Test
    public void insertProblemTest() {
        String tok = "A -- -- B";
        String untok = "A () B";
        LinkedList<Aligner.Pair> expected = new LinkedList<Aligner.Pair>();
        expected.add(new Aligner.Pair(0, 0));
        expected.add(new Aligner.Pair(1, 1));
        expected.add(new Aligner.Pair(2, 2));
        expected.add(new Aligner.Pair(2, 3));
        expected.add(new Aligner.Pair(-1, 4));
        expected.add(new Aligner.Pair(3, 5));
        expected.add(new Aligner.Pair(3, 6));
        expected.add(new Aligner.Pair(4, 7));
        expected.add(new Aligner.Pair(5, 8));
        this.bothWayTest(tok, untok, expected);
    }

    public List<Aligner.Pair> getParanExpected(String tok) {
        LinkedList<Aligner.Pair> expected = new LinkedList<Aligner.Pair>();
        int untok_index = 0;
        for (int i = 0; i < tok.length(); ++i) {
            if (i % 3 == 2) {
                expected.add(new Aligner.Pair(-1, i));
                ++untok_index;
                continue;
            }
            expected.add(new Aligner.Pair(untok_index, i));
        }
        return expected;
    }

    @Test
    public void paranTest() {
        String tok = "-- --";
        String untok = "()";
        List<Aligner.Pair> expected = new LinkedList<Aligner.Pair>();
        expected.add(new Aligner.Pair(0, 0));
        expected.add(new Aligner.Pair(0, 1));
        expected.add(new Aligner.Pair(-1, 2));
        expected.add(new Aligner.Pair(1, 3));
        expected.add(new Aligner.Pair(1, 4));
        this.bothWayTest(tok, untok, expected);
        tok = "-- -- -- --";
        untok = "(())";
        expected = this.getParanExpected(tok);
        this.bothWayTest(tok, untok, expected);
        tok = "-- -- -- -- -- -- -- --";
        untok = "(((())))";
        expected = this.getParanExpected(tok);
        this.bothWayTest(tok, untok, expected);
        tok = "-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- --";
        untok = "(((((((())))))))";
        expected = this.getParanExpected(tok);
        this.bothWayTest(tok, untok, expected);
    }

    @Test
    public void bigParanTest() {
        String tok = "-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- --";
        String untok = "(((((((((((((((())))))))))))))))";
        this.expectTimeout(tok, untok, 1000L);
    }

    private void expectTimeout(String tok, String untok, long time) {
        this.expectNoAlign(tok, untok, Aligner.ResultType.Timeout, time);
    }

    private void expectNoAlign(String tok, String untok) {
        this.expectNoAlign(tok, untok, Aligner.ResultType.NoAlignmentFound, 1000L);
    }

    private void expectNoAlign(String tok, String untok, Aligner.ResultType type, long time) {
        LevenshteinAligner a = new LevenshteinAligner(time);
        Aligner.Result actual = a.align(untok, tok);
        System.err.println(actual);
        Assert.assertEquals(null, actual.pairs);
        Assert.assertEquals((Object)((Object)type), (Object)((Object)actual.result_type));
    }

    @Test
    public void quasiRealWorldTest() {
        String tok = "\u201e \u201e AAA \u201c \u201c";
        String untok = "\"\"AAA\"\"";
        LinkedList<Aligner.Pair> expected = new LinkedList<Aligner.Pair>();
        expected.add(new Aligner.Pair(0, 0));
        expected.add(new Aligner.Pair(-1, 1));
        expected.add(new Aligner.Pair(1, 2));
        expected.add(new Aligner.Pair(-1, 3));
        expected.add(new Aligner.Pair(2, 4));
        expected.add(new Aligner.Pair(3, 5));
        expected.add(new Aligner.Pair(4, 6));
        expected.add(new Aligner.Pair(-1, 7));
        expected.add(new Aligner.Pair(5, 8));
        expected.add(new Aligner.Pair(-1, 9));
        expected.add(new Aligner.Pair(6, 10));
        this.bothWayTest(tok, untok, expected);
        tok = "B BBB B";
        untok = "B(B";
        expected = new LinkedList();
        expected.add(new Aligner.Pair(0, 0));
        expected.add(new Aligner.Pair(-1, 1));
        expected.add(new Aligner.Pair(1, 2));
        expected.add(new Aligner.Pair(1, 3));
        expected.add(new Aligner.Pair(1, 4));
        expected.add(new Aligner.Pair(-1, 5));
        expected.add(new Aligner.Pair(2, 6));
        this.bothWayTest(tok, untok, expected);
    }

    @Test
    public void realSentenceTest() {
        int i;
        LinkedList<Aligner.Pair> expected = new LinkedList<Aligner.Pair>();
        String tok = "VI Fz Fz C.";
        String untok = "VI\u00a0C.";
        this.expectNoAlign(tok, untok);
        tok = "d\u00e1 me lo";
        untok = "d\u00e1melo";
        expected.clear();
        expected.add(new Aligner.Pair(0, 0));
        expected.add(new Aligner.Pair(1, 1));
        expected.add(new Aligner.Pair(-1, 2));
        expected.add(new Aligner.Pair(2, 3));
        expected.add(new Aligner.Pair(3, 4));
        expected.add(new Aligner.Pair(-1, 5));
        expected.add(new Aligner.Pair(4, 6));
        expected.add(new Aligner.Pair(5, 7));
        this.bothWayTest(tok, untok, expected);
        tok = "de el";
        untok = "deL";
        expected.clear();
        expected.add(new Aligner.Pair(0, 0));
        expected.add(new Aligner.Pair(1, 1));
        expected.add(new Aligner.Pair(-1, 2));
        expected.add(new Aligner.Pair(2, 3));
        expected.add(new Aligner.Pair(2, 4));
        this.bothWayTest(tok, untok, expected);
        tok = "de el";
        untok = "del";
        this.expectNoAlign(tok, untok);
        tok = "L 1 bis L 499";
        untok = "L\u00a01 bis L\u00a0499";
        expected.clear();
        for (i = 0; i < tok.length(); ++i) {
            expected.add(new Aligner.Pair(i, i));
        }
        this.bothWayTest(tok, untok, expected);
        tok = "vorgesehen , f\u00fcr diejenigen im Gebiet des Landschaftsverbandes Westfalen-Lippe die Bezeichnungen von L 501 bis L 999 .";
        untok = "vorgesehen, f\u00fcr diejenigen im Gebiet des Landschaftsverbandes Westfalen-Lippe die Bezeichnungen von L\u00a0501 bis L\u00a0999.";
        expected.clear();
        for (i = 0; i < 10; ++i) {
            expected.add(new Aligner.Pair(i, i));
        }
        expected.add(new Aligner.Pair(-1, 10));
        for (i = 10; i < untok.length() - 1; ++i) {
            expected.add(new Aligner.Pair(i, i + 1));
        }
        expected.add(new Aligner.Pair(-1, untok.length()));
        expected.add(new Aligner.Pair(untok.length() - 1, untok.length() + 1));
        this.bothWayTest(tok, untok, expected);
    }
}

