/*
 * Decompiled with CFR 0.152.
 */
package experimental.ising;

import experimental.ising.BinaryFactor;
import experimental.ising.IsingFactorGraph;
import experimental.ising.UnaryFactor;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.Random;
import marmot.util.Numerics;
import org.javatuples.Pair;

public class BruteForceUnit {
    public static void main(String[] args2) {
        int correct = 0;
        int total = 100;
        for (int i = 0; i < total; ++i) {
            if (!BruteForceUnit.test(3)) continue;
            ++correct;
        }
        System.out.println((double)correct / (double)total);
    }

    public static boolean test(int numVariables) {
        Random rand = new Random();
        LinkedList<String> tagNames = new LinkedList<String>();
        for (int i = 0; i < numVariables; ++i) {
            tagNames.add("");
        }
        LinkedList<Pair<Integer, Integer>> pairs = new LinkedList<Pair<Integer, Integer>>();
        pairs.add(new Pair((Object)0, (Object)1));
        pairs.add(new Pair((Object)1, (Object)2));
        pairs.add(new Pair((Object)0, (Object)2));
        ArrayList<Integer> golden = new ArrayList<Integer>();
        for (int i = 0; i < numVariables; ++i) {
            golden.add(0);
        }
        IsingFactorGraph fg = new IsingFactorGraph(numVariables, pairs, golden, tagNames);
        int numParameters = 2 * fg.unaryFactors.size() + 4 * fg.binaryFactors.size();
        double[] parameters = new double[numParameters];
        parameters[2 * fg.unaryFactors.size()] = 1.0;
        parameters[2 * fg.unaryFactors.size() + 2] = 1.0;
        int counter = 0;
        for (UnaryFactor uf : fg.unaryFactors) {
            uf.setPotential(0, Math.exp(parameters[counter]));
            uf.setPotential(1, Math.exp(parameters[++counter]));
            ++counter;
        }
        for (BinaryFactor bf : fg.binaryFactors) {
            bf.setPotential(0, 0, Math.exp(parameters[counter]));
            bf.setPotential(0, 1, Math.exp(parameters[++counter]));
            bf.setPotential(1, 0, Math.exp(parameters[++counter]));
            bf.setPotential(1, 1, Math.exp(parameters[++counter]));
            ++counter;
        }
        double[][] marginalsBruteForce = fg.inferenceBruteForce();
        fg.inference(10, 1.0);
        for (int n = 0; n < numVariables; ++n) {
            double[] marginal = fg.variables.get((int)n).getBelief().measure;
            if (Numerics.approximatelyEqual(marginalsBruteForce[n], marginal, 0.1)) continue;
            return false;
        }
        return true;
    }
}

