/*
 * Decompiled with CFR 0.152.
 */
package marmot.morph.mapper.latin;

import marmot.morph.mapper.MorphTag;

public class ItMorphTag
implements MorphTag {
    public static boolean VERBOSE = true;
    public FlexionalType flexional_type_ = FlexionalType.Undef;
    public FlexionalCategory flexional_category_;
    public Mood mood_;
    public Tense tense_;
    public ParticipialsDegree participials_degree_;
    public CaseNumber case_number;
    public Composition composition_;
    public FormalVariation formal_variation_;
    public GraphicalVariation graphical_variation_;
    public GenderNumberPerson gender_number_person_;
    public NominalsDegree nominals_degree_ = NominalsDegree.Undef;

    public ItMorphTag() {
        this.flexional_category_ = FlexionalCategory.Undef;
        this.mood_ = Mood.Undef;
        this.tense_ = Tense.Undef;
        this.participials_degree_ = ParticipialsDegree.Undef;
        this.case_number = CaseNumber.Undef;
        this.composition_ = Composition.Undef;
        this.formal_variation_ = FormalVariation.Undef;
        this.gender_number_person_ = GenderNumberPerson.Undef;
        this.graphical_variation_ = GraphicalVariation.Undef;
    }

    public static MorphTag parseString(String tag_string) {
        ItMorphTag tag = new ItMorphTag();
        String[] fields = tag_string.split("\\s+");
        assert (fields.length == 3);
        tag.readFlexionalType(fields[0]);
        tag.readFlexionalCategory(fields[1]);
        tag.readFeatures(fields[2]);
        return tag;
    }

    private void readFeatures(String string) {
        String[] features;
        for (String feature : features = string.split("\\|")) {
            this.readFeature(feature);
        }
    }

    private void readFeature(String feature) {
        String lower_feature = feature.toLowerCase();
        if (lower_feature.startsWith("cas")) {
            this.case_number = this.caseFeatureToString(feature.substring(3));
        } else if (lower_feature.startsWith("gen")) {
            this.gender_number_person_ = this.genderFeatureToString(feature.substring(3));
        } else if (lower_feature.startsWith("vgr")) {
            this.graphical_variation_ = this.graphicalVariationToString(feature.substring(3));
        } else if (!lower_feature.equals("_")) {
            if (lower_feature.startsWith("grn")) {
                this.nominals_degree_ = this.nominalsDegreeToString(feature.substring(3));
            } else if (lower_feature.startsWith("com")) {
                this.composition_ = this.compositionToString(feature.substring(3));
            } else if (lower_feature.startsWith("var")) {
                this.formal_variation_ = this.formalVariationToString(feature.substring(3));
            } else if (lower_feature.startsWith("tem")) {
                this.tense_ = this.tenseToString(feature.substring(3));
            } else if (lower_feature.startsWith("mod")) {
                this.mood_ = this.moodToString(feature.substring(3));
            } else if (lower_feature.startsWith("grp")) {
                this.participials_degree_ = this.participialsDegreeToString(feature.substring(3));
            } else {
                throw new RuntimeException("Unknown feature: " + feature);
            }
        }
    }

    private ParticipialsDegree participialsDegreeToString(String string) {
        switch (string) {
            case "1": {
                return ParticipialsDegree.One;
            }
            case "2": {
                return ParticipialsDegree.Two;
            }
            case "3": {
                return ParticipialsDegree.Three;
            }
            case ".": {
                return ParticipialsDegree.Undef;
            }
        }
        if (VERBOSE) {
            System.err.println("Unknown participals degree value: " + string);
        }
        return ParticipialsDegree.Undef;
    }

    private Mood moodToString(String string) {
        try {
            return Mood.valueOf(string.toUpperCase());
        }
        catch (RuntimeException e) {
            if (string.equalsIgnoreCase(".")) {
                return Mood.Undef;
            }
            if (VERBOSE) {
                System.err.println("Unknown mood value: " + string);
            }
            return Mood.Undef;
        }
    }

    private Tense tenseToString(String string) {
        switch (string) {
            case "1": {
                return Tense.One;
            }
            case "2": {
                return Tense.Two;
            }
            case "3": {
                return Tense.Three;
            }
            case "4": {
                return Tense.Four;
            }
            case "5": {
                return Tense.Five;
            }
            case "6": {
                return Tense.Six;
            }
            case ".": {
                return Tense.Undef;
            }
        }
        if (VERBOSE) {
            System.err.println("Unknown tense value: " + string);
        }
        return Tense.Undef;
    }

    private FormalVariation formalVariationToString(String string) {
        try {
            return FormalVariation.valueOf(string.toUpperCase());
        }
        catch (RuntimeException e) {
            if (string.equalsIgnoreCase(".")) {
                return FormalVariation.Undef;
            }
            if (VERBOSE) {
                System.err.println("Unknown formal variation value: " + string);
            }
            return FormalVariation.Undef;
        }
    }

    private Composition compositionToString(String string) {
        try {
            return Composition.valueOf(string.toUpperCase());
        }
        catch (RuntimeException e) {
            if (string.equalsIgnoreCase(".")) {
                return Composition.Undef;
            }
            if (VERBOSE) {
                System.err.println("Unknown composition value: " + string);
            }
            return Composition.Undef;
        }
    }

    private NominalsDegree nominalsDegreeToString(String string) {
        switch (string) {
            case "1": {
                return NominalsDegree.One;
            }
            case "2": {
                return NominalsDegree.Two;
            }
            case "3": {
                return NominalsDegree.Three;
            }
            case "4": {
                return NominalsDegree.Four;
            }
            case ".": {
                return NominalsDegree.Undef;
            }
        }
        if (VERBOSE) {
            System.err.println("Unknown nominals degree: " + string);
        }
        return NominalsDegree.Undef;
    }

    private GraphicalVariation graphicalVariationToString(String string) {
        switch (string) {
            case "1": {
                return GraphicalVariation.One;
            }
            case "2": {
                return GraphicalVariation.Two;
            }
            case "3": {
                return GraphicalVariation.Three;
            }
            case "4": {
                return GraphicalVariation.Four;
            }
            case ".": {
                return GraphicalVariation.Undef;
            }
        }
        if (VERBOSE) {
            System.err.println("Unknown graphical variation value: " + string);
        }
        return GraphicalVariation.Undef;
    }

    private GenderNumberPerson genderFeatureToString(String string) {
        switch (string) {
            case "1": {
                return GenderNumberPerson.One;
            }
            case "2": {
                return GenderNumberPerson.Two;
            }
            case "3": {
                return GenderNumberPerson.Three;
            }
            case "4": {
                return GenderNumberPerson.Four;
            }
            case "5": {
                return GenderNumberPerson.Five;
            }
            case "6": {
                return GenderNumberPerson.Six;
            }
            case "7": {
                return GenderNumberPerson.Seven;
            }
            case "8": {
                return GenderNumberPerson.Eight;
            }
            case "9": {
                return GenderNumberPerson.Nine;
            }
            case ".": {
                return GenderNumberPerson.Undef;
            }
        }
        if (VERBOSE) {
            System.err.println("Unknown gender value: " + string);
        }
        return GenderNumberPerson.Undef;
    }

    private CaseNumber caseFeatureToString(String case_feature) {
        try {
            return CaseNumber.valueOf(case_feature.toUpperCase());
        }
        catch (RuntimeException e) {
            if (case_feature.equalsIgnoreCase(".")) {
                return CaseNumber.Undef;
            }
            if (VERBOSE) {
                System.err.println("Unknown case value: " + case_feature);
            }
            return CaseNumber.Undef;
        }
    }

    private void readFlexionalCategory(String string) {
        if (string.equals("-")) {
            assert (this.flexional_type_ == FlexionalType.Undef);
            this.flexional_category_ = FlexionalCategory.Undef;
        } else if (string.equalsIgnoreCase("Punc")) {
            assert (this.flexional_type_ == FlexionalType.Punc);
            this.flexional_category_ = FlexionalCategory.Punc;
        } else if (string.length() == 1) {
            FlexionalType type = ItMorphTag.stringToFlexionalType(string);
            assert (type == this.flexional_type_);
            this.flexional_category_ = FlexionalCategory.Undef;
        } else if (string.length() == 2) {
            assert (ItMorphTag.stringToFlexionalType(Character.toString(string.charAt(1))) == this.flexional_type_);
            this.flexional_category_ = this.charToFlexionalCategory(string.charAt(0));
        } else {
            if (VERBOSE) {
                System.err.println("Unknown flexional category value: " + string);
            }
            this.flexional_category_ = FlexionalCategory.Undef;
        }
    }

    private FlexionalCategory charToFlexionalCategory(char c) {
        try {
            return FlexionalCategory.valueOf(Character.toString(c).toUpperCase());
        }
        catch (RuntimeException e) {
            throw new RuntimeException("Unkown value: " + c);
        }
    }

    public static FlexionalType stringToFlexionalType(String string) {
        FlexionalType flexional_type;
        if (string.equals("1")) {
            flexional_type = FlexionalType.One;
        } else if (string.equals("2")) {
            flexional_type = FlexionalType.Two;
        } else if (string.equals("3")) {
            flexional_type = FlexionalType.Three;
        } else if (string.equals("4")) {
            flexional_type = FlexionalType.Four;
        } else if (string.equals("5")) {
            flexional_type = FlexionalType.Five;
        } else if (string.equals("-")) {
            flexional_type = FlexionalType.Undef;
        } else if (string.equalsIgnoreCase("Punc")) {
            flexional_type = FlexionalType.Punc;
        } else {
            if (VERBOSE) {
                System.err.println("Unkown flexional type value: " + string);
            }
            flexional_type = FlexionalType.Undef;
        }
        return flexional_type;
    }

    private void readFlexionalType(String string) {
        this.flexional_type_ = ItMorphTag.stringToFlexionalType(string);
    }

    @Override
    public String toHumanMorphString() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String toPosString() {
        throw new UnsupportedOperationException();
    }

    public static enum FlexionalType {
        One,
        Two,
        Three,
        Four,
        Five,
        Undef,
        Punc;

    }

    public static enum NominalsDegree {
        One,
        Two,
        Three,
        Four,
        Undef;

    }

    public static enum FlexionalCategory {
        A,
        B,
        C,
        D,
        E,
        F,
        G,
        J,
        K,
        L,
        M,
        N,
        O,
        S,
        Punc,
        Undef;

    }

    public static enum Mood {
        A,
        J,
        B,
        K,
        C,
        L,
        D,
        M,
        E,
        N,
        O,
        G,
        P,
        H,
        Q,
        Undef;

    }

    public static enum Tense {
        One,
        Two,
        Three,
        Four,
        Five,
        Six,
        Undef;

    }

    public static enum ParticipialsDegree {
        One,
        Two,
        Three,
        Undef;

    }

    public static enum CaseNumber {
        A,
        J,
        B,
        K,
        C,
        L,
        D,
        M,
        E,
        N,
        F,
        O,
        G,
        H,
        Undef;

    }

    public static enum Composition {
        A,
        C,
        M,
        N,
        Q,
        T,
        V,
        H,
        Z,
        W,
        Undef;

    }

    public static enum FormalVariation {
        A,
        B,
        C,
        X,
        Undef;

    }

    public static enum GenderNumberPerson {
        One,
        Two,
        Three,
        Four,
        Five,
        Six,
        Seven,
        Eight,
        Nine,
        Undef;

    }

    static enum GraphicalVariation {
        One,
        Two,
        Three,
        Undef,
        Four;

    }
}

