/*
 * Decompiled with CFR 0.152.
 */
package marmot.test.util;

import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import marmot.util.ListUtils;
import org.junit.Assert;
import org.junit.Test;

public class ListUtilsTest {
    @Test
    public void complementTest() {
        LinkedList items = new LinkedList();
        items.add(Arrays.asList(1, 2));
        items.add(Arrays.asList(3, 4));
        items.add(Arrays.asList(5, 6));
        items.add(Arrays.asList(7, 8));
        List<Integer> expected = Arrays.asList(1, 2, 3, 4, 7, 8);
        List actual = ListUtils.complement(items, 2);
        Assert.assertEquals(expected, actual);
        expected = Arrays.asList(1, 2, 3, 4, 5, 6, 7, 8);
        actual = ListUtils.complement(items, 4);
        Assert.assertEquals(expected, actual);
        actual = ListUtils.complement(items, -1);
        Assert.assertEquals(expected, actual);
    }

    @Test
    public void chunkTest() {
        List<Integer> items = Arrays.asList(1, 2, 3, 4, 5, 6, 7, 8);
        List<List<Integer>> expected = new LinkedList<List<Integer>>();
        expected.add(Arrays.asList(1, 2));
        expected.add(Arrays.asList(3, 4));
        expected.add(Arrays.asList(5, 6));
        expected.add(Arrays.asList(7, 8));
        List<List<Integer>> actual = ListUtils.chunk(items, 4);
        Assert.assertEquals(expected, actual);
        expected = new LinkedList();
        expected.add(Arrays.asList(1));
        expected.add(Arrays.asList(2));
        expected.add(Arrays.asList(3));
        expected.add(Arrays.asList(4));
        expected.add(Arrays.asList(5, 6, 7, 8));
        actual = ListUtils.chunk(items, 5);
        Assert.assertEquals(expected, actual);
        expected = new LinkedList();
        expected.add(Arrays.asList(1));
        expected.add(Arrays.asList(2));
        expected.add(Arrays.asList(3));
        expected.add(Arrays.asList(4));
        expected.add(Arrays.asList(5));
        expected.add(Arrays.asList(6));
        expected.add(Arrays.asList(7));
        expected.add(Arrays.asList(8));
        actual = ListUtils.chunk(items, 8);
        Assert.assertEquals(expected, actual);
        expected = new LinkedList();
        expected.add(Arrays.asList(1));
        expected.add(Arrays.asList(2));
        expected.add(Arrays.asList(3));
        expected.add(Arrays.asList(4));
        expected.add(Arrays.asList(5));
        expected.add(Arrays.asList(6));
        expected.add(Arrays.asList(7));
        expected.add(Arrays.asList(8));
        actual = ListUtils.chunk(items, 9);
        Assert.assertEquals(expected, actual);
        expected = Collections.singletonList(items);
        actual = ListUtils.chunk(items, 1);
        Assert.assertEquals(expected, actual);
    }
}

