/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.bytecode;

import com.saxonica.ee.bytecode.ToPushCompiler;
import com.saxonica.ee.bytecode.util.CannotCompileException;
import com.saxonica.ee.bytecode.util.CompilerService;
import com.saxonica.ee.bytecode.util.GeneratedMethodInfo;
import com.saxonica.ee.bytecode.util.Generator;
import com.saxonica.ee.bytecode.util.LabelInfo;
import com.saxonica.objectweb.asm.Type;
import net.sf.saxon.Configuration;
import net.sf.saxon.Controller;
import net.sf.saxon.event.Builder;
import net.sf.saxon.event.ComplexContentOutputter;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.SequenceOutputter;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.instruct.DocumentInstr;
import net.sf.saxon.expr.parser.Location;
import net.sf.saxon.lib.ParseOptions;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.tree.iter.EmptyIterator;
import net.sf.saxon.tree.iter.SingletonIterator;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.TextFragmentValue;

public class DocumentInstrCompiler
extends ToPushCompiler {
    @Override
    public void compileToPush(CompilerService compiler, Expression expression) throws CannotCompileException {
        Configuration config = compiler.getConfiguration();
        TypeHierarchy th = config.getTypeHierarchy();
        Generator ga = compiler.getCurrentGenerator();
        GeneratedMethodInfo methodInfo = compiler.getCurrentMethod();
        DocumentInstrCompiler.visitAnnotation(compiler, "DocumentInstrCompiler-Push");
        DocumentInstrCompiler.visitLineNumber(compiler, ga, expression);
        DocumentInstr instr = (DocumentInstr)expression;
        if (instr.isPreservingTypes() && !instr.isTextOnly()) {
            compiler.generateGetReceiver();
            ga.push(0);
            ga.invokeInstanceMethod(Receiver.class, "startDocument", Integer.TYPE);
            compiler.compileToPush(instr.getContentExpression());
            compiler.generateGetReceiver();
            ga.invokeInstanceMethod(Receiver.class, "endDocument", new Class[0]);
        } else {
            LabelInfo nonNull = methodInfo.newLabel("docNonNull");
            LabelInfo docDone = methodInfo.newLabel("docDone");
            this.compileToItem(compiler, instr);
            ga.dup();
            ga.ifNonNull(nonNull.label());
            ga.pop();
            ga.goTo(docDone);
            methodInfo.placeLabel(nonNull);
            compiler.generateGetReceiver();
            ga.swap();
            DocumentInstrCompiler.allocateStatic(compiler, instr.getLocation());
            ga.push(524288);
            ga.invokeInstanceMethod(Receiver.class, "append", Item.class, Location.class, Integer.TYPE);
            methodInfo.placeLabel(docDone);
        }
    }

    @Override
    public void compileToItem(CompilerService compiler, Expression expression) throws CannotCompileException {
        Configuration config = compiler.getConfiguration();
        TypeHierarchy th = config.getTypeHierarchy();
        Generator ga = compiler.getCurrentGenerator();
        GeneratedMethodInfo methodInfo = compiler.getCurrentMethod();
        DocumentInstrCompiler.visitAnnotation(compiler, "DocumentInstrCompiler-Item");
        DocumentInstrCompiler.visitLineNumber(compiler, ga, expression);
        DocumentInstr instr = (DocumentInstr)expression;
        if (instr.isTextOnly()) {
            ga.newInstance(TextFragmentValue.class);
            ga.dup();
            DocumentInstrCompiler.allocateStatic(compiler, compiler.getConfiguration());
            if (instr.getConstantText() != null) {
                ga.push(instr.getConstantText().toString());
            } else {
                int fsbVar = methodInfo.allocateLocal(FastStringBuffer.class);
                int iterVar = methodInfo.allocateLocal(SequenceIterator.class);
                ga.newInstance(FastStringBuffer.class);
                ga.dup();
                ga.push(64);
                ga.invokeConstructor(FastStringBuffer.class, Integer.TYPE);
                ga.storeLocal(fsbVar);
                compiler.compileToIterator(instr.getContentExpression());
                ga.storeLocal(iterVar);
                LabelInfo loopDone = methodInfo.newLabel("docLoopDone");
                LabelInfo loop = methodInfo.placeNewLabel("docLoop");
                ga.loadLocal(iterVar);
                ga.invokeInstanceMethod(SequenceIterator.class, "next", new Class[0]);
                ga.dup();
                ga.ifNull(loopDone.label());
                ga.invokeInstanceMethod(Item.class, "getStringValueCS", new Class[0]);
                ga.loadLocal(fsbVar);
                ga.swap();
                ga.invokeInstanceMethod(FastStringBuffer.class, "append", CharSequence.class);
                ga.goTo(loop);
                methodInfo.placeLabel(loopDone);
                ga.pop();
                ga.loadLocal(fsbVar);
                ga.invokeInstanceMethod(FastStringBuffer.class, "condense", new Class[0]);
                methodInfo.releaseLocal(fsbVar);
                methodInfo.releaseLocal(iterVar);
            }
            ga.push(instr.getStaticBaseURIString());
            ga.invokeConstructor(TextFragmentValue.class, Configuration.class, CharSequence.class, String.class);
        } else {
            compiler.generateGetContext();
            ga.invokeInstanceMethod(XPathContext.class, "getController", new Class[0]);
            ga.invokeInstanceMethod(Controller.class, "makeBuilder", new Class[0]);
            ga.dup();
            ga.push(false);
            ga.invokeInstanceMethod(Builder.class, "setUseEventLocation", Boolean.TYPE);
            ga.dup();
            ga.push(instr.getStaticBaseURIString());
            ga.invokeInstanceMethod(Builder.class, "setBaseURI", String.class);
            ga.dup();
            ga.push(false);
            ga.invokeInstanceMethod(Builder.class, "setTiming", Boolean.TYPE);
            ga.dup();
            compiler.generateGetContext();
            ga.invokeInstanceMethod(XPathContext.class, "getController", new Class[0]);
            ga.invokeInstanceMethod(Controller.class, "makePipelineConfiguration", new Class[0]);
            ga.dup();
            ga.push(instr.getPackageData().getHostLanguage());
            ga.invokeInstanceMethod(PipelineConfiguration.class, "setHostLanguage", Integer.TYPE);
            ga.invokeInstanceMethod(Receiver.class, "setPipelineConfiguration", PipelineConfiguration.class);
            ga.dup();
            DocumentInstrCompiler.allocateStatic(compiler, instr.getValidationOptions());
            ga.invokeStaticMethod(ComplexContentOutputter.class, "makeComplexContentReceiver", Receiver.class, ParseOptions.class);
            compiler.generateGetContext();
            ga.swap();
            ga.invokeInstanceMethod(XPathContext.class, "setReceiver", Receiver.class);
            compiler.generateGetContext();
            ga.invokeInstanceMethod(XPathContext.class, "getReceiver", new Class[0]);
            compiler.pushNewReceiverInfo(ga);
            compiler.generateGetReceiver();
            ga.invokeInstanceMethod(Receiver.class, "open", new Class[0]);
            compiler.generateGetReceiver();
            ga.push(0);
            ga.invokeInstanceMethod(Receiver.class, "startDocument", Integer.TYPE);
            compiler.compileToPush(instr.getContentExpression());
            compiler.generateGetReceiver();
            ga.invokeInstanceMethod(Receiver.class, "endDocument", new Class[0]);
            compiler.generateGetReceiver();
            ga.invokeInstanceMethod(Receiver.class, "close", new Class[0]);
            compiler.popReceiverInfo();
            ga.invokeInstanceMethod(Builder.class, "getCurrentRoot", new Class[0]);
        }
    }

    @Override
    public void compileToIterator(CompilerService compiler, Expression expression) throws CannotCompileException {
        Generator ga = compiler.getCurrentGenerator();
        GeneratedMethodInfo methodInfo = compiler.getCurrentMethod();
        DocumentInstr documentInstr = (DocumentInstr)expression;
        DocumentInstrCompiler.visitAnnotation(compiler, "DocumentInstrCompiler-Iter");
        int m = documentInstr.getImplementationMethod();
        LabelInfo notNull = methodInfo.newLabel("notNullDocInstr");
        LabelInfo end = methodInfo.newLabel("endDocInstr");
        if ((m & 1) != 0) {
            this.compileToItem(compiler, expression);
            ga.dup();
            ga.ifNonNull(notNull.label());
            ga.pop();
            ga.invokeStaticMethod(EmptyIterator.class, "emptyIterator", new Class[0]);
            ga.goTo(end);
            methodInfo.placeLabel(notNull);
            ga.invokeStaticMethod(SingletonIterator.class, "makeIterator", Item.class);
            methodInfo.placeLabel(end);
        } else if ((m & 2) != 0) {
            ga.throwException(Type.getType(AssertionError.class), "iterate() is not implemented in the subclass ");
        } else {
            compiler.generateGetContext();
            ga.invokeInstanceMethod(XPathContext.class, "getController", new Class[0]);
            ga.invokeInstanceMethod(Controller.class, "allocateSequenceOutputter", new Class[0]);
            int seqReceiverVar = methodInfo.allocateLocal(SequenceOutputter.class);
            ga.storeLocal(seqReceiverVar);
            ga.loadLocal(seqReceiverVar);
            ga.invokeInstanceMethod(SequenceOutputter.class, "getPipelineConfiguration", new Class[0]);
            ga.push(documentInstr.getPackageData().getHostLanguage());
            ga.invokeInstanceMethod(PipelineConfiguration.class, "setHostLanguage", Integer.TYPE);
            ga.loadLocal(seqReceiverVar);
            compiler.pushNewReceiverInfo(ga);
            this.compileToPush(compiler, documentInstr.getContentExpression());
            compiler.popReceiverInfo();
            ga.loadLocal(seqReceiverVar);
            ga.invokeInstanceMethod(SequenceOutputter.class, "close", new Class[0]);
            ga.invokeInstanceMethod(SequenceOutputter.class, "iterate", new Class[0]);
        }
    }
}

