/*
 * Decompiled with CFR 0.152.
 */
package de.ids_mannheim.korap;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.ids_mannheim.korap.KrillCollection;
import de.ids_mannheim.korap.KrillIndex;
import de.ids_mannheim.korap.KrillMeta;
import de.ids_mannheim.korap.KrillQuery;
import de.ids_mannheim.korap.cache.VirtualCorpusCache;
import de.ids_mannheim.korap.query.wrap.SpanQueryWrapper;
import de.ids_mannheim.korap.response.Response;
import de.ids_mannheim.korap.response.Result;
import de.ids_mannheim.korap.response.VirtualCorpusResponse;
import de.ids_mannheim.korap.util.QueryException;
import java.io.IOException;
import java.util.List;
import org.apache.lucene.search.spans.SpanQuery;

public class Krill
extends Response {
    private KrillIndex index;
    private SpanQuery spanQuery;
    private JsonNode request;
    private int maxTokenMatchSize;
    private final ObjectMapper mapper = new ObjectMapper();

    public Krill() {
    }

    public Krill(String query) {
        this.fromKoral(query);
    }

    public Krill(JsonNode query) {
        this.fromKoral(query);
    }

    public Krill(SpanQueryWrapper query) {
        try {
            this.spanQuery = query.toQuery();
        }
        catch (QueryException q) {
            this.addError(q.getErrorCode(), q.getMessage(), new String[0]);
        }
    }

    public Krill(SpanQuery query) {
        this.spanQuery = query;
    }

    public Krill fromKoral(String query) {
        try {
            this.request = this.mapper.readTree(query);
            this.fromKoral(this.request);
        }
        catch (IOException e) {
            this.addError(621, "Unable to parse JSON", new String[0]);
        }
        return this;
    }

    public Krill fromKoral(JsonNode json) {
        if (json.has("query")) {
            try {
                KrillQuery kq = new KrillQuery("tokens");
                this.setQuery(kq);
                SpanQueryWrapper qw = kq.fromKoral(json.get("query"));
                this.moveNotificationsFrom(kq);
                if (qw.isEmpty()) {
                    this.addError(780, "This query matches everywhere", new String[0]);
                } else if (qw.isNull()) {
                    this.addError(783, "This query can't match anywhere", new String[0]);
                } else {
                    this.spanQuery = qw.toQuery();
                    if (qw.isOptional()) {
                        this.addWarning(781, "Optionality of query is ignored", new String[0]);
                    }
                    if (qw.isNegative()) {
                        this.addWarning(782, "Exclusivity of query is ignored", new String[0]);
                    }
                }
            }
            catch (QueryException q) {
                this.addError(q.getErrorCode(), q.getMessage(), new String[0]);
            }
        } else {
            this.addError(700, "No query given", new String[0]);
        }
        if (json.has("warning") && json.get("warning").asText().length() > 0) {
            this.addWarning(799, json.get("warning").asText(), new String[0]);
        }
        this.copyNotificationsFrom(json);
        try {
            if (json.has("corpus")) {
                collNode = json.get("corpus");
                if (collNode.fieldNames().hasNext()) {
                    this.setCollection(new KrillCollection().fromKoral(collNode));
                }
            } else if (json.has("collection")) {
                collNode = json.get("collection");
                if (collNode.fieldNames().hasNext()) {
                    this.setCollection(new KrillCollection().fromKoral(collNode));
                }
            } else if (json.has("collections")) {
                this.addError(899, "Collections are not supported anymore in favour of a single collection", new String[0]);
            }
        }
        catch (QueryException q) {
            this.addError(q.getErrorCode(), q.getMessage(), new String[0]);
        }
        if (json.has("meta")) {
            this.setMeta(new KrillMeta(json.get("meta")));
        }
        return this;
    }

    public KrillIndex getIndex() {
        return this.index;
    }

    public Krill setIndex(KrillIndex index) {
        this.index = index;
        VirtualCorpusCache.setIndexInfo(index);
        return this;
    }

    public Result apply(KrillIndex index) {
        VirtualCorpusCache.setIndexInfo(index);
        return this.setIndex(index).apply();
    }

    public Result apply() {
        Result kr = new Result();
        if (this.hasErrors()) {
            kr.copyNotificationsFrom(this);
        } else if (this.index == null) {
            kr.addError(601, "Unable to find index", new String[0]);
        } else {
            kr = this.index.search(this);
            kr.copyNotificationsFrom(this);
        }
        kr.setQuery(this.getQuery());
        kr.setCollection(this.getCollection());
        kr.setMeta(this.getMeta());
        return kr;
    }

    @Deprecated
    public SpanQuery getSpanQuery() {
        return this.spanQuery;
    }

    public void setSpanQuery(SpanQuery sq) {
        this.spanQuery = sq;
    }

    public JsonNode retrieveFieldValues(String corpusQuery, KrillIndex index, String fieldName) {
        KrillCollection kc = new KrillCollection(corpusQuery);
        List<String> fieldValues = index.getFieldVector(fieldName, kc);
        VirtualCorpusResponse r = new VirtualCorpusResponse();
        return r.createKoralQueryForField(fieldName, fieldValues);
    }

    public int getMaxTokenMatchSize() {
        return this.maxTokenMatchSize;
    }

    public void setMaxTokenMatchSize(int maxMatchTokens) {
        this.maxTokenMatchSize = maxMatchTokens;
    }
}

