/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.domino;

import com.saxonica.ee.domino.DominoNode;
import com.saxonica.ee.domino.DominoTree;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.tree.iter.AxisIterator;
import net.sf.saxon.z.IntPredicateProxy;

final class DescendantIterator
implements AxisIterator {
    private final DominoTree tree;
    private final DominoNode startNode;
    private int nextNodeNr;
    private final int startDepth;
    private final NodeTest test;
    private final IntPredicateProxy matcher;

    DescendantIterator(DominoTree doc, DominoNode node, NodeTest nodeTest) {
        this.tree = doc;
        this.startNode = node;
        this.test = nodeTest;
        this.nextNodeNr = node.getNodeNr();
        this.startDepth = doc.depth[this.nextNodeNr];
        this.matcher = this.test.getMatcher(doc);
    }

    @Override
    public NodeInfo next() {
        do {
            ++this.nextNodeNr;
            try {
                if (this.tree.depth[this.nextNodeNr] <= this.startDepth) {
                    this.nextNodeNr = -1;
                    return null;
                }
            }
            catch (ArrayIndexOutOfBoundsException e) {
                this.nextNodeNr = -1;
                return null;
            }
        } while (!this.matcher.test(this.nextNodeNr));
        return this.tree.getNode(this.nextNodeNr);
    }
}

