/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.parallel;

import com.saxonica.ee.config.MultithreadingFactory;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import net.sf.saxon.expr.ItemMappingFunction;
import net.sf.saxon.expr.ItemMappingIterator;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trans.UncheckedXPathException;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.ObjectValue;

public class MultithreadedItemMappingIterator
extends ItemMappingIterator {
    private ExecutorService service;
    private BlockingQueue<Future<Item>> resultQueue = new LinkedBlockingQueue<Future<Item>>();
    private SequenceIterator dischargedIterator = null;

    public MultithreadedItemMappingIterator(SequenceIterator base, ItemMappingFunction action, MultithreadingFactory factory) throws XPathException {
        super(base, action);
        int maxThreads = this.getMaxThreads();
        this.service = factory.makeExecutorService(maxThreads);
        int n = 0;
        int prime = maxThreads * 3;
        try {
            while (++n < prime) {
                Item item = base.next();
                if (item == null) {
                    return;
                }
                this.mapOneItem(item);
            }
        }
        catch (UncheckedXPathException e) {
            this.close();
            throw e.getXPathException();
        }
    }

    protected int getMaxThreads() {
        int maxThreads = Runtime.getRuntime().availableProcessors();
        return maxThreads > 0 ? maxThreads : 1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Item next() {
        if (this.dischargedIterator != null) {
            return this.dischargedIterator.next();
        }
        while (true) {
            Item nextIn = this.getBaseIterator().next();
            try {
                Future future;
                if (nextIn != null) {
                    this.mapOneItem(nextIn);
                }
                if ((future = (Future)this.resultQueue.poll()) == null) {
                    this.service.shutdown();
                    return null;
                }
                Item result = (Item)future.get();
                if (result instanceof NullItem) continue;
                return result;
            }
            catch (InterruptedException e) {
                throw new UncheckedXPathException(new XPathException(e));
            }
            catch (ExecutionException | RejectedExecutionException e) {
                if (e.getCause() instanceof XPathException) {
                    throw new UncheckedXPathException((XPathException)e.getCause());
                }
                if (!e.getMessage().contains("Shutting down")) throw new UncheckedXPathException(new XPathException(e));
                continue;
            }
            break;
        }
    }

    @Override
    public void close() {
        super.close();
        this.getBaseIterator().close();
        this.service.shutdown();
    }

    private void mapOneItem(Item in) {
        ItemMappingFunction action = this.getMappingFunction();
        Future<Item> future = this.service.submit(() -> {
            try {
                Item out = action.mapItem(in);
                if (out == null) {
                    return new NullItem(true);
                }
                return out;
            }
            catch (UncheckedXPathException e) {
                this.service.shutdown();
                throw e.getXPathException();
            }
            catch (XPathException e) {
                this.service.shutdown();
                throw e;
            }
        });
        this.resultQueue.add(future);
    }

    private static class NullItem
    extends ObjectValue<Boolean> {
        public NullItem(Boolean success) {
            super(success);
        }
    }
}

