/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.tokenize;

import java.io.IOException;
import opennlp.tools.commons.ThreadSafe;
import opennlp.tools.dictionary.Dictionary;
import opennlp.tools.tokenize.Tokenizer;
import opennlp.tools.tokenize.TokenizerME;
import opennlp.tools.tokenize.TokenizerModel;
import opennlp.tools.util.DownloadUtil;
import opennlp.tools.util.Span;

@ThreadSafe
public class ThreadSafeTokenizerME
implements Tokenizer,
AutoCloseable {
    private final TokenizerModel model;
    private final Dictionary abbDict;
    private final ThreadLocal<TokenizerME> threadLocal = new ThreadLocal();

    public ThreadSafeTokenizerME(String language) throws IOException {
        this(DownloadUtil.downloadModel(language, DownloadUtil.ModelType.TOKENIZER, TokenizerModel.class));
    }

    public ThreadSafeTokenizerME(TokenizerModel model) {
        this(model, model.getAbbreviations());
    }

    public ThreadSafeTokenizerME(TokenizerModel model, Dictionary abbDict) {
        this.model = model;
        this.abbDict = abbDict;
    }

    private TokenizerME getTokenizer() {
        TokenizerME tokenizer = this.threadLocal.get();
        if (tokenizer == null) {
            tokenizer = new TokenizerME(this.model, this.abbDict);
            this.threadLocal.set(tokenizer);
        }
        return tokenizer;
    }

    @Override
    public String[] tokenize(String s2) {
        return this.getTokenizer().tokenize(s2);
    }

    @Override
    public Span[] tokenizePos(String s2) {
        return this.getTokenizer().tokenizePos(s2);
    }

    public double[] getProbabilities() {
        return this.getTokenizer().getTokenProbabilities();
    }

    @Override
    public void close() {
        this.threadLocal.remove();
    }
}

