/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.schema;

import com.saxonica.ee.schema.Facet;
import com.saxonica.ee.schema.SchemaCompiler;
import com.saxonica.ee.schema.UserAtomicType;
import com.saxonica.ee.schema.UserSimpleType;
import net.sf.saxon.lib.ConversionRules;
import net.sf.saxon.om.AtomicSequence;
import net.sf.saxon.om.FunctionItem;
import net.sf.saxon.om.NamespaceResolver;
import net.sf.saxon.str.StringView;
import net.sf.saxon.str.UnicodeString;
import net.sf.saxon.trans.Err;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.MissingComponentException;
import net.sf.saxon.type.SchemaException;
import net.sf.saxon.type.SimpleType;
import net.sf.saxon.type.ValidationFailure;
import net.sf.saxon.value.AtomicValue;

public class EnumerationFacet
extends Facet {
    private UnicodeString value;
    private AtomicSequence typedValue;
    NamespaceResolver namespaceContext = null;

    @Override
    public String getName() {
        return "enumeration";
    }

    @Override
    public UnicodeString getValue() {
        return this.value;
    }

    public NamespaceResolver getNamespaceContext() {
        return this.namespaceContext;
    }

    public void setValue(String value) {
        this.value = StringView.of(value).tidy();
    }

    public AtomicSequence getTypedValue(SimpleType type, ConversionRules rules) throws SchemaException, MissingComponentException {
        if (this.typedValue != null) {
            return this.typedValue;
        }
        try {
            this.typedValue = type.getTypedValue(this.getValue(), this.namespaceContext, rules);
            return this.typedValue;
        }
        catch (XPathException e) {
            throw new SchemaException(e);
        }
    }

    @Override
    public void checkFacetRestriction(UserSimpleType type, SimpleType base, SchemaCompiler compiler) throws SchemaException, MissingComponentException {
        ConversionRules rules = type.getConfiguration().getConversionRules();
        rules = rules.copy();
        rules.setNotationSet(compiler.getPreparedSchema());
        if (base instanceof UserAtomicType) {
            this.getTypedValue(base, rules);
        } else {
            if (this.namespaceContext == null && base.isNamespaceSensitive()) {
                throw new SchemaException("No namespace context available for checking enumeration QName");
            }
            ValidationFailure err = base.validateContent(this.getValue(), this.namespaceContext, rules);
            if (err != null) {
                throw new SchemaException("Enumeration value " + Err.wrap(this.value) + " is not permitted by the base type " + base.getDescription() + ": " + err.getMessage());
            }
        }
    }

    public void setNamespaceContext(NamespaceResolver map) {
        this.namespaceContext = map;
    }

    @Override
    public boolean testAtomicValue(AtomicValue value) {
        return true;
    }

    @Override
    public FunctionItem getFacetAsFunctionItem() {
        throw new UnsupportedOperationException();
    }
}

