/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.stream.adjunct;

import com.saxonica.ee.stream.ComponentInversion;
import com.saxonica.ee.stream.Posture;
import com.saxonica.ee.stream.PostureAndSweep;
import com.saxonica.ee.stream.Streamability;
import com.saxonica.ee.stream.StreamableUserFunction;
import com.saxonica.ee.stream.StreamingPatternMaker;
import com.saxonica.ee.stream.adjunct.TransmissionAdjunct;
import com.saxonica.ee.stream.feed.ItemFeed;
import com.saxonica.ee.stream.om.FleetingParentNode;
import com.saxonica.ee.stream.watch.Terminator;
import com.saxonica.ee.stream.watch.Trigger;
import com.saxonica.ee.stream.watch.Watch;
import com.saxonica.ee.stream.watch.WatchMaker;
import com.saxonica.ee.stream.watch.WatchManager;
import com.saxonica.ee.trans.ContextItemStaticInfoEE;
import java.util.ArrayList;
import java.util.List;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.expr.Component;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Operand;
import net.sf.saxon.expr.OperandUsage;
import net.sf.saxon.expr.UserFunctionCall;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMajor;
import net.sf.saxon.expr.instruct.UserFunction;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.pattern.Pattern;
import net.sf.saxon.s9api.Location;
import net.sf.saxon.trans.XPathException;

public class AbsorbingFunctionCallAdjunct
extends TransmissionAdjunct {
    @Override
    public PostureAndSweep computeStreamability(ContextItemStaticInfoEE contextInfo, List<String> reasons) {
        if (reasons == null) {
            reasons = new ArrayList<String>();
        }
        UserFunctionCall exp = (UserFunctionCall)this.getExpression();
        UserFunction target = exp.getFunction();
        Operand[] operanda = exp.getOperanda().copy();
        operanda[0].setUsage(OperandUsage.TRANSMISSION);
        for (int i = 1; i < operanda.length; ++i) {
            operanda[i].setUsage(Operand.typeDeterminedUsage(target.getArgumentType(i).getPrimaryType()));
        }
        PostureAndSweep first = Streamability.getStreamability(exp.getArg(0), contextInfo, reasons);
        if (first.getPosture() == Posture.CRAWLING) {
            reasons.add("The first argument to a function with streamability=absorbing must not have crawling posture");
            return PostureAndSweep.ROAMING_AND_FREE_RANGING;
        }
        operanda[0].setUsage(OperandUsage.ABSORPTION);
        return Streamability.generalStreamabilityRules(exp, exp.operands(), contextInfo, reasons);
    }

    @Override
    public WatchMaker getWatchMaker(boolean forGrouping) throws XPathException {
        UserFunctionCall instruction = (UserFunctionCall)this.getExpression();
        Expression select = instruction.getArg(0);
        Pattern selection = StreamingPatternMaker.makeStreamingPattern(select, this.getConfiguration(), null);
        if (selection != null) {
            return (watchManager, out, context) -> {
                AbsorbingFunctionCallAction action = new AbsorbingFunctionCallAction(this.getExpression(), out, context);
                action.setWatchManager(watchManager);
                return new Trigger(selection, action, context);
            };
        }
        return null;
    }

    @Override
    public ItemFeed makeItemFeed(WatchManager watchManager, ItemFeed out, XPathContext context) throws XPathException {
        AbsorbingFunctionCallAction feed = new AbsorbingFunctionCallAction(this.getExpression(), out, context);
        feed.setWatchManager(watchManager);
        return feed;
    }

    private static class AbsorbingFunctionCallAction
    extends ItemFeed {
        private XPathContextMajor localContext;
        private WatchManager watchManager;
        private StreamableUserFunction targetFunction;
        private Watch innerWatch;
        private boolean started;

        public AbsorbingFunctionCallAction(Expression functionCall, ItemFeed out, XPathContext context) {
            super(functionCall, out, context);
        }

        @Override
        public void open(Terminator terminator) throws XPathException {
            super.open(terminator);
            UserFunctionCall exp = (UserFunctionCall)this.getExpression();
            Component target = exp.getTargetComponent(this.getContext());
            this.targetFunction = (StreamableUserFunction)target.getActor();
            this.targetFunction.makeInversion();
            this.localContext = this.getContext().newContext();
            this.localContext.setCurrentComponent(target);
            Sequence[] args = exp.evaluateArguments(this.getContext(), true);
            this.localContext.setStackFrame(this.targetFunction.getStackFrameMap(), args);
            this.started = false;
        }

        public void setWatchManager(WatchManager watchManager) {
            this.watchManager = watchManager;
        }

        @Override
        public Receiver startSelectedParentNode(FleetingParentNode node, Location locationId) throws XPathException {
            XPathContextMajor context = this.localContext;
            context.setLocalVariable(0, node);
            boolean first = !this.started;
            this.start();
            this.innerWatch.setAnchorNode(node);
            if (first) {
                this.watchManager.addWatch(this.innerWatch, false);
            }
            return null;
        }

        private void start() throws XPathException {
            if (!this.started) {
                this.started = true;
                ComponentInversion inversion = this.targetFunction.getInversion();
                this.innerWatch = inversion.getWatch(this.watchManager, this.getResultFeed(), this.localContext);
                this.innerWatch.open(new Terminator());
            }
        }

        @Override
        public void append(Item item) throws XPathException {
            if (!this.hasFailed()) {
                XPathContextMajor context = this.localContext;
                context.setLocalVariable(0, item);
                this.start();
                ((Trigger)this.innerWatch).getAction().append(item);
            }
        }

        @Override
        public void endSelectedParentNode(Location locationId) throws XPathException {
        }

        @Override
        public void close() throws XPathException {
            this.start();
            this.innerWatch.close();
            this.watchManager.removeWatch(this.innerWatch);
        }
    }
}

