/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.stream.adjunct;

import com.saxonica.ee.stream.Inversion;
import com.saxonica.ee.stream.Posture;
import com.saxonica.ee.stream.PostureAndSweep;
import com.saxonica.ee.stream.Streamability;
import com.saxonica.ee.stream.StreamingPatternMaker;
import com.saxonica.ee.stream.Sweep;
import com.saxonica.ee.stream.adjunct.StreamingAdjunct;
import com.saxonica.ee.stream.adjunct.TransmissionAdjunct;
import com.saxonica.ee.stream.feed.BufferingForEachExpressionFeed;
import com.saxonica.ee.stream.feed.FeedMaker;
import com.saxonica.ee.stream.feed.ItemFeed;
import com.saxonica.ee.stream.watch.ForEachAction;
import com.saxonica.ee.stream.watch.Trigger;
import com.saxonica.ee.stream.watch.WatchMaker;
import com.saxonica.ee.stream.watch.WatchManager;
import com.saxonica.ee.trans.ContextItemStaticInfoEE;
import java.util.ArrayList;
import java.util.List;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.ContextItemExpression;
import net.sf.saxon.expr.ContextSwitchingExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.InstanceOfExpression;
import net.sf.saxon.expr.ItemChecker;
import net.sf.saxon.expr.LocalBinding;
import net.sf.saxon.expr.LocalVariableReference;
import net.sf.saxon.expr.RootExpression;
import net.sf.saxon.expr.SlashExpression;
import net.sf.saxon.expr.VariableReference;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.instruct.ForEach;
import net.sf.saxon.expr.instruct.UserFunctionParameter;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.sort.SortExpression;
import net.sf.saxon.functions.CurrentGroupCall;
import net.sf.saxon.pattern.AncestorQualifiedPattern;
import net.sf.saxon.pattern.AnchorPattern;
import net.sf.saxon.pattern.AnyNodeTest;
import net.sf.saxon.pattern.BasePatternWithPredicate;
import net.sf.saxon.pattern.DocumentNodeTest;
import net.sf.saxon.pattern.Pattern;
import net.sf.saxon.pattern.PatternMaker;
import net.sf.saxon.pattern.SimplePositionalPattern;
import net.sf.saxon.trans.FunctionStreamability;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.value.SequenceType;

public class ForEachAdjunct
extends TransmissionAdjunct
implements FeedMaker {
    private boolean isBuffering;
    Inversion actionInversion = null;

    @Override
    public void setExpression(Expression expression) {
        super.setExpression(expression);
        if (expression instanceof ForEach) {
            this.isBuffering = (((ForEach)this.getExpression()).getActionExpression().getDependencies() & 8) != 0;
        }
    }

    @Override
    public Pattern toStreamingPattern(Configuration config) {
        if (this.getExpression() instanceof SlashExpression) {
            int axis;
            Expression tail;
            Pattern tailPattern;
            SlashExpression exp = (SlashExpression)this.getExpression();
            Expression head = exp.getLeadingSteps();
            if (head instanceof RootExpression) {
                return null;
            }
            if (head instanceof CurrentGroupCall) {
                return null;
            }
            if (head instanceof LocalVariableReference) {
                FunctionStreamability fs;
                boolean fail = true;
                LocalBinding binding = ((LocalVariableReference)head).getBinding();
                if (binding instanceof UserFunctionParameter && ((fs = ((UserFunctionParameter)binding).getFunctionStreamability()) == FunctionStreamability.ABSORBING || fs == FunctionStreamability.SHALLOW_DESCENT)) {
                    fail = false;
                }
                if (fail) {
                    return null;
                }
            } else if (head instanceof VariableReference) {
                return null;
            }
            InstanceOfExpression headPredicate = null;
            if (head instanceof ItemChecker) {
                ItemType check = ((ItemChecker)head).getRequiredType();
                head = ((ItemChecker)head).getBaseExpression();
                if (!(check instanceof AnyNodeTest)) {
                    if (check instanceof DocumentNodeTest) {
                        return null;
                    }
                    headPredicate = new InstanceOfExpression(new ContextItemExpression(), SequenceType.makeSequenceType(check, 57344));
                    ExpressionTool.copyLocationInfo(exp, headPredicate);
                }
            }
            if ((tailPattern = Streamability.toStreamingPattern(tail = exp.getLastStep(), config)) instanceof AncestorQualifiedPattern && ((AncestorQualifiedPattern)tailPattern).getUpperPattern() instanceof AnchorPattern) {
                tailPattern = ((AncestorQualifiedPattern)tailPattern).getBasePattern();
            }
            try {
                axis = tailPattern instanceof SimplePositionalPattern ? 9 : PatternMaker.getAxisForPathStep(tail);
            }
            catch (XPathException e) {
                return null;
            }
            Pattern headPattern = Streamability.toStreamingPattern(head, config);
            if (headPattern == null || tailPattern == null) {
                return null;
            }
            if (headPredicate != null) {
                headPattern = new BasePatternWithPredicate(headPattern, headPredicate);
            }
            return new AncestorQualifiedPattern(tailPattern, headPattern, axis);
        }
        return null;
    }

    protected Inversion getActionInversion(boolean forGrouping) throws XPathException {
        Expression action;
        if (this.actionInversion == null && Streamability.getSweep(action = ((ContextSwitchingExpression)((Object)this.getExpression())).getActionExpression()) == Sweep.CONSUMING) {
            this.actionInversion = Inversion.invertExpression(action, forGrouping);
        }
        return this.actionInversion;
    }

    @Override
    public WatchMaker getWatchMaker(boolean forGrouping) throws XPathException {
        Pattern pattern;
        Configuration config = this.getConfiguration();
        ArrayList<String> failures = new ArrayList<String>();
        if (!forGrouping && (pattern = StreamingPatternMaker.makeStreamingPattern(this.getExpression(), config, failures)) != null) {
            return (watchManager, out, context) -> new Trigger(pattern, out, context);
        }
        Expression select = ((ContextSwitchingExpression)((Object)this.getExpression())).getSelectExpression();
        if (Streamability.getPosture(select) == Posture.GROUNDED) {
            return null;
        }
        Inversion actionInversion = this.getActionInversion(false);
        Pattern selection = StreamingPatternMaker.makeStreamingPattern(select, config, null);
        StreamingAdjunct sa = StreamingAdjunct.makeStreamingAdjunct(config, select);
        if (selection != null) {
            return (watchManager, out, context) -> {
                ForEachAction actor = new ForEachAction(watchManager, this.getExpression(), out, context);
                if (actionInversion != null) {
                    actor.setInversion(actionInversion);
                }
                return new Trigger(selection, actor, context);
            };
        }
        if (sa instanceof TransmissionAdjunct) {
            return (watchManager, out, context) -> {
                ForEachAction actor = new ForEachAction(watchManager, this.getExpression(), out, context);
                if (actionInversion != null) {
                    actor.setInversion(actionInversion);
                }
                return ((TransmissionAdjunct)sa).makeTransmissionFlow(watchManager, select, actor, context);
            };
        }
        return sa.getWatchMaker(forGrouping);
    }

    @Override
    public ItemFeed makeItemFeed(WatchManager watchManager, ItemFeed out, XPathContext context) throws XPathException {
        if (this.isBuffering) {
            return new BufferingForEachExpressionFeed((ForEach)this.getExpression(), out, context);
        }
        Inversion actionInversion = this.getActionInversion(false);
        ForEachAction actor = new ForEachAction(watchManager, this.getExpression(), out, context);
        if (this.getActionInversion(false) != null) {
            actor.setInversion(actionInversion);
        }
        return actor;
    }

    @Override
    public PostureAndSweep computeStreamability(ContextItemStaticInfoEE contextInfo, List<String> reasons) {
        return ForEachAdjunct.getStreamability((ContextSwitchingExpression)((Object)this.getExpression()), contextInfo, reasons);
    }

    public static PostureAndSweep getStreamability(ContextSwitchingExpression expression, ContextItemStaticInfoEE contextInfo, List<String> reasons) {
        SlashExpression exp;
        Pattern p;
        Expression select = expression.getSelectExpression();
        Expression action = expression.getActionExpression();
        PostureAndSweep selectPS = Streamability.getStreamability(select, contextInfo, reasons);
        if (selectPS.getPosture() == Posture.GROUNDED) {
            return Streamability.generalStreamabilityRules((Expression)((Object)expression), ((Expression)((Object)expression)).operands(), contextInfo, reasons);
        }
        if (select instanceof SortExpression) {
            if (reasons != null) {
                reasons.add("Sorting is not possible during streamed evaluation");
            }
            return PostureAndSweep.ROAMING_AND_FREE_RANGING;
        }
        if (expression instanceof ForEach && ((ForEach)expression).getSeparatorExpression() != null) {
            if (reasons != null) {
                reasons.add("Streaming is not supported for xsl:for-each/@separator");
            }
            return PostureAndSweep.ROAMING_AND_FREE_RANGING;
        }
        ContextItemStaticInfoEE info = new ContextItemStaticInfoEE(select.getItemType(), false, selectPS.getPosture());
        info.setContextSettingExpression(select);
        info.setStrictStreamabilityRules(contextInfo.isStrictStreamabilityRules());
        PostureAndSweep actionPS = Streamability.getStreamability(action, info, reasons);
        if (!(expression instanceof SlashExpression) && selectPS.getPosture() == Posture.CRAWLING && actionPS.getSweep() == Sweep.CONSUMING) {
            if (reasons != null) {
                reasons.add("Expression " + ((Expression)((Object)expression)).toShortString() + " is not streamable because the select expression is crawling and the body is consuming");
            }
            return PostureAndSweep.ROAMING_AND_FREE_RANGING;
        }
        Sweep s = Streamability.wider(selectPS.getSweep(), actionPS.getSweep());
        PostureAndSweep provisional = new PostureAndSweep(s == Sweep.FREE_RANGING ? Posture.ROAMING : actionPS.getPosture(), s);
        if (provisional.getPosture() == Posture.ROAMING && expression instanceof SlashExpression && (p = Streamability.toStreamingPattern(exp = (SlashExpression)expression, exp.getConfiguration())) != null) {
            return new PostureAndSweep(Posture.CRAWLING, Sweep.CONSUMING);
        }
        return provisional;
    }
}

