/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.trans;

import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.ProxyReceiver;
import net.sf.saxon.event.Sink;
import net.sf.saxon.om.AttributeInfo;
import net.sf.saxon.om.AttributeMap;
import net.sf.saxon.om.NamespaceMap;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.s9api.Location;
import net.sf.saxon.serialize.JSONEmitter;
import net.sf.saxon.str.UnicodeString;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.value.StringValue;

public class ExpressionPresenterToJson
extends ProxyReceiver {
    private final JSONEmitter out;
    private boolean pending = false;
    private int level = 0;

    public ExpressionPresenterToJson(JSONEmitter out, PipelineConfiguration pipe) {
        super(new Sink(pipe));
        this.out = out;
    }

    @Override
    public void startElement(NodeName elemName, SchemaType type, AttributeMap attributes, NamespaceMap namespaces, Location location, int properties) throws XPathException {
        if (this.pending) {
            this.out.writeKey("C");
            this.out.startArray(false);
        }
        this.out.startMap(false);
        this.out.writeKey("N");
        this.out.writeAtomicValue(new StringValue(elemName.getLocalPart()));
        for (AttributeInfo att : attributes) {
            this.out.writeKey(att.getNodeName().getLocalPart());
            this.out.writeAtomicValue(new StringValue(att.getValue()));
        }
        this.pending = true;
        ++this.level;
    }

    @Override
    public void endElement() throws XPathException {
        if (!this.pending) {
            this.out.endArray();
        }
        if (--this.level > 0) {
            this.out.endMap();
        }
        this.pending = false;
    }

    @Override
    public void processingInstruction(String target, UnicodeString data, Location locationId, int properties) throws XPathException {
        this.out.writeKey(target);
        this.out.writeAtomicValue(new StringValue(data.tidy()));
    }

    @Override
    public void endDocument() throws XPathException {
        this.out.endMap();
    }

    @Override
    public void close() throws XPathException {
        this.out.close();
    }
}

