/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.functions.qt4;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Stack;
import net.sf.saxon.Configuration;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.NodeName_1;
import net.sf.saxon.functions.OptionsParameter;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.ma.arrays.ArrayItem;
import net.sf.saxon.ma.map.HashTrieMap;
import net.sf.saxon.ma.map.KeyValuePair;
import net.sf.saxon.ma.map.MapItem;
import net.sf.saxon.ma.map.MapType;
import net.sf.saxon.om.AtomicSequence;
import net.sf.saxon.om.FunctionItem;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamespaceUri;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.serialize.JSONEmitter;
import net.sf.saxon.str.UnicodeBuilder;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.AxisIterator;
import net.sf.saxon.type.AnyType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ComplexType;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.SimpleType;
import net.sf.saxon.type.Untyped;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.NumericValue;
import net.sf.saxon.value.QNameValue;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.Whitespace;
import net.sf.saxon.z.IntHashMap;
import net.sf.saxon.z.IntHashSet;
import net.sf.saxon.z.IntSet;
import net.sf.saxon.z.IntToIntHashMap;

public class XdmToJsonFn
extends SystemFunction {
    public static OptionsParameter OPTION_DETAILS;
    private static final SequenceType layoutMapType;
    private static final int HAS_ATTRIBUTES = 0x40000000;
    private static final int HAS_CHILD_ELEMENTS = 0x20000000;
    private static final int HAS_NON_WHITESPACE_TEXT_NODES = 0x10000000;
    private static final int HAS_WHITESPACE_TEXT_NODES = 0x8000000;
    private static final int HAS_DIVERSE_CHILD_ELEMENTS = 0x4000000;
    private static final int HAS_REPEATED_CHILD_ELEMENTS = 0x2000000;
    private static final int HAS_UNIQUE_CHILD_ELEMENTS = 0x1000000;

    @Override
    public Sequence call(XPathContext context, Sequence[] arguments) throws XPathException {
        GroundedValue val = arguments[0].materialize();
        JsonConversionContext jcc = new JsonConversionContext();
        jcc.config = context.getConfiguration();
        jcc.elementNameStack.push(new StructuredQName("", NamespaceUri.NULL, "dummy"));
        Map<Object, Object> checkedOptions = new HashMap();
        boolean indent = false;
        boolean escapeSolidus = false;
        boolean uniform = false;
        if (arguments.length > 1) {
            MapItem suppliedOptions = (MapItem)arguments[1].head();
            checkedOptions = this.getDetails().optionDetails.processSuppliedOptions(suppliedOptions, context);
            indent = ((BooleanValue)checkedOptions.get("indent")).getBooleanValue();
            escapeSolidus = ((BooleanValue)checkedOptions.get("escape-solidus")).getBooleanValue();
            uniform = ((BooleanValue)checkedOptions.get("uniform")).getBooleanValue();
            this.initLayoutMap(jcc, checkedOptions, context.getConfiguration());
        }
        PipelineConfiguration pipe = context.getConfiguration().makePipelineConfiguration();
        UnicodeBuilder builder = new UnicodeBuilder();
        Properties outputProperties = new Properties();
        outputProperties.setProperty("{http://saxon.sf.net/}unfailing", "yes");
        outputProperties.setProperty("indent", indent ? "yes" : "no");
        outputProperties.setProperty("escape-solidus", escapeSolidus ? "yes" : "no");
        if (uniform) {
            jcc.uniformityData = this.gatherUniformityData(val);
        }
        jcc.emitter = new JSONEmitter(pipe, builder, outputProperties);
        this.emitSequence(val, jcc, false);
        return new StringValue(builder.toUnicodeString());
    }

    private void initLayoutMap(JsonConversionContext jcc, Map<String, GroundedValue> checkedOptions, Configuration config) throws XPathException {
        MapItem val = (MapItem)checkedOptions.get("layouts").materialize();
        for (KeyValuePair pair : val.keyValuePairs()) {
            StructuredQName qn = ((QNameValue)pair.key).getStructuredQName();
            int fp = config.getNamePool().allocateFingerprint(qn.getNamespaceUri(), qn.getLocalPart());
            jcc.layoutMap.put(fp, ((StringValue)pair.value).getStringValue());
        }
    }

    private IntToIntHashMap gatherUniformityData(GroundedValue input) {
        IntToIntHashMap data = new IntToIntHashMap();
        for (Item item : input.asIterable()) {
            NodeInfo element;
            AxisIterator iter;
            if (!(item instanceof NodeInfo)) continue;
            if (((NodeInfo)item).getNodeKind() == 9) {
                iter = ((NodeInfo)item).iterateAxis(4, NodeKindTest.ELEMENT);
                while ((element = iter.next()) != null) {
                    this.updateUniformityData(element, data);
                }
                continue;
            }
            if (((NodeInfo)item).getNodeKind() != 1) continue;
            iter = ((NodeInfo)item).iterateAxis(5, NodeKindTest.ELEMENT);
            while ((element = iter.next()) != null) {
                this.updateUniformityData(element, data);
            }
        }
        return data;
    }

    private void updateUniformityData(NodeInfo element, IntToIntHashMap data) {
        int fp = element.getFingerprint();
        boolean existing = data.contains(fp);
        int properties = existing ? data.get(fp) : 0;
        int newProperties = this.getElementProperties(element, properties);
        if (newProperties != properties || !existing) {
            data.put(fp, newProperties);
        }
    }

    private int getElementProperties(NodeInfo element, int properties) {
        if ((properties & 0x40000000) == 0 && element.attributes().size() > 0) {
            properties |= 0x40000000;
        }
        if ((properties & 0x34000000) == 0 && element.hasChildNodes()) {
            int firstChild = -1;
            int countChildElements = 0;
            boolean hasDuplicates = false;
            IntHashSet fingerprints = new IntHashSet();
            for (NodeInfo nodeInfo : element.children()) {
                if (nodeInfo.getNodeKind() == 3) {
                    if (Whitespace.isAllWhite(nodeInfo.getUnicodeStringValue())) {
                        properties |= 0x8000000;
                        continue;
                    }
                    properties |= 0x10000000;
                    continue;
                }
                if (nodeInfo.getNodeKind() != 1) continue;
                int childFingerprint = nodeInfo.getFingerprint();
                if (((IntSet)fingerprints).contains(childFingerprint)) {
                    hasDuplicates = true;
                }
                ++countChildElements;
                properties |= 0x20000000;
                ((IntSet)fingerprints).add(childFingerprint);
                if (firstChild != -1) {
                    if (firstChild != childFingerprint) {
                        properties |= 0x4000000;
                        continue;
                    }
                    properties |= 0x2000000;
                    continue;
                }
                firstChild = nodeInfo.getFingerprint();
            }
            if (firstChild != -1 && (properties & 0x4000000) == 0) {
                properties = (properties & 0xFFFFF) == 0 ? (properties |= firstChild & 0xFFFFF) : (properties |= 0x4000000);
            }
            if (countChildElements == 1) {
                properties |= 0x4000000;
            }
            if (!hasDuplicates) {
                properties |= 0x1000000;
            }
        }
        return properties;
    }

    private void emitSequence(GroundedValue val, JsonConversionContext jcc, boolean forceArray) throws XPathException {
        if (val.getLength() == 0 && !forceArray) {
            jcc.emitter.writeAtomicValue(null);
        } else if (val.getLength() == 1 && !forceArray) {
            this.emitItem(val.head(), jcc);
        } else {
            jcc.emitter.startArray(true);
            for (Item item : val.asIterable()) {
                this.emitItem(item, jcc);
            }
            jcc.emitter.endArray();
        }
    }

    private void emitItem(Item item, JsonConversionContext jcc) throws XPathException {
        block25: {
            JSONEmitter emitter;
            block26: {
                block24: {
                    emitter = jcc.emitter;
                    if (!(item instanceof AtomicValue)) break block24;
                    if (item instanceof NumericValue) {
                        if (((NumericValue)item).isNaN()) {
                            emitter.writeStringValue("NaN");
                        } else if (Double.isInfinite(((NumericValue)item).getDoubleValue())) {
                            emitter.writeStringValue(((NumericValue)item).getDoubleValue() < 0.0 ? "-INF" : "INF");
                        } else {
                            emitter.writeAtomicValue((AtomicValue)item);
                        }
                    } else {
                        emitter.writeAtomicValue((AtomicValue)item);
                    }
                    break block25;
                }
                if (!(item instanceof NodeInfo)) break block26;
                switch (((NodeInfo)item).getNodeKind()) {
                    case 9: {
                        emitter.startMap(true);
                        emitter.writeKey("#document");
                        if (((NodeInfo)item).hasChildNodes()) {
                            this.emitMixedElementContent((NodeInfo)item, jcc, true);
                        }
                        emitter.endMap();
                        break block25;
                    }
                    case 2: {
                        emitter.startMap(true);
                        StructuredQName name = NodeName_1.nodeName((NodeInfo)item).getStructuredQName();
                        NamespaceUri ns = name.getNamespaceUri();
                        String attKey = ns.equals(NamespaceUri.NULL) ? "@" + name.getLocalPart() : (ns.equals(NamespaceUri.XML) ? "@xml:" + name.getLocalPart() : "@" + name.getEQName());
                        emitter.writeKey(attKey);
                        SchemaType type = ((NodeInfo)item).getSchemaType();
                        this.emitSequence(item.atomize(), jcc, ((SimpleType)type).isListType());
                        emitter.endMap();
                        break block25;
                    }
                    case 8: {
                        emitter.startMap(true);
                        emitter.writeKey("#comment");
                        emitter.writeStringValue(item.getStringValue());
                        emitter.endMap();
                        break block25;
                    }
                    case 7: {
                        emitter.startMap(true);
                        emitter.writeKey("#processing-instruction");
                        emitter.startMap(true);
                        emitter.writeKey("#name");
                        emitter.writeStringValue(((NodeInfo)item).getDisplayName());
                        emitter.writeKey("#data");
                        emitter.writeStringValue(item.getStringValue());
                        emitter.endMap();
                        emitter.endMap();
                        break block25;
                    }
                    case 3: {
                        emitter.startMap(true);
                        emitter.writeKey("#text");
                        emitter.writeStringValue(item.getStringValue());
                        emitter.endMap();
                        break block25;
                    }
                    case 1: {
                        this.emitElement((NodeInfo)item, jcc);
                        break block25;
                    }
                    case 13: {
                        emitter.startMap(true);
                        emitter.writeKey("#namespace");
                        emitter.startMap(true);
                        emitter.writeKey("#prefix");
                        emitter.writeStringValue(((NodeInfo)item).getDisplayName());
                        emitter.writeKey("#uri");
                        emitter.writeStringValue(item.getStringValue());
                        emitter.endMap();
                        emitter.endMap();
                        break block25;
                    }
                    default: {
                        throw new IllegalStateException();
                    }
                }
            }
            if (item instanceof ArrayItem) {
                emitter.startArray(true);
                for (GroundedValue member : ((ArrayItem)item).members()) {
                    this.emitSequence(member, jcc, false);
                }
                emitter.endArray();
            } else if (item instanceof MapItem) {
                emitter.startMap(true);
                for (KeyValuePair pair : ((MapItem)item).keyValuePairs()) {
                    emitter.writeKey(pair.key.getStringValue());
                    this.emitSequence(pair.value, jcc, false);
                }
                emitter.endMap();
            } else if (item instanceof FunctionItem) {
                emitter.startMap(true);
                emitter.writeKey("#function");
                emitter.startMap(true);
                StructuredQName name = ((FunctionItem)item).getFunctionName();
                if (name != null && !name.hasURI(NamespaceUri.ANONYMOUS)) {
                    emitter.writeKey("#name");
                    emitter.writeStringValue(name.getEQName());
                }
                emitter.writeKey("#arity");
                emitter.writeStringValue(((FunctionItem)item).getArity() + "");
                emitter.endMap();
                emitter.endMap();
            }
        }
    }

    private void emitElement(NodeInfo element, JsonConversionContext jcc) throws XPathException {
        StructuredQName name = Objects.requireNonNull(NodeName_1.nodeName(element)).getStructuredQName();
        String tag = name.hasURI(jcc.elementNameStack.peek().getNamespaceUri()) ? name.getLocalPart() : name.getEQName();
        jcc.elementNameStack.push(name);
        jcc.emitter.startMap(true);
        jcc.emitter.writeKey(tag);
        this.emitElementContent(element, jcc);
        jcc.emitter.endMap();
        jcc.elementNameStack.pop();
    }

    private void emitElementContent(NodeInfo element, JsonConversionContext jcc) throws XPathException {
        String explicitLayout = jcc.layoutMap.get(element.getFingerprint());
        if (explicitLayout != null) {
            switch (explicitLayout) {
                case "empty": {
                    this.emitEmptyElementContent(element, jcc);
                    break;
                }
                case "empty-plus": {
                    this.emitEmptyPlusElementContent(element, jcc);
                    break;
                }
                case "simple": {
                    this.emitSimpleElementContent(element, jcc);
                    break;
                }
                case "simple-plus": {
                    this.emitSimplePlusElementContent(element, jcc);
                    break;
                }
                case "list": {
                    if (this.isSuitableAsList(element)) {
                        this.emitListElementContent(element, jcc);
                        break;
                    }
                    this.emitMixedElementContent(element, jcc, false);
                    break;
                }
                case "list-plus": {
                    if (this.isSuitableAsList(element)) {
                        this.emitListPlusElementContent(element, jcc, -1);
                        break;
                    }
                    this.emitMixedElementContent(element, jcc, false);
                    break;
                }
                case "record": {
                    this.emitRecordElementContent(element, jcc);
                    break;
                }
                case "sequence": {
                    this.emitMixedElementContent(element, jcc, false);
                    break;
                }
                case "mixed": {
                    this.emitMixedElementContent(element, jcc, false);
                }
            }
        } else {
            SchemaType type = element.getSchemaType();
            if (type != AnyType.getInstance() && type != Untyped.getInstance()) {
                if (type instanceof SimpleType) {
                    this.emitSimpleElementContent(element, jcc);
                } else {
                    ComplexType cType = (ComplexType)type;
                    String layout = cType.getPreferredJsonLayout();
                    String suffix = "";
                    int sep = layout.indexOf("/");
                    if (sep > 0) {
                        suffix = layout.substring(sep + 1);
                        layout = layout.substring(0, sep);
                    }
                    switch (layout) {
                        case "simple-plus": {
                            this.emitSimplePlusElementContent(element, jcc);
                            break;
                        }
                        case "empty": {
                            this.emitEmptyElementContent(element, jcc);
                            break;
                        }
                        case "empty-plus": {
                            this.emitEmptyPlusElementContent(element, jcc);
                            break;
                        }
                        case "list": {
                            this.emitListElementContent(element, jcc);
                            break;
                        }
                        case "list-plus": {
                            this.emitListPlusElementContent(element, jcc, Integer.parseInt(suffix));
                            break;
                        }
                        case "record": {
                            this.emitRecordElementContent(element, jcc);
                            break;
                        }
                        case "sequence": {
                            this.emitSequenceElementContent(element, jcc);
                            break;
                        }
                        case "mixed": {
                            this.emitMixedElementContent(element, jcc, false);
                            break;
                        }
                        default: {
                            throw new IllegalStateException();
                        }
                    }
                }
            } else {
                int properties;
                if (jcc.uniformityData != null) {
                    assert (jcc.uniformityData.contains(element.getFingerprint()));
                    properties = jcc.uniformityData.get(element.getFingerprint());
                } else {
                    properties = this.getElementProperties(element, 0);
                }
                if ((properties & 0x10000000) == 0) {
                    if ((properties & 0x20000000) == 0) {
                        if ((properties & 0x8000000) == 0) {
                            if ((properties & 0x40000000) == 0) {
                                this.emitEmptyElementContent(element, jcc);
                            } else {
                                this.emitEmptyPlusElementContent(element, jcc);
                            }
                        } else if ((properties & 0x40000000) == 0) {
                            this.emitSimpleElementContent(element, jcc);
                        } else {
                            this.emitSimplePlusElementContent(element, jcc);
                        }
                    } else if ((properties & 0x8000000) != 0 && (properties & 0x20000000) == 0) {
                        if ((properties & 0x40000000) == 0) {
                            this.emitSimpleElementContent(element, jcc);
                        } else {
                            this.emitSimplePlusElementContent(element, jcc);
                        }
                    } else if ((properties & 0x4000000) == 0 && (properties & 0x2000000) != 0) {
                        if ((properties & 0x40000000) == 0) {
                            this.emitListElementContent(element, jcc);
                        } else {
                            this.emitListPlusElementContent(element, jcc, properties & 0xFFFFF);
                        }
                    } else if ((properties & 0x1000000) != 0) {
                        this.emitRecordElementContent(element, jcc);
                    } else {
                        this.emitSequenceElementContent(element, jcc);
                    }
                } else if ((properties & 0x20000000) == 0) {
                    if ((properties & 0x40000000) == 0) {
                        this.emitSimpleElementContent(element, jcc);
                    } else {
                        this.emitSimplePlusElementContent(element, jcc);
                    }
                } else {
                    this.emitMixedElementContent(element, jcc, false);
                }
            }
        }
    }

    private boolean isSuitableAsList(NodeInfo element) {
        int props = this.getElementProperties(element, 0);
        return (props & 0x4000000) == 0 && (props & 0x20000000) != 0 && (props & 0x10000000) == 0 && (props & 0xFFFFF) != 0;
    }

    private void emitEmptyElementContent(NodeInfo element, JsonConversionContext jcc) throws XPathException {
        jcc.emitter.writeStringValue("");
    }

    private void emitEmptyPlusElementContent(NodeInfo element, JsonConversionContext jcc) throws XPathException {
        jcc.emitter.startMap(false);
        this.emitAttributes(element, jcc, false);
        jcc.emitter.endMap();
    }

    private void emitSimpleElementContent(NodeInfo element, JsonConversionContext jcc) throws XPathException {
        SchemaType type = element.getSchemaType();
        boolean asList = type instanceof SimpleType && ((SimpleType)type).isListType();
        this.emitSequence(element.atomize(), jcc, asList);
    }

    private void emitSimplePlusElementContent(NodeInfo element, JsonConversionContext jcc) throws XPathException {
        jcc.emitter.startMap(false);
        this.emitAttributes(element, jcc, false);
        jcc.emitter.writeKey("#content");
        SchemaType type = element.getSchemaType();
        boolean asList = type instanceof SimpleType && ((SimpleType)type).isListType();
        this.emitSequence(element.atomize(), jcc, asList);
        jcc.emitter.endMap();
    }

    private void emitListElementContent(NodeInfo element, JsonConversionContext jcc) throws XPathException {
        jcc.emitter.startArray(false);
        for (NodeInfo nodeInfo : element.children(NodeKindTest.ELEMENT)) {
            this.emitElementContent(nodeInfo, jcc);
        }
        jcc.emitter.endArray();
    }

    private void emitListPlusElementContent(NodeInfo element, JsonConversionContext jcc, int childFingerprint) throws XPathException {
        String key;
        if (childFingerprint == -1) {
            NodeInfo firstChild = element.iterateAxis(3, NodeKindTest.ELEMENT).next();
            assert (firstChild != null);
            key = firstChild.getNamespaceUri().equals(element.getNamespaceUri()) ? firstChild.getLocalPart() : "Q{" + firstChild.getNamespaceUri() + "}" + firstChild.getLocalPart();
        } else {
            StructuredQName qn = jcc.config.getNamePool().getStructuredQName(childFingerprint);
            key = qn.getNamespaceUri().equals(element.getNamespaceUri()) ? qn.getLocalPart() : qn.getEQName();
        }
        JSONEmitter emitter = jcc.emitter;
        emitter.startMap(false);
        this.emitAttributes(element, jcc, false);
        emitter.writeKey(key);
        emitter.startArray(false);
        for (NodeInfo nodeInfo : element.children()) {
            if (nodeInfo.getNodeKind() != 1) continue;
            this.emitElementContent(nodeInfo, jcc);
        }
        emitter.endArray();
        emitter.endMap();
    }

    private void emitRecordElementContent(NodeInfo element, JsonConversionContext jcc) throws XPathException {
        JSONEmitter emitter = jcc.emitter;
        emitter.startMap(false);
        this.emitAttributes(element, jcc, false);
        if (element.isNilled()) {
            emitter.writeKey("#content");
            emitter.writeAtomicValue(null);
        } else {
            boolean containsDuplicates = false;
            IntToIntHashMap counters = new IntToIntHashMap();
            for (NodeInfo nodeInfo : element.children()) {
                if (nodeInfo.getNodeKind() != 1) continue;
                int n = nodeInfo.getFingerprint();
                if (counters.contains(n)) {
                    containsDuplicates = true;
                    counters.put(n, counters.get(n) + 1);
                    continue;
                }
                counters.put(n, 1);
            }
            IntToIntHashMap indexes = null;
            if (containsDuplicates) {
                indexes = new IntToIntHashMap();
            }
            for (NodeInfo nodeInfo : element.children()) {
                int fp;
                String key;
                if (nodeInfo.getNodeKind() != 1) continue;
                String string = key = nodeInfo.getNamespaceUri().equals(element.getNamespaceUri()) ? nodeInfo.getLocalPart() : "Q{" + nodeInfo.getNamespaceUri() + "}" + nodeInfo.getLocalPart();
                if (containsDuplicates && counters.get(fp = nodeInfo.getFingerprint()) > 1) {
                    int seq = indexes.contains(fp) ? indexes.get(fp) + 1 : 1;
                    indexes.put(fp, seq);
                    key = key + "[" + seq + "]";
                }
                emitter.writeKey(key);
                this.emitElementContent(nodeInfo, jcc);
            }
        }
        emitter.endMap();
    }

    private void emitSequenceElementContent(NodeInfo element, JsonConversionContext jcc) throws XPathException {
        this.emitMixedElementContent(element, jcc, true);
    }

    private void emitMixedElementContent(NodeInfo element, JsonConversionContext jcc, boolean stripSpace) throws XPathException {
        JSONEmitter emitter = jcc.emitter;
        emitter.startArray(false);
        this.emitAttributes(element, jcc, true);
        if (element.isNilled()) {
            emitter.writeAtomicValue(null);
        } else {
            block6: for (NodeInfo nodeInfo : element.children()) {
                switch (nodeInfo.getNodeKind()) {
                    case 3: {
                        if (stripSpace && Whitespace.isAllWhite(nodeInfo.getUnicodeStringValue())) continue block6;
                        emitter.writeStringValue(nodeInfo.getStringValue());
                        continue block6;
                    }
                    case 8: {
                        emitter.startMap(true);
                        emitter.writeKey("#comment");
                        emitter.writeStringValue(nodeInfo.getStringValue());
                        emitter.endMap();
                        continue block6;
                    }
                    case 7: {
                        emitter.startMap(true);
                        emitter.writeKey("#processing-instruction");
                        emitter.startMap(true);
                        emitter.writeKey("#name");
                        emitter.writeStringValue(nodeInfo.getDisplayName());
                        emitter.writeKey("#data");
                        emitter.writeStringValue(nodeInfo.getStringValue());
                        emitter.endMap();
                        emitter.endMap();
                        continue block6;
                    }
                    case 1: {
                        this.emitElement(nodeInfo, jcc);
                        continue block6;
                    }
                }
                throw new IllegalStateException();
            }
        }
        emitter.endArray();
    }

    private void emitAttributes(NodeInfo element, JsonConversionContext jcc, boolean individual) throws XPathException {
        NodeInfo att;
        AxisIterator iter = element.iterateAxis(2);
        while ((att = (NodeInfo)iter.next()) != null) {
            NamespaceUri ns = att.getNamespaceUri();
            if (ns.equals(NamespaceUri.SCHEMA_INSTANCE)) continue;
            if (individual) {
                jcc.emitter.startMap(true);
            }
            String attKey = ns.equals(NamespaceUri.NULL) ? "@" + att.getLocalPart() : (ns.equals(NamespaceUri.XML) ? "@xml:" + att.getLocalPart() : "@Q{" + att.getNamespaceUri() + "}" + att.getLocalPart());
            jcc.emitter.writeKey(attKey);
            AtomicSequence val = att.atomize();
            SchemaType type = att.getSchemaType();
            boolean asList = ((SimpleType)type).isListType();
            this.emitSequence(val, jcc, asList);
            if (!individual) continue;
            jcc.emitter.endMap();
        }
    }

    static {
        layoutMapType = new SequenceType(new MapType(BuiltInAtomicType.QNAME, SequenceType.SINGLE_STRING), 16384);
        OptionsParameter parseJsonOptions = new OptionsParameter();
        parseJsonOptions.addAllowedOption("indent", SequenceType.SINGLE_BOOLEAN, BooleanValue.FALSE);
        parseJsonOptions.addAllowedOption("uniform", SequenceType.SINGLE_BOOLEAN, BooleanValue.FALSE);
        parseJsonOptions.addAllowedOption("escape-solidus", SequenceType.SINGLE_BOOLEAN, BooleanValue.FALSE);
        parseJsonOptions.addAllowedOption("layouts", layoutMapType, new HashTrieMap());
        OPTION_DETAILS = parseJsonOptions;
    }

    private static class JsonConversionContext {
        public Configuration config;
        public JSONEmitter emitter;
        public IntToIntHashMap uniformityData = null;
        public IntHashMap<String> layoutMap = new IntHashMap();
        public Stack<StructuredQName> elementNameStack = new Stack();

        private JsonConversionContext() {
        }
    }
}

