/*
 * Decompiled with CFR 0.152.
 */
package de.ids_mannheim.korap.query.wrap;

import de.ids_mannheim.korap.query.DistanceConstraint;
import de.ids_mannheim.korap.query.SpanDistanceQuery;
import de.ids_mannheim.korap.query.SpanElementQuery;
import de.ids_mannheim.korap.query.SpanExpansionQuery;
import de.ids_mannheim.korap.query.SpanMultipleDistanceQuery;
import de.ids_mannheim.korap.query.SpanNextQuery;
import de.ids_mannheim.korap.query.wrap.SpanAlterQueryWrapper;
import de.ids_mannheim.korap.query.wrap.SpanElementQueryWrapper;
import de.ids_mannheim.korap.query.wrap.SpanExpansionQueryWrapper;
import de.ids_mannheim.korap.query.wrap.SpanQueryWrapper;
import de.ids_mannheim.korap.query.wrap.SpanSimpleQueryWrapper;
import de.ids_mannheim.korap.util.QueryException;
import java.util.ArrayList;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.spans.SpanQuery;
import org.apache.lucene.search.spans.SpanTermQuery;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpanSequenceQueryWrapper
extends SpanQueryWrapper {
    private String field;
    private ArrayList<SpanQueryWrapper> segments;
    private ArrayList<DistanceConstraint> constraints;
    private QueryException constraintException = null;
    private final String limitationError = "Distance constraints not supported with empty or negative operands";
    private static final Logger log = LoggerFactory.getLogger(SpanSequenceQueryWrapper.class);
    public static final boolean DEBUG = false;
    private boolean isInOrder = true;
    private boolean isSolved = false;

    public SpanSequenceQueryWrapper(String field) {
        this.field = field;
        this.segments = new ArrayList(2);
    }

    public SpanSequenceQueryWrapper(String field, String ... terms) {
        this(field);
        for (int i = 0; i < terms.length; ++i) {
            this.segments.add(new SpanSimpleQueryWrapper(new SpanTermQuery(new Term(field, terms[i]))));
        }
        this.isNull = false;
    }

    public SpanSequenceQueryWrapper(String field, SpanQueryWrapper sswq) {
        this(field);
        if (sswq.isNull()) {
            return;
        }
        this.maybeUnsorted = sswq.maybeUnsorted();
        this.segments.add(sswq);
        this.isNull = false;
    }

    public SpanSequenceQueryWrapper append(String term) {
        return this.append(new SpanSimpleQueryWrapper(this.field, term));
    }

    public SpanSequenceQueryWrapper append(SpanQueryWrapper ssq) {
        if (ssq.isNull()) {
            return this;
        }
        if (ssq.maybeUnsorted()) {
            this.maybeUnsorted = true;
        }
        this.isNull = false;
        this.isSolved = false;
        if (ssq instanceof SpanSequenceQueryWrapper) {
            SpanSequenceQueryWrapper ssqw = (SpanSequenceQueryWrapper)ssq;
            if (!this.hasConstraints() && !ssqw.hasConstraints() && this.isInOrder() == ssqw.isInOrder()) {
                for (int i = 0; i < ssqw.segments.size(); ++i) {
                    this.append(ssqw.segments.get(i));
                }
            } else {
                this.segments.add(ssq);
            }
        } else {
            this.segments.add(ssq);
        }
        return this;
    }

    public SpanSequenceQueryWrapper prepend(String term) {
        return this.prepend(new SpanSimpleQueryWrapper(this.field, term));
    }

    public SpanSequenceQueryWrapper prepend(SpanQueryWrapper ssq) {
        if (ssq.isNull()) {
            return this;
        }
        this.isNull = false;
        this.isSolved = false;
        if (ssq.maybeUnsorted()) {
            this.maybeUnsorted = true;
        }
        if (ssq instanceof SpanSequenceQueryWrapper) {
            SpanSequenceQueryWrapper ssqw = (SpanSequenceQueryWrapper)ssq;
            if (!this.hasConstraints() && !ssqw.hasConstraints() && this.isInOrder() == ssqw.isInOrder()) {
                for (int i = ssqw.segments.size() - 1; i >= 0; --i) {
                    this.prepend(ssqw.segments.get(i));
                }
            } else {
                this.segments.add(0, ssq);
            }
        } else {
            this.segments.add(0, ssq);
        }
        return this;
    }

    public SpanSequenceQueryWrapper withConstraint(int min, int max) {
        return this.withConstraint(min, max, false);
    }

    public SpanSequenceQueryWrapper withConstraint(int min, int max, boolean exclusion) {
        if (this.constraints == null) {
            this.constraints = new ArrayList(1);
        }
        this.constraints.add(new DistanceConstraint(min, max, this.isInOrder, exclusion));
        return this;
    }

    public SpanSequenceQueryWrapper withConstraint(int min, int max, String unit) {
        return this.withConstraint(min, max, unit, false);
    }

    public SpanSequenceQueryWrapper withConstraint(int min, int max, String unit, boolean exclusion) {
        if (unit.equals("w")) {
            if (this.constraints == null) {
                this.constraints = new ArrayList(1);
            }
            this.constraints.add(new DistanceConstraint(min, max, this.isInOrder, exclusion));
            return this;
        }
        return this.withConstraint(min, max, new SpanElementQueryWrapper(this.field, unit), exclusion);
    }

    public SpanSequenceQueryWrapper withConstraint(int min, int max, SpanElementQueryWrapper unit, boolean exclusion) {
        if (this.constraints == null) {
            this.constraints = new ArrayList(1);
        }
        try {
            this.constraints.add(new DistanceConstraint((SpanElementQuery)unit.retrieveNode(this.retrieveNode).toFragmentQuery(), min, max, this.isInOrder, exclusion));
        }
        catch (QueryException qe) {
            this.constraintException = qe;
        }
        return this;
    }

    public boolean isInOrder() {
        return this.isInOrder;
    }

    public void setInOrder(boolean order) {
        this.isInOrder = order;
        if (!order) {
            this.maybeUnsorted = true;
        }
    }

    public boolean hasConstraints() {
        DistanceConstraint dc;
        if (this.constraints == null) {
            return false;
        }
        if (this.constraints.size() <= 0) {
            return false;
        }
        return this.constraints.size() != 1 || !(dc = this.constraints.get(0)).getUnit().equals("w") || dc.getMinDistance() != 1 || dc.getMaxDistance() != 1 || dc.isExclusion() || !this.isInOrder;
    }

    @Override
    public boolean isEmpty() {
        if (this.segments.size() == 1) {
            return this.segments.get(0).isEmpty();
        }
        if (!this.isSolved) {
            this._solveProblematicSequence();
        }
        return super.isEmpty();
    }

    @Override
    public boolean isOptional() {
        if (this.segments.size() == 1) {
            return this.segments.get(0).isOptional();
        }
        if (!this.isSolved) {
            this._solveProblematicSequence();
        }
        return super.isOptional();
    }

    @Override
    public boolean isNegative() {
        if (this.segments.size() == 1) {
            return this.segments.get(0).isNegative();
        }
        if (!this.isSolved) {
            this._solveProblematicSequence();
        }
        return super.isNegative();
    }

    @Override
    public boolean isExtendedToTheRight() {
        int size;
        if (!this.isSolved) {
            this._solveProblematicSequence();
        }
        if ((size = this.segments.size()) == 0 || this.isNull()) {
            return false;
        }
        return this.segments.get(size - 1).isExtendedToTheRight();
    }

    @Override
    public SpanQuery toFragmentQuery() throws QueryException {
        int i;
        if (this.constraintException != null) {
            throw this.constraintException;
        }
        int size = this.segments.size();
        if (size == 0 || this.isNull()) {
            return null;
        }
        if (size == 1) {
            if (this.segments.get(0).isExtended() && (this.hasConstraints() || !this.isInOrder())) {
                throw new QueryException(613, "Distance constraints not supported with empty or negative operands");
            }
            if (this.segments.get(0).maybeAnchor()) {
                return this.segments.get(0).retrieveNode(this.retrieveNode).toFragmentQuery();
            }
            if (this.segments.get(0).isEmpty()) {
                throw new QueryException(613, "Sequence is not allowed to be empty");
            }
            if (this.segments.get(0).isOptional()) {
                throw new QueryException(613, "Sequence is not allowed to be optional");
            }
            if (this.segments.get(0).isNegative()) {
                throw new QueryException(613, "Sequence is not allowed to be negative");
            }
        }
        if (!this.isSolved && !this._solveProblematicSequence() && this.segments.get(0).maybeExtension()) {
            throw new QueryException(613, "Sequence contains unresolvable empty, optional, or negative segments");
        }
        if (this.segments.size() == 1 && this.segments.get(0).isExtended() && (this.hasConstraints() || !this.isInOrder())) {
            throw new QueryException(613, "Distance constraints not supported with empty or negative operands");
        }
        SpanQuery query = null;
        for (i = 0; query == null && i < this.segments.size(); ++i) {
            query = this.segments.get(i).retrieveNode(this.retrieveNode).toFragmentQuery();
        }
        if (query == null) {
            return null;
        }
        if (!this.hasConstraints() && this.isInOrder()) {
            while (i < this.segments.size()) {
                SpanQuery second = this.segments.get(i).retrieveNode(this.retrieveNode).toFragmentQuery();
                if (second != null) {
                    query = new SpanNextQuery(query, second);
                }
                ++i;
            }
            return query;
        }
        if (this.hasConstraints() && this.isProblematic) {
            throw new QueryException(613, "Distance constraints not supported with empty, optional or negative operands");
        }
        if (this.constraints.size() == 1) {
            DistanceConstraint constraint = this.constraints.get(0);
            if (!constraint.getUnit().equals("w")) {
                for (i = 1; i < this.segments.size(); ++i) {
                    if (this.segments.get(i).isExtended()) {
                        throw new QueryException(613, "Distance constraints not supported with empty or negative operands");
                    }
                    SpanQuery sq = this.segments.get(i).retrieveNode(this.retrieveNode).toFragmentQuery();
                    if (sq == null) continue;
                    SpanDistanceQuery sdquery = new SpanDistanceQuery(query, sq, constraint, true);
                    query = sdquery;
                }
            } else {
                for (i = 1; i < this.segments.size(); ++i) {
                    if (this.segments.get(i).isExtended()) {
                        throw new QueryException(613, "Distance constraints not supported with empty or negative operands");
                    }
                    SpanQuery sq = this.segments.get(i).retrieveNode(this.retrieveNode).toFragmentQuery();
                    if (sq == null) continue;
                    SpanDistanceQuery sdquery = new SpanDistanceQuery(query, sq, constraint, true);
                    query = sdquery;
                }
            }
            return query;
        }
        for (i = 1; i < this.segments.size(); ++i) {
            if (this.segments.get(i).isExtended()) {
                throw new QueryException(613, "Distance constraints not supported with empty or negative operands");
            }
            SpanQuery sq = this.segments.get(i).retrieveNode(this.retrieveNode).toFragmentQuery();
            if (sq == null) continue;
            query = new SpanMultipleDistanceQuery(query, sq, this.constraints, this.isInOrder, true);
        }
        return query;
    }

    private boolean _solveProblematicSequence() {
        int size = this.segments.size();
        boolean noRemainingProblem = true;
        int i = 0;
        while (i < size) {
            SpanQueryWrapper underScrutiny = this.segments.get(i);
            if (!underScrutiny.maybeAnchor()) {
                if (this.hasConstraints()) {
                    this.isSolved = true;
                    this.isProblematic = true;
                    return false;
                }
                if (i < size - 1 && this.segments.get(i + 1).maybeAnchor()) {
                    try {
                        this.segments.set(i + 1, this._merge(this.segments.get(i + 1), underScrutiny, false));
                    }
                    catch (QueryException e) {
                        this.isSolved = true;
                        this.isProblematic = true;
                        return false;
                    }
                    this.segments.remove(i);
                    --size;
                    i = 0;
                    continue;
                }
                if (i >= 1 && this.segments.get(i - 1).maybeAnchor()) {
                    try {
                        this.segments.set(i - 1, this._merge(this.segments.get(i - 1), underScrutiny, true));
                    }
                    catch (QueryException e) {
                        this.isSolved = true;
                        this.isProblematic = true;
                        return false;
                    }
                    this.segments.remove(i);
                    --size;
                    i = 0;
                    continue;
                }
                noRemainingProblem = false;
                ++i;
                continue;
            }
            ++i;
        }
        if (!noRemainingProblem) {
            if (size != this.segments.size()) {
                return this._solveProblematicSequence();
            }
            this.isSolved = true;
            this.isProblematic = true;
            return false;
        }
        this.isSolved = true;
        this.isProblematic = false;
        return false;
    }

    private SpanQueryWrapper _merge(SpanQueryWrapper anchor, SpanQueryWrapper problem, boolean mergeLeft) throws QueryException {
        int direction;
        int n = direction = mergeLeft ? 1 : -1;
        if (problem.isEmpty()) {
            if (!problem.hasClass() && !anchor.hasClass() && anchor.isExtended() && (direction >= 0 && anchor.isExtendedToTheRight || direction < 0 && !anchor.isExtendedToTheRight)) {
                anchor.setMin(anchor.getMin() + problem.getMin());
                anchor.setMax(anchor.getMax() + problem.getMax());
                return anchor;
            }
            SpanQueryWrapper sqw = new SpanExpansionQueryWrapper(anchor, problem.isOptional() ? 0 : problem.getMin(), problem.getMax(), direction, problem.hasClass() ? problem.getClassNumber() : (byte)0).isExtended(true);
            if (direction >= 0) {
                sqw.isExtendedToTheRight(true);
            }
            return sqw;
        }
        if (problem.isNegative()) {
            SpanExpansionQuery query = new SpanExpansionQuery(anchor.retrieveNode(this.retrieveNode).toFragmentQuery(), problem.retrieveNode(this.retrieveNode).toFragmentQuery(), problem.getMin(), problem.getMax(), direction, problem.hasClass() ? problem.getClassNumber() : (byte)0, true);
            SpanQueryWrapper sqw = new SpanSimpleQueryWrapper(query).isExtended(true);
            if (direction >= 0) {
                sqw.isExtendedToTheRight(true);
            }
            return sqw;
        }
        SpanAlterQueryWrapper saqw = new SpanAlterQueryWrapper(this.field, anchor);
        SpanSequenceQueryWrapper ssqw = new SpanSequenceQueryWrapper(this.field, anchor);
        if (mergeLeft) {
            ssqw.append(problem.isOptional(false));
        } else {
            ssqw.prepend(problem.isOptional(false));
        }
        saqw.or(ssqw);
        return saqw;
    }
}

