/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.schema.sdoc;

import com.saxonica.ee.stream.StreamingPatternMaker;
import java.util.ArrayList;
import net.sf.saxon.expr.AxisExpression;
import net.sf.saxon.expr.ContextItemExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.SlashExpression;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.VennExpression;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.Tokenizer;
import net.sf.saxon.expr.parser.XPathParser;
import net.sf.saxon.om.AxisInfo;
import net.sf.saxon.om.QNameParser;
import net.sf.saxon.pattern.AnyNodeTest;
import net.sf.saxon.pattern.Pattern;
import net.sf.saxon.trans.XPathException;

public class SelectionParser
extends XPathParser {
    boolean isFieldSubset;
    Expression optimizedExpression;

    public Pattern parseSelector(String expression, StaticContext env, boolean isField) throws XPathException {
        this.setLanguage(0, 20);
        this.env = env;
        this.charChecker = env.getConfiguration().getValidCharacterChecker();
        this.isFieldSubset = isField;
        this.t = new Tokenizer();
        this.t.languageLevel = 20;
        QNameParser qp = new QNameParser(env.getNamespaceResolver());
        this.setQNameParser(qp);
        try {
            this.t.tokenize(expression, 0, -1);
        }
        catch (XPathException err) {
            this.grumble(err.getMessage());
        }
        Expression exp = this.parseUnionExpression();
        if (this.t.currentToken != 0) {
            this.grumble("Unexpected token " + this.currentTokenDisplay() + " beyond end of expression");
        }
        exp.setLocation(this.makeLocation());
        exp.setRetainedStaticContext(env.makeRetainedStaticContext());
        ExpressionVisitor visitor = ExpressionVisitor.make(env);
        this.optimizedExpression = exp = exp.simplify().typeCheck(visitor, env.getConfiguration().makeContextItemStaticInfo(AnyNodeTest.getInstance(), true));
        ArrayList<String> reasonsForFailure = new ArrayList<String>();
        Pattern pattern = StreamingPatternMaker.makeStreamingPattern(exp, env.getConfiguration(), reasonsForFailure);
        if (!reasonsForFailure.isEmpty()) {
            throw new XPathException((String)reasonsForFailure.get(0));
        }
        return pattern;
    }

    protected Expression parseUnionExpression() throws XPathException {
        Expression exp = this.parseRelativePath();
        while (this.t.currentToken == 1) {
            if (this.t.currentTokenValue.equals("union")) {
                this.grumble("Union operator in the selector/field XPath subset must be written as '|'");
            }
            this.nextToken();
            exp = new VennExpression(exp, 1, this.parseRelativePath());
            this.setLocation(exp);
        }
        return exp;
    }

    @Override
    protected Expression parseRelativePath() throws XPathException {
        boolean first = true;
        Expression exp = this.parseStepExpression();
        while (this.t.currentToken == 2 || this.t.currentToken == 8) {
            if (!(this.t.currentToken != 8 || first && exp instanceof ContextItemExpression)) {
                this.grumble("The // operator can be used only at the start of the path, preceded by '.'");
            }
            first = false;
            int op = this.t.currentToken;
            this.nextToken();
            Expression next = this.parseStepExpression();
            if (op == 2) {
                exp = new SlashExpression(exp, next);
            } else {
                AxisExpression ae = new AxisExpression(5, null);
                this.setLocation(ae);
                SlashExpression se = new SlashExpression(ae, next);
                this.setLocation(se);
                exp = exp instanceof ContextItemExpression ? se : new SlashExpression(exp, se);
            }
            this.setLocation(exp);
        }
        return exp;
    }

    protected Expression parseStepExpression() throws XPathException {
        switch (this.t.currentToken) {
            case 205: {
                this.nextToken();
                ContextItemExpression cie = new ContextItemExpression();
                this.setLocation(cie);
                return cie;
            }
            case 201: 
            case 207: 
            case 208: {
                AxisExpression ae = new AxisExpression(3, this.parseNodeTest((short)1));
                this.setLocation(ae);
                return ae;
            }
            case 3: {
                if (!this.isFieldSubset) {
                    this.grumble("The attribute axis cannot be used in a selector XPath");
                }
                this.nextToken();
                switch (this.t.currentToken) {
                    case 201: 
                    case 207: 
                    case 208: {
                        AxisExpression ae2 = new AxisExpression(2, this.parseNodeTest((short)2));
                        this.setLocation(ae2);
                        return ae2;
                    }
                }
                this.grumble("Unexpected token " + this.currentTokenDisplay() + " after axis name");
            }
            case 36: {
                byte axis = AxisInfo.getAxisNumber(this.t.currentTokenValue);
                if (axis != 3 && axis != 2) {
                    this.grumble("Only the child and attribute axes are permitted");
                }
                if (axis == 2 && !this.isFieldSubset) {
                    this.grumble("The attribute axis cannot be used in a selector XPath");
                }
                short principalNodeType = AxisInfo.principalNodeType[axis];
                this.nextToken();
                switch (this.t.currentToken) {
                    case 201: 
                    case 207: 
                    case 208: {
                        AxisExpression ae3 = new AxisExpression(axis, this.parseNodeTest(principalNodeType));
                        this.setLocation(ae3);
                        return ae3;
                    }
                }
                this.grumble("Unexpected token " + this.currentTokenDisplay() + " after axis name");
            }
        }
        this.grumble("Unexpected token " + this.currentTokenDisplay() + " in path expression");
        return null;
    }

    public Expression getOptimizedExpression() {
        return this.optimizedExpression;
    }
}

