/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.formats.brat;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import opennlp.tools.formats.brat.AnnotationConfiguration;
import opennlp.tools.formats.brat.AnnotatorNoteAnnotation;
import opennlp.tools.formats.brat.AttributeAnnotation;
import opennlp.tools.formats.brat.BratAnnotation;
import opennlp.tools.formats.brat.EventAnnotation;
import opennlp.tools.formats.brat.RelationAnnotation;
import opennlp.tools.formats.brat.SpanAnnotation;
import opennlp.tools.tokenize.WhitespaceTokenizer;
import opennlp.tools.util.InvalidFormatException;
import opennlp.tools.util.ObjectStream;
import opennlp.tools.util.Span;

public class BratAnnotationStream
implements ObjectStream<BratAnnotation> {
    private final AnnotationConfiguration config;
    private final BufferedReader reader;
    private final String id;

    BratAnnotationStream(AnnotationConfiguration config, String id, InputStream in) {
        this.config = config;
        this.id = id;
        this.reader = new BufferedReader(new InputStreamReader(in, StandardCharsets.UTF_8));
    }

    @Override
    public BratAnnotation read() throws IOException {
        Span[] tokens;
        String line = this.reader.readLine();
        if (line != null && (tokens = WhitespaceTokenizer.INSTANCE.tokenizePos(line)).length > 2) {
            BratAnnotationParser parser;
            String annId = tokens[0].getCoveredText(line).toString();
            if (annId.length() == 0) {
                throw new InvalidFormatException("annotation id is empty");
            }
            switch (annId.charAt(0)) {
                case 'T': {
                    parser = new SpanAnnotationParser();
                    break;
                }
                case 'R': {
                    parser = new RelationAnnotationParser();
                    break;
                }
                case 'A': {
                    parser = new AttributeAnnotationParser();
                    break;
                }
                case 'E': {
                    parser = new EventAnnotationParser();
                    break;
                }
                case '#': {
                    if (tokens[1].getCoveredText(line).toString().equals("AnnotatorNotes")) {
                        parser = new AnnotatorNoteParser();
                        break;
                    }
                    return this.read();
                }
                default: {
                    return this.read();
                }
            }
            try {
                return parser.parse(tokens, line);
            }
            catch (IOException e) {
                throw new IOException(String.format("Failed to parse ann document with id [%s.ann]", this.id), e);
            }
        }
        return null;
    }

    @Override
    public void reset() throws IOException, UnsupportedOperationException {
        this.reader.reset();
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
    }

    static abstract class BratAnnotationParser {
        static final int ID_OFFSET = 0;
        static final int TYPE_OFFSET = 1;
        static final String NOTES_TYPE = "AnnotatorNotes";

        BratAnnotationParser() {
        }

        BratAnnotation parse(Span[] tokens, CharSequence line) throws IOException {
            return null;
        }

        protected int parseInt(String intString) throws InvalidFormatException {
            try {
                return Integer.parseInt(intString);
            }
            catch (NumberFormatException e) {
                throw new InvalidFormatException(e);
            }
        }
    }

    static class SpanAnnotationParser
    extends BratAnnotationParser {
        private static final int BEGIN_OFFSET = 2;
        private static final int END_OFFSET = 3;

        SpanAnnotationParser() {
        }

        @Override
        BratAnnotation parse(Span[] values2, CharSequence line) throws IOException {
            if (values2.length > 4) {
                String type = values2[1].getCoveredText(line).toString();
                int firstTextTokenIndex = -1;
                int beginIndex = this.parseInt(values2[2].getCoveredText(line).toString());
                ArrayList<Span> fragments = new ArrayList<Span>();
                for (int i = 3; i < values2.length; ++i) {
                    int endOffset;
                    int nextBeginOffset = -1;
                    if (!values2[i].getCoveredText(line).toString().contains(";")) {
                        endOffset = this.parseInt(values2[i].getCoveredText(line).toString());
                        firstTextTokenIndex = i + 1;
                        fragments.add(new Span(beginIndex, endOffset, type));
                        break;
                    }
                    String[] parts = values2[i].getCoveredText(line).toString().split(";");
                    endOffset = this.parseInt(parts[0]);
                    fragments.add(new Span(beginIndex, endOffset, type));
                    beginIndex = this.parseInt(parts[1]);
                }
                String id = values2[0].getCoveredText(line).toString();
                String coveredText = line.subSequence(values2[firstTextTokenIndex].getStart(), values2[values2.length - 1].getEnd()).toString();
                try {
                    return new SpanAnnotation(id, type, fragments.toArray(new Span[0]), coveredText);
                }
                catch (IllegalArgumentException e) {
                    throw new InvalidFormatException(e);
                }
            }
            throw new InvalidFormatException("Line must have at least 5 fields");
        }
    }

    static class RelationAnnotationParser
    extends BratAnnotationParser {
        private static final int ARG1_OFFSET = 2;
        private static final int ARG2_OFFSET = 3;

        RelationAnnotationParser() {
        }

        private String parseArg(String arg) throws InvalidFormatException {
            if (arg.length() > 4) {
                return arg.substring(5).trim();
            }
            throw new InvalidFormatException("Failed to parse argument: " + arg);
        }

        @Override
        BratAnnotation parse(Span[] tokens, CharSequence line) throws IOException {
            return new RelationAnnotation(tokens[0].getCoveredText(line).toString(), tokens[1].getCoveredText(line).toString(), this.parseArg(tokens[2].getCoveredText(line).toString()), this.parseArg(tokens[3].getCoveredText(line).toString()));
        }
    }

    static class AttributeAnnotationParser
    extends BratAnnotationParser {
        private static final int ATTACHED_TO_OFFSET = 2;
        private static final int VALUE_OFFSET = 3;

        AttributeAnnotationParser() {
        }

        @Override
        BratAnnotation parse(Span[] values2, CharSequence line) throws IOException {
            if (values2.length == 3 || values2.length == 4) {
                String value = null;
                if (values2.length == 4) {
                    value = values2[3].getCoveredText(line).toString();
                }
                return new AttributeAnnotation(values2[0].getCoveredText(line).toString(), values2[1].getCoveredText(line).toString(), values2[2].getCoveredText(line).toString(), value);
            }
            throw new InvalidFormatException("Line must have 3 or 4 fields");
        }
    }

    static class EventAnnotationParser
    extends BratAnnotationParser {
        EventAnnotationParser() {
        }

        @Override
        BratAnnotation parse(Span[] tokens, CharSequence line) throws IOException {
            String[] typeParts = tokens[1].getCoveredText(line).toString().split(":");
            if (typeParts.length != 2) {
                throw new InvalidFormatException(String.format("Failed to parse [%s], type part must be in the format type:trigger", line));
            }
            String type = typeParts[0];
            String eventTrigger = typeParts[1];
            HashMap<String, String> arguments = new HashMap<String, String>();
            for (int i = 2; i < tokens.length; ++i) {
                String[] parts = tokens[i].getCoveredText(line).toString().split(":");
                if (parts.length != 2) {
                    throw new InvalidFormatException(String.format("Failed to parse [%s], argument parts must be in form argument:value", line));
                }
                arguments.put(parts[0], parts[1]);
            }
            return new EventAnnotation(tokens[0].getCoveredText(line).toString(), type, eventTrigger, arguments);
        }
    }

    static class AnnotatorNoteParser
    extends BratAnnotationParser {
        private static final int ATTACH_TO_OFFSET = 2;
        private static final int START_VALUE_OFFSET = 3;

        AnnotatorNoteParser() {
        }

        @Override
        BratAnnotation parse(Span[] tokens, CharSequence line) throws IOException {
            Span noteSpan = new Span(tokens[3].getStart(), tokens[tokens.length - 1].getEnd());
            return new AnnotatorNoteAnnotation(tokens[0].getCoveredText(line).toString(), tokens[2].getCoveredText(line).toString(), noteSpan.getCoveredText(line).toString());
        }
    }
}

