/*
 * Decompiled with CFR 0.152.
 */
package org.maltparser.core.pool;

import java.util.Iterator;
import org.maltparser.core.exception.MaltChainedException;
import org.maltparser.core.helper.HashSet;
import org.maltparser.core.pool.ObjectPool;

public abstract class ObjectPoolSet<T>
extends ObjectPool<T> {
    private final HashSet<T> available = new HashSet();
    private final HashSet<T> inuse = new HashSet();

    public ObjectPoolSet() {
        this(Integer.MAX_VALUE);
    }

    public ObjectPoolSet(int keepThreshold) {
        super(keepThreshold);
    }

    @Override
    protected abstract T create() throws MaltChainedException;

    @Override
    public abstract void resetObject(T var1) throws MaltChainedException;

    @Override
    public synchronized T checkOut() throws MaltChainedException {
        if (this.available.isEmpty()) {
            T t2 = this.create();
            this.inuse.add(t2);
            return t2;
        }
        Iterator<T> i$ = this.available.iterator();
        if (i$.hasNext()) {
            T t3 = i$.next();
            this.inuse.add(t3);
            this.available.remove(t3);
            return t3;
        }
        return null;
    }

    @Override
    public synchronized void checkIn(T t2) throws MaltChainedException {
        this.resetObject(t2);
        this.inuse.remove(t2);
        if (this.available.size() < this.keepThreshold) {
            this.available.add(t2);
        }
    }

    @Override
    public synchronized void checkInAll() throws MaltChainedException {
        for (T t2 : this.inuse) {
            this.resetObject(t2);
            if (this.available.size() >= this.keepThreshold) continue;
            this.available.add(t2);
        }
        this.inuse.clear();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (T t2 : this.inuse) {
            sb.append(t2);
            sb.append(", ");
        }
        return sb.toString();
    }
}

