/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.optim;

import com.saxonica.ee.optim.IndexedValue;
import com.saxonica.ee.optim.SmallSearchableValue;
import java.util.Arrays;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.sort.AtomicComparer;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.SequenceTool;
import net.sf.saxon.str.UnicodeString;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.ArrayIterator;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.SequenceExtent;

public abstract class SearchableValue
implements GroundedValue {
    protected Item[] value = null;
    protected int end;

    public static SearchableValue makeSearchableValue(SequenceIterator iter) throws XPathException {
        Item[] array;
        int end;
        if (SequenceTool.supportsGetLength(iter)) {
            Item it;
            end = SequenceTool.getLength(iter);
            array = new Item[end];
            int i = 0;
            while ((it = iter.next()) != null) {
                array[i++] = it;
            }
        } else {
            Item it;
            int used = 0;
            array = new Item[20];
            while ((it = iter.next()) != null) {
                if (used >= array.length - 1) {
                    array = Arrays.copyOf(array, used * 2);
                }
                array[used++] = it;
            }
            if (array.length - used > 100) {
                array = Arrays.copyOf(array, used);
            }
            end = used;
        }
        if (end < 8) {
            return new SmallSearchableValue(array, end);
        }
        return new IndexedValue(array, end);
    }

    @Override
    public SequenceIterator iterate() {
        return new ArrayIterator.Of(this.value, 0, this.end);
    }

    @Override
    public Item itemAt(int n) {
        if (n < 0 || n >= this.end) {
            return null;
        }
        return this.value[n];
    }

    @Override
    public int getLength() {
        return this.end;
    }

    public abstract SequenceIterator findItems(Expression var1, SequenceIterator var2, boolean var3, AtomicComparer var4, XPathContext var5) throws XPathException;

    @Override
    public GroundedValue subsequence(int start, int length) {
        if (length > this.end) {
            length = this.end;
        }
        return new SequenceExtent.Of<Item>(Arrays.asList(this.value).subList(start, start + length));
    }

    @Override
    public boolean effectiveBooleanValue() throws XPathException {
        return ExpressionTool.effectiveBooleanValue(this.iterate());
    }

    @Override
    public UnicodeString getUnicodeStringValue() throws XPathException {
        return SequenceTool.getStringValue(this);
    }

    @Override
    public String getStringValue() throws XPathException {
        return SequenceTool.stringify(this);
    }

    @Override
    public Item head() {
        return this.value.length > 0 ? this.value[0] : null;
    }

    @Override
    public GroundedValue reduce() {
        int len = this.getLength();
        if (len == 0) {
            return EmptySequence.getInstance();
        }
        if (len == 1) {
            return this.itemAt(0);
        }
        return this;
    }
}

