/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.expr.sort;

import com.ibm.icu.lang.UScript;
import com.ibm.icu.text.CollationElementIterator;
import com.ibm.icu.text.Collator;
import com.ibm.icu.text.RuleBasedCollator;
import com.ibm.icu.util.ULocale;
import com.ibm.icu.util.VersionInfo;
import com.saxonica.config.ICULibrary;
import com.saxonica.expr.sort.UcaCollationKeyUsingIcu;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.CollationKey;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Locale;
import java.util.Properties;
import java.util.Set;
import net.sf.saxon.expr.sort.AtomicMatchKey;
import net.sf.saxon.expr.sort.CollationMatchKey;
import net.sf.saxon.lib.SubstringMatcher;
import net.sf.saxon.str.EmptyUnicodeString;
import net.sf.saxon.str.StringView;
import net.sf.saxon.str.UnicodeString;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.transpile.CSharp;
import net.sf.saxon.type.StringConverter;
import net.sf.saxon.type.ValidationFailure;
import net.sf.saxon.value.AnyURIValue;

public class UcaCollatorUsingIcu
implements SubstringMatcher {
    private final String uri;
    private RuleBasedCollator uca;
    private Strength strengthLevel;
    public int[] maxIgnorable;
    private static final String[] keywords = new String[]{"fallback", "lang", "version", "strength", "alternate", "backwards", "normalization", "maxVariable", "caseLevel", "caseFirst", "numeric", "reorder"};
    private static final Set<String> keys = new HashSet<String>(Arrays.asList(keywords));

    public static String getUCAVersion() {
        VersionInfo v = Collator.getInstance().getUCAVersion();
        return v.getMajor() + "." + v.getMinor() + "." + v.getMilli() + "." + v.getMicro();
    }

    public UcaCollatorUsingIcu(String uri) throws XPathException {
        this.uri = uri;
        this.uca = (RuleBasedCollator)Collator.getInstance();
        this.setProps(this.parseProps(uri));
    }

    public RuleBasedCollator getRuleBasedCollator() {
        return this.uca;
    }

    public static String[] getLocales() {
        Locale[] availableLocales;
        ArrayList<String> locales = new ArrayList<String>();
        for (Locale l : availableLocales = RuleBasedCollator.getAvailableLocales()) {
            locales.add(ICULibrary.getLanguageTag(l) + ";" + l.getDisplayName());
        }
        return locales.toArray(new String[0]);
    }

    private void error(String field, String allowed) throws XPathException {
        this.error("value of " + field + " must be " + allowed);
    }

    private void error(String field, String allowed, String requested) throws XPathException {
        this.error("value of " + field + " must be " + allowed + ", requested was:" + requested);
    }

    private void error(String message) throws XPathException {
        throw new XPathException("Error in UCA Collation URI " + this.uri + ": " + message, "FOCH0002");
    }

    public String show() {
        if (this.uca != null) {
            return " UCAversion=" + this.uca.getUCAVersion() + " Version=" + this.uca.getVersion() + " lang=" + this.uca.getLocale(ULocale.ACTUAL_LOCALE) + " french=" + this.uca.isFrenchCollation() + " lowerFirst=" + this.uca.isLowerCaseFirst() + " upperFirst=" + this.uca.isUpperCaseFirst() + " strength=" + this.uca.getStrength();
        }
        return "No RuleBasedCollator initialised";
    }

    public CollationKey getCollationKey(String source) {
        return new UcaCollationKeyUsingIcu(source, this.uca.getCollationKey(source).toByteArray());
    }

    public int hashCode() {
        return this.uca.hashCode();
    }

    public void setProps(Properties props) throws XPathException {
        String reorder;
        String numeric;
        String caseFirst;
        String caseLevel;
        String normalization;
        String backwards;
        String alternate;
        String maxVariable;
        String strength;
        boolean fallbackError;
        block113: {
            String version;
            String lang;
            fallbackError = false;
            String fallback = props.getProperty("fallback");
            if (fallback != null) {
                switch (fallback) {
                    case "yes": {
                        break;
                    }
                    case "no": {
                        fallbackError = true;
                        break;
                    }
                    default: {
                        this.error("fallback", "yes|no");
                    }
                }
            }
            if ((lang = props.getProperty("lang")) != null && !lang.isEmpty()) {
                ValidationFailure vf = StringConverter.StringToLanguage.INSTANCE.validate(StringView.tidy(lang));
                if (vf != null) {
                    this.error("lang", "a valid language code");
                }
                String country = "";
                Object variant = "";
                Object parts = lang.split("-");
                String language = parts[0];
                if (((String[])parts).length > 1) {
                    country = parts[1];
                }
                if (((String[])parts).length > 2) {
                    variant = parts[2];
                }
                Object loc = UcaCollatorUsingIcu.makeLocale(language, country, (String)variant);
                this.uca = (RuleBasedCollator)Collator.getInstance((Locale)loc);
            }
            if ((version = props.getProperty("version")) != null) {
                try {
                    VersionInfo v = VersionInfo.getInstance((String)version);
                    Object current = this.uca.getUCAVersion();
                    if (v.compareTo((VersionInfo)current) > 0 && fallbackError) {
                        this.error("requesting UCA version " + v.toString() + ", implementation supports UCA version " + current.toString());
                    }
                }
                catch (Exception e) {
                    if (!fallbackError) break block113;
                    this.error("version number format incorrect:" + version);
                }
            }
        }
        if ((strength = props.getProperty("strength")) != null) {
            switch (strength) {
                case "primary": 
                case "1": {
                    this.setStrength(0);
                    break;
                }
                case "secondary": 
                case "2": {
                    this.setStrength(1);
                    break;
                }
                case "tertiary": 
                case "3": {
                    this.setStrength(2);
                    break;
                }
                case "quaternary": 
                case "4": {
                    this.setStrength(3);
                    break;
                }
                case "identical": 
                case "5": {
                    this.setStrength(15);
                    break;
                }
                default: {
                    if (!fallbackError) break;
                    this.error("strength", "primary|secondary|tertiary|quaternary|identical|1|2|3|4|5", strength);
                }
            }
        }
        if ((maxVariable = props.getProperty("maxVariable")) != null) {
            if (maxVariable.equals("space")) {
                this.uca.setMaxVariable(4096);
            } else if (maxVariable.equals("punct")) {
                this.uca.setMaxVariable(4097);
            } else if (maxVariable.equals("symbol")) {
                this.uca.setMaxVariable(4098);
            } else if (maxVariable.equals("currency")) {
                this.uca.setMaxVariable(4099);
            } else if (fallbackError) {
                this.error("maxVariable", "space|punct|symbol|currency");
            }
        }
        if ((alternate = props.getProperty("alternate")) != null) {
            switch (alternate) {
                case "non-ignorable": {
                    this.uca.setAlternateHandlingShifted(false);
                    break;
                }
                case "shifted": {
                    this.uca.setAlternateHandlingShifted(true);
                    break;
                }
                case "blanked": {
                    this.uca.setAlternateHandlingShifted(true);
                    if (!"quaternary".equals(props.getProperty("strength"))) break;
                    this.setStrength(2);
                    break;
                }
                default: {
                    if (!fallbackError) break;
                    this.error("alternate", "non-ignorable|shifted|blanked", alternate);
                }
            }
        }
        if ((backwards = props.getProperty("backwards")) != null) {
            switch (backwards) {
                case "yes": {
                    this.uca.setFrenchCollation(true);
                    break;
                }
                case "no": {
                    this.uca.setFrenchCollation(false);
                    break;
                }
                default: {
                    if (!fallbackError) break;
                    this.error("backwards", "yes|no");
                }
            }
        }
        if ((normalization = props.getProperty("normalization")) != null) {
            switch (normalization) {
                case "yes": {
                    this.uca.setDecomposition(17);
                    break;
                }
                case "no": {
                    this.uca.setDecomposition(16);
                    break;
                }
                default: {
                    if (!fallbackError) break;
                    this.error("normalization", "yes|no");
                }
            }
        }
        if ((caseLevel = props.getProperty("caseLevel")) != null) {
            switch (caseLevel) {
                case "yes": {
                    this.uca.setCaseLevel(true);
                    break;
                }
                case "no": {
                    this.uca.setCaseLevel(false);
                    break;
                }
                default: {
                    if (!fallbackError) break;
                    this.error("caseLevel", "yes|no");
                }
            }
        }
        if ((caseFirst = props.getProperty("caseFirst")) != null) {
            switch (caseFirst) {
                case "upper": {
                    this.uca.setUpperCaseFirst(true);
                    break;
                }
                case "lower": {
                    this.uca.setLowerCaseFirst(true);
                    break;
                }
                default: {
                    if (!fallbackError) break;
                    this.error("caseFirst", "upper|lower");
                }
            }
        }
        if ((numeric = props.getProperty("numeric")) != null) {
            switch (numeric) {
                case "yes": {
                    this.uca.setNumericCollation(true);
                    break;
                }
                case "no": {
                    this.uca.setNumericCollation(false);
                    break;
                }
                default: {
                    if (!fallbackError) break;
                    this.error("numeric", "yes|no");
                }
            }
        }
        if ((reorder = props.getProperty("reorder")) != null) {
            ArrayList<Integer> codesInt = new ArrayList<Integer>();
            for (String param : reorder.split(",")) {
                if (param.equals("space")) {
                    codesInt.add(4096);
                    continue;
                }
                if (param.equals("punct")) {
                    codesInt.add(4097);
                    continue;
                }
                if (param.equals("symbol")) {
                    codesInt.add(4098);
                    continue;
                }
                if (param.equals("currency")) {
                    codesInt.add(4099);
                    continue;
                }
                if (param.equals("digit")) {
                    codesInt.add(4100);
                    continue;
                }
                if (param.length() == 4) {
                    int[] script = UScript.getCode((String)param);
                    if (script != null) {
                        codesInt.add(script[0]);
                        continue;
                    }
                    if (!fallbackError) continue;
                    this.error("reorder-code", "space|punct|symbol|currency|digit or 4-character script");
                    continue;
                }
                if (!fallbackError) continue;
                this.error("reorder-code", "space|punct|symbol|currency|digit or 4-character script");
            }
            int[] codes = new int[codesInt.size()];
            int i = 0;
            for (Integer n : codesInt) {
                codes[i++] = n;
            }
            this.uca.setReorderCodes(codes);
        }
        CSharp.emitCode("#pragma warning disable 618");
        int m = this.uca.getVariableTop();
        CSharp.emitCode("#pragma warning restore 618");
        this.maxIgnorable = new int[]{m, m, m, m, 0};
    }

    private static Locale makeLocale(String language, String country, String variant) {
        return new Locale(language, country, variant);
    }

    private Properties parseProps(String uri) throws XPathException {
        String fallback;
        URI uuri;
        try {
            uuri = new URI(uri);
        }
        catch (URISyntaxException err) {
            throw new XPathException(err);
        }
        ArrayList<String> unknownKeys = new ArrayList<String>();
        Properties props = new Properties();
        String query = AnyURIValue.decode(uuri.getRawQuery());
        if (query != null && !query.isEmpty()) {
            if (query.startsWith("?")) {
                query = query.substring(1);
            }
            for (String s : query.split(";")) {
                String[] tokens = s.split("=");
                if (!keys.contains(tokens[0])) {
                    unknownKeys.add(tokens[0]);
                }
                String value = tokens.length >= 2 ? tokens[1] : "";
                props.setProperty(tokens[0], value);
            }
        }
        if ((fallback = props.getProperty("fallback")) != null && fallback.equals("no") && !unknownKeys.isEmpty()) {
            StringBuilder message = new StringBuilder(unknownKeys.size() > 1 ? "unknown parameters:" : "unknown parameter:");
            for (String u : unknownKeys) {
                message.append(u).append(" ");
            }
            this.error(message.toString());
        }
        return props;
    }

    public void setStrength(int newStrength) {
        this.uca.setStrength(newStrength);
    }

    public int getStrength() {
        return this.uca.getStrength();
    }

    @Override
    public boolean comparesEqual(UnicodeString s1, UnicodeString s2) {
        return this.uca.compare(s1.toString(), s2.toString()) == 0;
    }

    @Override
    public String getCollationURI() {
        return this.uri;
    }

    @Override
    public int compareStrings(UnicodeString o1, UnicodeString o2) {
        return this.uca.compare(o1.toString(), o2.toString());
    }

    @Override
    public AtomicMatchKey getCollationKey(UnicodeString s) {
        CollationKey ck = this.getCollationKey(s.toString());
        return new CollationMatchKey(ck);
    }

    @Override
    public boolean contains(UnicodeString s1, UnicodeString s2) {
        RuleBasedCollator collator = this.getRuleBasedCollator();
        CollationElementIterator iter1 = collator.getCollationElementIterator(s1.toString());
        CollationElementIterator iter2 = collator.getCollationElementIterator(s2.toString());
        return this.collationContains(iter1, iter2, null, false);
    }

    @Override
    public boolean endsWith(UnicodeString s1, UnicodeString s2) {
        RuleBasedCollator collator = this.getRuleBasedCollator();
        CollationElementIterator iter1 = collator.getCollationElementIterator(s1.toString());
        CollationElementIterator iter2 = collator.getCollationElementIterator(s2.toString());
        return this.collationContains(iter1, iter2, null, true);
    }

    @Override
    public boolean startsWith(UnicodeString s1, UnicodeString s2) {
        RuleBasedCollator collator = this.getRuleBasedCollator();
        CollationElementIterator iter1 = collator.getCollationElementIterator(s1.toString());
        CollationElementIterator iter2 = collator.getCollationElementIterator(s2.toString());
        return this.collationStartsWith(iter1, iter2);
    }

    @Override
    public UnicodeString substringAfter(UnicodeString s1, UnicodeString s2) {
        int[] ia;
        CollationElementIterator iter2;
        String g1;
        RuleBasedCollator collator = this.getRuleBasedCollator();
        CollationElementIterator iter1 = collator.getCollationElementIterator(g1 = s1.toString());
        boolean ba = this.collationContains(iter1, iter2 = collator.getCollationElementIterator(s2.toString()), ia = new int[2], false);
        if (ba) {
            return s1.substring(ia[1]);
        }
        return EmptyUnicodeString.getInstance();
    }

    @Override
    public UnicodeString substringBefore(UnicodeString s1, UnicodeString s2) {
        int[] ib;
        CollationElementIterator iter2;
        String g1;
        RuleBasedCollator collator = this.getRuleBasedCollator();
        CollationElementIterator iter1 = collator.getCollationElementIterator(g1 = s1.toString());
        boolean bb = this.collationContains(iter1, iter2 = collator.getCollationElementIterator(s2.toString()), ib = new int[2], false);
        if (bb) {
            return s1.substring(0L, ib[0]);
        }
        return EmptyUnicodeString.getInstance();
    }

    private boolean collationStartsWith(CollationElementIterator s0, CollationElementIterator s1) {
        this.makeStrengthObject();
        while (true) {
            int e0;
            int e1;
            if (this.strengthLevel.isIgnored(e1 = s1.next())) {
                continue;
            }
            if (e1 == -1) {
                return true;
            }
            while (this.strengthLevel.isIgnored(e0 = s0.next())) {
            }
            if (e0 == -1) {
                return false;
            }
            if (this.strengthLevel.compareCollationElements(e0, e1) != 0) break;
        }
        return false;
    }

    private String show(int ce) {
        return "" + CollationElementIterator.primaryOrder((int)ce) + "/" + CollationElementIterator.secondaryOrder((int)ce) + "/" + CollationElementIterator.tertiaryOrder((int)ce);
    }

    private void makeStrengthObject() {
        if (this.strengthLevel == null) {
            switch (this.getStrength()) {
                case 0: {
                    this.strengthLevel = new Primary(this);
                    break;
                }
                case 1: {
                    this.strengthLevel = new Secondary(this);
                    break;
                }
                case 2: {
                    this.strengthLevel = new Tertiary(this);
                    break;
                }
                default: {
                    this.strengthLevel = new Identical(this);
                }
            }
        }
    }

    private boolean collationContains(CollationElementIterator s0, CollationElementIterator s1, int[] offsets, boolean matchAtEnd) {
        int e1;
        this.makeStrengthObject();
        while (this.strengthLevel.isIgnored(e1 = s1.next())) {
        }
        if (e1 == -1) {
            return true;
        }
        int e0 = -1;
        while (true) {
            if (this.strengthLevel.compareCollationElements(e0, e1) != 0) {
                while (this.strengthLevel.isIgnored(e0 = s0.next())) {
                }
                if (e0 != -1) continue;
                return false;
            }
            int start = s0.getOffset();
            if (this.collationStartsWith(s0, s1)) {
                if (matchAtEnd) {
                    while (this.strengthLevel.isIgnored(e0 = s0.next())) {
                    }
                    if (e0 == -1) {
                        return true;
                    }
                } else {
                    if (offsets != null) {
                        offsets[0] = start - 1;
                        offsets[1] = s0.getOffset();
                    }
                    return true;
                }
            }
            s0.setOffset(start);
            if (s0.getOffset() != start) {
                s0.next();
            }
            s1.reset();
            e0 = -1;
            while (this.strengthLevel.isIgnored(e1 = s1.next())) {
            }
        }
    }

    private static class Identical
    extends Strength {
        public Identical(UcaCollatorUsingIcu collator) {
            super(collator);
        }

        @Override
        public int compareCollationElements(int ce1, int ce2) {
            return Integer.compare(ce1, ce2);
        }

        @Override
        public boolean isIgnored(int ce) {
            return false;
        }
    }

    private static class Tertiary
    extends Strength {
        public Tertiary(UcaCollatorUsingIcu collator) {
            super(collator);
        }

        @Override
        public int compareCollationElements(int ce1, int ce2) {
            int c1 = Integer.compare(CollationElementIterator.primaryOrder((int)ce1), CollationElementIterator.primaryOrder((int)ce2));
            if (c1 == 0) {
                int c2 = Integer.compare(CollationElementIterator.secondaryOrder((int)ce1), CollationElementIterator.secondaryOrder((int)ce2));
                if (c2 == 0) {
                    return Integer.compare(CollationElementIterator.tertiaryOrder((int)ce1), CollationElementIterator.tertiaryOrder((int)ce2));
                }
                return c2;
            }
            return c1;
        }

        @Override
        public boolean isIgnored(int ce) {
            return ce != -1 && CollationElementIterator.secondaryOrder((int)ce) < 6 && CollationElementIterator.primaryOrder((int)ce) < CollationElementIterator.primaryOrder((int)this.collator.maxIgnorable[0]);
        }
    }

    private static class Secondary
    extends Strength {
        public Secondary(UcaCollatorUsingIcu collator) {
            super(collator);
        }

        @Override
        public int compareCollationElements(int ce1, int ce2) {
            int c1 = Integer.compare(CollationElementIterator.primaryOrder((int)ce1), CollationElementIterator.primaryOrder((int)ce2));
            if (c1 == 0) {
                return Integer.compare(CollationElementIterator.secondaryOrder((int)ce1), CollationElementIterator.secondaryOrder((int)ce2));
            }
            return c1;
        }

        @Override
        public boolean isIgnored(int ce) {
            return false;
        }
    }

    private static class Primary
    extends Strength {
        public Primary(UcaCollatorUsingIcu collator) {
            super(collator);
        }

        @Override
        public int compareCollationElements(int ce1, int ce2) {
            return Integer.compare(CollationElementIterator.primaryOrder((int)ce1), CollationElementIterator.primaryOrder((int)ce2));
        }

        @Override
        public boolean isIgnored(int ce) {
            return ce != -1 && (CollationElementIterator.primaryOrder((int)ce) == 0 || ce < this.collator.maxIgnorable[0]);
        }
    }

    private static abstract class Strength {
        protected UcaCollatorUsingIcu collator;

        public Strength(UcaCollatorUsingIcu thisCollator) {
            this.collator = thisCollator;
        }

        public abstract int compareCollationElements(int var1, int var2);

        public abstract boolean isIgnored(int var1);
    }
}

