/*
 * Decompiled with CFR 0.152.
 */
package de.ids_mannheim.korap.response.match;

import de.ids_mannheim.korap.response.Match;
import de.ids_mannheim.korap.response.match.HighlightCombinatorElement;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Stack;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HighlightCombinator {
    private static final Logger log = LoggerFactory.getLogger(Match.class);
    public static final boolean DEBUG = false;
    private LinkedList<HighlightCombinatorElement> combine;
    private Stack<Integer> balanceStack = new Stack();
    private Stack<Integer> tempStack = new Stack();

    public HighlightCombinator() {
        this.combine = new LinkedList();
    }

    public LinkedList<HighlightCombinatorElement> list() {
        return this.combine;
    }

    public HighlightCombinatorElement getFirst() {
        return this.combine.getFirst();
    }

    public HighlightCombinatorElement getLast() {
        return this.combine.getLast();
    }

    public HighlightCombinatorElement get(int index) {
        return this.combine.get(index);
    }

    public short size() {
        return (short)this.combine.size();
    }

    public void addString(String characters) {
        this.combine.add(new HighlightCombinatorElement(characters));
    }

    public void addOpen(int number) {
        this.combine.add(new HighlightCombinatorElement(1, number));
        this.balanceStack.push(number);
    }

    public void addEmpty(int pagenumber) {
        this.combine.add(new HighlightCombinatorElement(3, pagenumber));
    }

    public void addClose(int number) {
        HighlightCombinatorElement lastComb;
        this.tempStack.clear();
        if (this.balanceStack.empty()) {
            return;
        }
        int eold = this.balanceStack.pop();
        while (eold != number) {
            lastComb = this.combine.peekLast();
            if (lastComb.type == 1 && lastComb.number == eold) {
                this.combine.removeLast();
            } else if (lastComb.type == 3) {
                log.error("The last element was empty -- and this is not correctly handled yet");
            } else {
                this.combine.add(new HighlightCombinatorElement(2, eold, false));
            }
            this.tempStack.push(eold);
            if (this.balanceStack.empty()) break;
            eold = this.balanceStack.pop();
        }
        lastComb = this.combine.peekLast();
        if (lastComb.type == 1 && lastComb.number == number) {
            while (lastComb.type == 1 && lastComb.number == number) {
                this.combine.removeLast();
                lastComb = this.combine.peekLast();
            }
        } else if (lastComb.type == 3) {
            System.err.println("\u00f6\u00f6\u00f6\u00f6\u00f6\u00f6\u00f6\u00f6\u00f6\u00f6\u00f6\u00f6\u00f6\u00f6\u00f6\u00f6\u00f6\u00f6\u00f6\u00f6\u00f6\u00f6\u00f6\u00f6");
        } else {
            this.combine.add(new HighlightCombinatorElement(2, number));
        }
        Iterator iterator = this.tempStack.iterator();
        while (iterator.hasNext()) {
            int e = (Integer)iterator.next();
            this.combine.add(new HighlightCombinatorElement(1, e));
            this.balanceStack.push(e);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (HighlightCombinatorElement e : this.combine) {
            sb.append(e.toString()).append("\n");
        }
        return sb.toString();
    }
}

