/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.validate;

import com.saxonica.ee.validate.AssertionTreeBuilder;
import com.saxonica.ee.validate.AttributeInheritor;
import com.saxonica.ee.validate.ConstraintChecker;
import net.sf.saxon.Controller;
import net.sf.saxon.lib.ConversionRules;
import net.sf.saxon.lib.InvalidityHandler;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.s9api.Location;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.ValidationFailure;
import net.sf.saxon.type.ValidationParams;
import net.sf.saxon.value.EmptySequence;

public class ValidationContext
extends ConversionRules {
    private ValidationParams validationParams;
    private Controller controller;
    private InvalidityHandler invalidityHandler;
    private SchemaType xsiType;
    private AttributeInheritor attributeInheritor;
    private ConstraintChecker constraintChecker;
    private String errorCode;
    private int errorCount = 0;
    private int errorLimit = Integer.MAX_VALUE;
    private Location initiatingLocation;
    private ValidationFailure firstFailure = null;
    private AssertionTreeBuilder assertionTreeBuilder = null;

    public ValidationContext(ConversionRules rules) {
        rules.copyTo(this);
    }

    public Controller getController() {
        return this.controller;
    }

    public void setController(Controller controller) {
        this.controller = controller;
    }

    public InvalidityHandler getInvalidityHandler() {
        return this.invalidityHandler;
    }

    public void setInvalidityHandler(InvalidityHandler invalidityHandler) {
        this.invalidityHandler = invalidityHandler;
    }

    public AssertionTreeBuilder getAssertionTreeBuilder() {
        return this.assertionTreeBuilder;
    }

    public void setAssertionTreeBuilder(AssertionTreeBuilder assertionTreeBuilder) {
        this.assertionTreeBuilder = assertionTreeBuilder;
    }

    public void startValidation(String systemId) {
        if (this.invalidityHandler != null) {
            try {
                this.invalidityHandler.startReporting(systemId);
            }
            catch (XPathException err) {
                this.invalidityHandler = null;
            }
        }
    }

    public Sequence getValidationErrorObject() {
        if (this.invalidityHandler != null) {
            try {
                return this.invalidityHandler.endReporting();
            }
            catch (XPathException e) {
                return EmptySequence.getInstance();
            }
        }
        return null;
    }

    public ValidationParams getValidationParams() {
        return this.validationParams;
    }

    public boolean hasValidationParams() {
        return this.validationParams != null && this.validationParams.size() != 0;
    }

    public void setValidationParams(ValidationParams validationParams) {
        this.validationParams = validationParams;
    }

    public void setConstraintChecker(ConstraintChecker checker) {
        this.constraintChecker = checker;
    }

    protected ConstraintChecker getConstraintChecker() {
        return this.constraintChecker;
    }

    public void setAttributeInheritor(AttributeInheritor inheritor) {
        this.attributeInheritor = inheritor;
    }

    public AttributeInheritor getAttributeInheritor() {
        return this.attributeInheritor;
    }

    public void setXSIType(SchemaType xsiType) {
        this.xsiType = xsiType;
    }

    public SchemaType getXSIType() {
        return this.xsiType;
    }

    public void setErrorCode(String errorCode) {
        this.errorCode = errorCode;
    }

    protected String getErrorCode() {
        return this.errorCode;
    }

    public void setErrorLimit(int limit) {
        this.errorLimit = limit;
    }

    public boolean incrementErrorCount(ValidationFailure failure) {
        if (this.firstFailure == null) {
            this.firstFailure = failure;
        }
        return ++this.errorCount >= this.errorLimit;
    }

    public ValidationFailure getFirstFailure() {
        return this.firstFailure;
    }

    public int getErrorCount() {
        return this.errorCount;
    }

    public Location getInitiatingLocation() {
        return this.initiatingLocation;
    }

    public void setInitiatingLocation(Location initiatingLocation) {
        this.initiatingLocation = initiatingLocation;
    }
}

