/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.bytecode;

import com.saxonica.ee.bytecode.CountCompiler;
import com.saxonica.ee.bytecode.ToIteratorCompiler;
import com.saxonica.ee.bytecode.util.Callback;
import com.saxonica.ee.bytecode.util.CannotCompileException;
import com.saxonica.ee.bytecode.util.CompilerService;
import com.saxonica.ee.bytecode.util.GeneratedMethodInfo;
import com.saxonica.ee.bytecode.util.Generator;
import com.saxonica.ee.bytecode.util.LabelInfo;
import com.saxonica.objectweb.asm.Type;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.TypeCheckingFilter;
import net.sf.saxon.expr.CardinalityChecker;
import net.sf.saxon.expr.CardinalityCheckingIterator;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ItemChecker;
import net.sf.saxon.expr.LastPositionFinder;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.Location;
import net.sf.saxon.expr.parser.RoleDiagnostic;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.pattern.DocumentNodeTest;
import net.sf.saxon.type.ItemType;

public class CardinalityCheckerCompiler
extends ToIteratorCompiler {
    @Override
    public void compileToItem(CompilerService compiler, Expression expression) throws CannotCompileException {
        Expression operand = ((CardinalityChecker)expression).getBaseExpression();
        int requiredCardinality = ((CardinalityChecker)expression).getRequiredCardinality();
        RoleDiagnostic role = ((CardinalityChecker)expression).getRoleLocator();
        Generator ga = compiler.getCurrentGenerator();
        GeneratedMethodInfo methodInfo = compiler.getCurrentMethod();
        CardinalityCheckerCompiler.visitAnnotation(compiler, "CardinalityCheckerCompiler-Item");
        compiler.compileToIterator(operand);
        ga.checkClass(SequenceIterator.class);
        if (requiredCardinality == 8192) {
            LabelInfo returnNull = methodInfo.newLabel("returnNull00");
            ga.invokeInstanceMethod(SequenceIterator.class, "next", new Class[0]);
            ga.ifNull(returnNull.label());
            compiler.generateDynamicError("An empty sequence is the only allowed value for the " + role.getMessage(), role.getErrorCode(), expression.getLocation(), true);
            methodInfo.placeLabel(returnNull);
            ga.pushNull();
        } else if (requiredCardinality == 24576) {
            LabelInfo returnFirst = methodInfo.newLabel("returnFirst01");
            ga.dup();
            ga.invokeInstanceMethod(SequenceIterator.class, "next", new Class[0]);
            ga.swap();
            ga.invokeInstanceMethod(SequenceIterator.class, "next", new Class[0]);
            ga.ifNull(returnFirst.label());
            CardinalityCheckerCompiler.allocateStatic(compiler, expression);
            compiler.generateGetContext();
            ga.invokeStaticMethod(Callback.class, "makeMultipleItemsException", CardinalityChecker.class, XPathContext.class);
            ga.throwException();
            methodInfo.placeLabel(returnFirst);
        } else if (requiredCardinality == 16384) {
            LabelInfo notEmpty = methodInfo.newLabel("notEmpty11");
            LabelInfo returnFirst = methodInfo.newLabel("returnFirst11");
            ga.dup();
            ga.invokeInstanceMethod(SequenceIterator.class, "next", new Class[0]);
            ga.dup();
            ga.ifNonNull(notEmpty.label());
            compiler.generateDynamicError("An empty sequence is not allowed as the " + role.getMessage(), role.getErrorCode(), expression.getLocation(), true);
            methodInfo.placeLabel(notEmpty);
            ga.swap();
            ga.invokeInstanceMethod(SequenceIterator.class, "next", new Class[0]);
            ga.ifNull(returnFirst.label());
            CardinalityCheckerCompiler.allocateStatic(compiler, expression);
            compiler.generateGetContext();
            ga.invokeStaticMethod(Callback.class, "makeMultipleItemsException", CardinalityChecker.class, XPathContext.class);
            ga.throwException();
            methodInfo.placeLabel(returnFirst);
        } else {
            throw new IllegalStateException("CardinalityChecker: compileToItem called when multiple items allowed");
        }
    }

    @Override
    public void compileToIterator(CompilerService compiler, Expression expression) throws CannotCompileException {
        Expression base = ((CardinalityChecker)expression).getBaseExpression();
        Generator ga = compiler.getCurrentGenerator();
        GeneratedMethodInfo methodInfo = compiler.getCurrentMethod();
        int requiredCardinality = ((CardinalityChecker)expression).getRequiredCardinality();
        RoleDiagnostic role = ((CardinalityChecker)expression).getRoleLocator();
        CardinalityCheckerCompiler.visitAnnotation(compiler, "CardinalityCheckerCompiler-Itr");
        CardinalityCheckerCompiler.visitLineNumber(compiler, ga, expression);
        LabelInfo notLastFinder = methodInfo.newLabel("notLastFinder");
        LabelInfo ok = methodInfo.newLabel("cardinalityOK");
        compiler.compileToIterator(base);
        if (CountCompiler.maybeLastPositionFinder(base)) {
            ga.dup();
            ga.invokeInstanceMethod(SequenceIterator.class, "getProperties", new Class[0]);
            ga.push(2);
            ga.math(126, Type.INT_TYPE);
            ga.ifZCmp(153, notLastFinder.label());
            ga.dup();
            ga.checkClass(LastPositionFinder.class);
            ga.invokeInstanceMethod(LastPositionFinder.class, "getLength", new Class[0]);
            if (requiredCardinality == 8192) {
                ga.ifZCmp(153, ok.label());
                compiler.generateDynamicError("An empty sequence is the only allowed value for the " + role.getMessage(), role.getErrorCode(), expression.getLocation(), true);
            } else if (requiredCardinality == 24576) {
                ga.push(1);
                ga.ifICmp(158, ok.label());
                CardinalityCheckerCompiler.allocateStatic(compiler, expression);
                compiler.generateGetContext();
                ga.invokeStaticMethod(Callback.class, "makeMultipleItemsException", CardinalityChecker.class, XPathContext.class);
                ga.throwException();
            } else if (requiredCardinality == 16384) {
                LabelInfo notEmpty = methodInfo.newLabel("cardinalityNotEmpty");
                LabelInfo notOk = methodInfo.newLabel("cardinalityNotOK");
                ga.dup();
                ga.push(1);
                ga.ifICmp(154, notOk.label());
                ga.pop();
                ga.goTo(ok);
                methodInfo.placeLabel(notOk);
                ga.ifZCmp(154, notEmpty.label());
                compiler.generateDynamicError("An empty sequence is not allowed as the " + role.getMessage(), role.getErrorCode(), expression.getLocation(), true);
                methodInfo.placeLabel(notEmpty);
                CardinalityCheckerCompiler.allocateStatic(compiler, expression);
                compiler.generateGetContext();
                ga.invokeStaticMethod(Callback.class, "makeMultipleItemsException", CardinalityChecker.class, XPathContext.class);
                ga.throwException();
            } else if (requiredCardinality == 49152) {
                ga.ifZCmp(154, ok.label());
                compiler.generateDynamicError("An empty sequence is not allowed as the " + role.getMessage(), role.getErrorCode(), expression.getLocation(), true);
            } else {
                throw new IllegalStateException("Unexpected required cardinality " + requiredCardinality);
            }
            methodInfo.placeLabel(notLastFinder);
        }
        ga.newInstance(Type.getType(CardinalityCheckingIterator.class));
        ga.swap();
        ga.dup2();
        ga.push(requiredCardinality);
        CardinalityCheckerCompiler.allocateStatic(compiler, role);
        CardinalityCheckerCompiler.allocateStatic(compiler, expression.getLocation());
        ga.invokeConstructor(CardinalityCheckingIterator.class, SequenceIterator.class, Integer.TYPE, RoleDiagnostic.class, Location.class);
        ga.pop();
        methodInfo.placeLabel(ok);
        ga.checkClass(SequenceIterator.class);
    }

    @Override
    public void compileToPush(CompilerService compiler, Expression expression) throws CannotCompileException {
        CardinalityChecker cc = (CardinalityChecker)expression;
        Generator ga = compiler.getCurrentGenerator();
        GeneratedMethodInfo methodInfo = compiler.getCurrentMethod();
        Expression next = cc.getBaseExpression();
        ItemType type = net.sf.saxon.type.Type.ITEM_TYPE;
        if (next instanceof ItemChecker) {
            type = ((ItemChecker)next).getRequiredType();
            next = ((ItemChecker)next).getBaseExpression();
        }
        if ((next.getImplementationMethod() & 4) != 0 && !(type instanceof DocumentNodeTest)) {
            ga.newInstance(TypeCheckingFilter.class);
            ga.dup();
            compiler.generateGetReceiver();
            ga.invokeConstructor(TypeCheckingFilter.class, Receiver.class);
            int filterVar = methodInfo.allocateLocal(TypeCheckingFilter.class);
            ga.storeLocal(filterVar);
            ga.loadLocal(filterVar);
            CardinalityCheckerCompiler.allocateStatic(compiler, type);
            ga.push(cc.getRequiredCardinality());
            CardinalityCheckerCompiler.allocateStatic(compiler, cc.getRoleLocator());
            CardinalityCheckerCompiler.allocateStatic(compiler, cc.getLocation());
            ga.invokeInstanceMethod(TypeCheckingFilter.class, "setRequiredType", ItemType.class, Integer.TYPE, RoleDiagnostic.class, Location.class);
            ga.loadLocal(filterVar);
            compiler.pushNewReceiverInfo(ga);
            compiler.compileToPush(next);
            ga.loadLocal(filterVar);
            ga.invokeInstanceMethod(TypeCheckingFilter.class, "close", new Class[0]);
            compiler.popReceiverInfo();
        } else {
            super.compileToPush(compiler, expression);
        }
    }
}

